#pragma once
#include "actorobject.h"
///////////////////////////////////////////////////////////////
class CCubeReservoir;
///////////////////////////////////////////////////////////////
class CCube :public IBaseActorObject
{
friend class CCubeReservoir;
private:
    // OnCreate(CActorReservoir<>::Initialize)̈
    struct SCreateParam
    {
        Scene::ISceneManager* pManager;
        Renderer::Object::IModel* pModel;
    };
    // OnInitialize(CActorReservoir<>::GetNewActiveObject)̈͂Ȃ
    // CActorReservoir<>::GetNewActiveObjectŎ擾Ƀp[^ݒ
private:
    // OnCreate
    Scene::IModelActor* m_ModelActor;
    // OnInitialize
    Math::Vector3D  m_Position;
    Math::Quaternion m_Direction;
    Math::Vector3D   m_Velocity;
    Math::Quaternion m_Rotation;
    //
    bool m_IsKilled;
public:
    CCube(void);
    ~CCube(void);
    //
protected:
    bool OnCreate(void* pParam);
    bool OnInitialize(void* pParam);
    bool OnFinalize(void);
    bool OnDestroy(void);
public:
    bool IsKilled(void);
public:
    bool OnUpdate(void);
    bool OnDraw(void);
public:
    void SetPosition(const Math::Vector3D& Position);
    void SetDirection(const Math::Quaternion& Direction);
    void SetVelocity(const Math::Vector3D& Velocity);
    void SetRotation(const Math::Quaternion& Rotation);
};
///////////////////////////////////////////////////////////////
class CCubeReservoir :private CActorReservoir<CCube>
{
private:
    Renderer::Object::IModel* m_pModel;
public:
    CCubeReservoir(void);
    ~CCubeReservoir(void);
    //
    bool Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager);
    bool Finalize(void);
    //
    CCube* GetNewActiveObject(void);
    CReservoirIterator<CCube> GetActiveObjectIterator(void);
    //
    bool Update(void);
    bool Draw(void);
};