#include "cube.h"
///////////////////////////////////////////////////////////////
CCube::CCube(void)
:IBaseActorObject(ACTOR_OBJECT_CUBE)
{
    m_ModelActor=NULL;
    //
    m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
}
///////////////////////////////////////////////////////////////
CCube::~CCube(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCube::OnCreate(void* pParam)
{
    SCreateParam* pConvParam=((SCreateParam*)pParam);
    //
    m_ModelActor=pConvParam->pManager->CreateActor(pConvParam->pModel);
    if(m_ModelActor==NULL){return false;}
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnInitialize(void* pParam)
{
    // m_Position=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Direction=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    // m_Velocity=Math::Vector3D(0.0f,0.0f,0.0f);
    // m_Rotation=Math::Quaternion(0.0f,0.0f,0.0f,1.0f);
    //
    m_IsKilled=false;
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnFinalize(void)
{
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnDestroy(void)
{
    SAFE_RELEASE(m_ModelActor);
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::IsKilled(void)
{
    return m_IsKilled;
}
///////////////////////////////////////////////////////////////
bool CCube::OnUpdate(void)
{
    //
    m_Position+=m_Velocity;
    m_Direction.Mul(m_Rotation,m_Direction); // 
    m_Direction.Mul(Math::Quaternion(0.0f,0.0f,0.0f,1.0f/m_Direction.Length())); // normalize
    // _30.0fꂽ
    if(m_Position.Length()>30.0f)
    {
        m_IsKilled=true;
        Release();
        return true;
    }
    // 
    m_ModelActor->TransformReset();
    m_ModelActor->RotationQuaternion(m_Direction);
    m_ModelActor->Translation(m_Position);
    m_ModelActor->TransformUpdate();
    //
    return true;
}
///////////////////////////////////////////////////////////////
bool CCube::OnDraw(void)
{
    m_ModelActor->RenderingRequest();
    return true;
}
///////////////////////////////////////////////////////////////
void CCube::SetPosition(const Math::Vector3D& Position)
{
    m_Position=Position;
}
///////////////////////////////////////////////////////////////
void CCube::SetDirection(const Math::Quaternion& Direction)
{
    m_Direction=Direction;
}
///////////////////////////////////////////////////////////////
void CCube::SetVelocity(const Math::Vector3D& Velocity)
{
    m_Velocity=Velocity;
}
///////////////////////////////////////////////////////////////
void CCube::SetRotation(const Math::Quaternion& Rotation)
{
    m_Rotation=Rotation;
}
///////////////////////////////////////////////////////////////
CCubeReservoir::CCubeReservoir(void)
{
    m_pModel=NULL;
}
///////////////////////////////////////////////////////////////
CCubeReservoir::~CCubeReservoir(void)
{
    ;
}
///////////////////////////////////////////////////////////////
bool CCubeReservoir::Initialize(int ObjectCount,Renderer::IRender* pRender,Scene::ISceneManager* pManager)
{
    m_pModel=pRender->CreateModelFromFile("cube.smf");
    if(m_pModel==NULL){return false;}
    //
    CCube::SCreateParam Param;
    Param.pManager=pManager;
    Param.pModel=m_pModel;
    //
    return CActorReservoir<CCube>::Initialize(ObjectCount,&Param);
}
///////////////////////////////////////////////////////////////
bool CCubeReservoir::Finalize(void)
{
    if(!CActorReservoir<CCube>::Finalize()){return false;}
    SAFE_RELEASE(m_pModel);
    //
    return true;
}
///////////////////////////////////////////////////////////////
CCube* CCubeReservoir::GetNewActiveObject(void)
{
    return CActorReservoir<CCube>::GetNewActiveObject(NULL);
}
///////////////////////////////////////////////////////////////
CReservoirIterator<CCube> CCubeReservoir::GetActiveObjectIterator(void)
{
    return CActorReservoir<CCube>::GetActiveObjectIterator();
}
///////////////////////////////////////////////////////////////
bool CCubeReservoir::Update(void)
{
    return CActorReservoir<CCube>::Update();
}
///////////////////////////////////////////////////////////////
bool CCubeReservoir::Draw(void)
{
    return CActorReservoir<CCube>::Draw();
}
///////////////////////////////////////////////////////////////