#pragma once
#include "reservoir.h"
#include "actorobject_type.h"
///////////////////////////////////////////////////////////////
// AN^[NX
class IBaseActorObject:public IBaseReserveObject
{
//public:
//    IBaseReserveObject(void);
//    virtual ~IBaseReserveObject(void);
//    //
//    int AddRef(void);
//    void Release(void);
//protected:
//    virtual bool OnCreate(void* pParam)=0;
//    virtual bool OnInitialize(void* pParam)=0;
//    virtual bool OnFinalize(void)=0;
//    virtual bool OnDestroy(void)=0;
private:
    eActorObjectType m_ObjectType;
public:
    IBaseActorObject(eActorObjectType ObjectType);
    ~IBaseActorObject(void);
    //
    eActorObjectType GetObjectType(void);
public:
    virtual bool IsKilled(void)=0;
public:
    virtual bool OnUpdate(void)=0;
    virtual bool OnDraw(void)=0;
};
// ꊇUpdate/Draw@\ǉ
template <typename C> class CActorReservoir:public CReservoir<C>
{
public:
    bool Update(void)
    {
        CReservoirIterator<C> It=GetActiveObjectIterator();
        ++It;
        //
        while(!It.IsEnd())
        {
            if(!It.Object()->IsKilled())
            {
                if(!It.Object()->OnUpdate())
                {
                    return false;
                }
            }
            //
            ++It;
        }
        //
        return true;
    };
    //
    bool Draw(void)
    {
        CReservoirIterator<C> It=GetActiveObjectIterator();
        ++It;
        //
        while(!It.IsEnd())
        {
            if(!It.Object()->IsKilled())
            {
                if(!It.Object()->OnDraw())
                {
                    return false;
                }
            }
            //
            ++It;
        }
        //
        return true;
    };
};