#include <iostream>
#include "actorobject.h"
///////////////////////////////////////////////////////////////
class CTestObject:public IBaseActorObject
{
private:
    enum eStatus
    {
        STATUS_CONSTRUCTOR,
        STATUS_CREATE,
        STATUS_INITIALIZE,
        STATUS_FINALIZE,
        STATUS_DESTROY,
        STATUS_UPDATE,
        STATUS_DRAW,
    };
    //
    eStatus m_Status;
public:
    CTestObject(void)
    :IBaseActorObject(ACTOR_OBJECT_TEST)
    {
        m_Status=STATUS_CONSTRUCTOR;
    }
    ~CTestObject(void)
    {
        ;
    }
protected:
    bool OnCreate(void* pParam)
    {
        m_Status=STATUS_CREATE;
        return true;
    }
    bool OnInitialize(void* pParam)
    {
        m_Status=STATUS_INITIALIZE;
        return true;
    }
    bool OnFinalize(void)
    {
        m_Status=STATUS_FINALIZE;
        return true;
    }
    bool OnDestroy(void)
    {
        m_Status=STATUS_DESTROY;
        return true;
    }
public:
    bool IsKilled(void)
    {
        return false;
    }
public:
    bool OnUpdate(void)
    {
        m_Status=STATUS_UPDATE;
        return true;
    }
    bool OnDraw(void)
    {
        m_Status=STATUS_DRAW;
        return true;
    }
};
///////////////////////////////////////////////////////////////
int main(int Argc,char* Argv[])
{
    //
    CActorReservoir<CTestObject> Res;
    Res.Initialize(100,NULL);
    //
    CTestObject* pObject=Res.GetNewActiveObject(NULL);
    //
    Res.Update();
    Res.Draw();
    //
    CReservoirIterator<CTestObject> It=Res.GetActiveObjectIterator();
    ++It;
    SAFE_RELEASE(pObject);
    --It;
    //
    Res.Update();
    Res.Draw();
    //
    Res.Finalize();
    //
    return 0;
}