#include <iostream>
#include "reservoir.h"
///////////////////////////////////////////////////////////////
class CTestObject:public IBaseReserveObject
{
private:
    enum eStatus
    {
        STATUS_CONSTRUCTOR,
        STATUS_CREATE,
        STATUS_INITIALIZE,
        STATUS_FINALIZE,
        STATUS_DESTROY,
    };
    //
    eStatus m_Status;
public:
    CTestObject(void)
    {
        m_Status=STATUS_CONSTRUCTOR;
    }
    ~CTestObject(void)
    {
        ;
    }
protected:
    bool OnCreate(void* pParam)
    {
        m_Status=STATUS_CREATE;
        return true;
    }
    bool OnInitialize(void* pParam)
    {
        m_Status=STATUS_INITIALIZE;
        return true;
    }
    bool OnFinalize(void)
    {
        m_Status=STATUS_FINALIZE;
        return true;
    }
    bool OnDestroy(void)
    {
        m_Status=STATUS_DESTROY;
        return true;
    }

};
///////////////////////////////////////////////////////////////
int main(int Argc,char* Argv[])
{
    //
    CReservoir<CTestObject> Res;
    Res.Initialize(100,NULL);
    //
    CTestObject* pObject=Res.GetNewActiveObject(NULL);
    CReservoirIterator<CTestObject> It=Res.GetActiveObjectIterator();
    ++It;
    SAFE_RELEASE(pObject);
    ++It;
    --It;
    bool Result=It.IsEnd();
    //
    Res.Finalize();
    //
    return 0;
}