#include <Selene.h>
///////////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
    using namespace Selene;
    // 
    ICore* pCore=NULL;
    IGraphicCard* pGraphicCard=NULL;
    Renderer::IRender* pRender=NULL;
    Peripheral::IKeyboard* pKeyboard=NULL;
    //
    Renderer::Object::IModel* pModel=NULL; // *
    Scene::ISceneManager* pSceneManager=NULL; // *
    Scene::ICamera* pCamera=NULL; // *
    Scene::IModelActor* pActor=NULL; // *
    // *Actor̈ʒu*
    Math::Vector3D Pos(0.0f,0.0f,0.0f); // *
    // VXȅ
    System::Initialize();
    // RA̐ 
    pCore=System::CreateCore();
    // 
    if(!pCore->Initialize("Hello World",FRAME_RATE_60)){goto EXIT;}
    // ^Cgo[ɏ\
    pCore->EnableDrawTitleInformation(true);
    // OtBbNJ[h擾
    pGraphicCard=pCore->CreateGraphicCard(GRAPHIC_CARD_DEFAULT_NO);
    if(pGraphicCard==NULL){goto EXIT;}
    // EBhE쐬(640x480,WindowMode)
    pCore->Start(640,480,true);
    // _[擾
    pRender=pGraphicCard->CreateRender();
    if(pGraphicCard==NULL){goto EXIT;}
    // L[{[h擾
    pKeyboard=pCore->GetKeyboard();
    if(pKeyboard==NULL){goto EXIT;}
    // *fǂݍݐ*
    pModel=pRender->CreateModelFromFile("torus.smf"); // *
    if(pModel==NULL){goto EXIT;} // *
    // *V[}l[W[𐶐*
    pSceneManager=pRender->CreateSceneManager(128,true); // *
    if(pSceneManager==NULL){goto EXIT;} // *
    // *V[}l[W[̏np[^ݒEXV*
    pSceneManager->InitParameter_RenderTargetData(NULL,Math::Point2DI(640,480),false); //*
    pSceneManager->InitParameter_Shading(SHADING_TYPE_NORMAL); // *
    pSceneManager->InitParameter_Update(); // *
    // *J̎擾Eݒ*
    pCamera=pSceneManager->GetCamera(); // *
    pCamera->UpdateProjection(1.0f,1000.0f,DEG_TO_ANGLE(45.0f),640,480); // *
    // *Actor̍쐬*
    pActor=pSceneManager->CreateActor(pModel); // *
    // C[v
    while(pCore->Run())
    {
        // *Update*
        if(pKeyboard->GetKeyData(SELENE_VK_LEFT)==TRUE){Pos.x-=0.05f;}  // *
        if(pKeyboard->GetKeyData(SELENE_VK_RIGHT)==TRUE){Pos.x+=0.05f;} // *
        if(pKeyboard->GetKeyData(SELENE_VK_UP)==TRUE){Pos.y+=0.05f;}    // *
        if(pKeyboard->GetKeyData(SELENE_VK_DOWN)==TRUE){Pos.y-=0.05f;}  // *
        // *Actor̈ʒuEp̍XV*
        pActor->TransformReset(); // *
        pActor->Translation(Pos); // *
        pActor->TransformUpdate(); // *
        // *J̈ʒuEp̍XV*
        pCamera->Reset(); // *
        pCamera->SetTransformSimple(Math::Vector3D(0.0f,0.0f,-8.0f),Math::Vector3D(0.0f,0.0f,0.0f),DEG_TO_ANGLE(0.0f)); // *
        pCamera->Update(); // *
        // *V[}l[W[̃Zbg*
        pSceneManager->Reset(); // *
        pSceneManager->SetParameter_BGColor(CColor(128,128,128)); // *
        // *V[ɕs𓖂Ă*
        pSceneManager->SetLightParameter_Directional(Math::Vector3D(0.5f,-0.5f,0.7f),Math::Vector3D(0.8f,0.8f,0.8f)); // *
        // *V[}l[W[ւ̃_ONGXg(Ȃ炸J̈ʒup߂Ă)*
        pSceneManager->Begin(false); // *
        pActor->RenderingRequest(); // *
        pSceneManager->End(); // *
        // ʂ̃NA(white)
        pRender->Clear(CColor(255,255,255));
        // ʂւ̕`Jn
        pRender->Begin();
        // *V[}l[W[`*
        pSceneManager->Rendering(true); // *
        // *(Actoř݈ʒu)`(black)*
        pRender->DrawText(Math::Point2DI(0,0),CColor(0,0,0),"Pos=[%2.2f,%2.2f,%2.2f];",Pos.x,Pos.y,Pos.z); // *
        // ʂւ̕` 
        pRender->End();
    }
    // J
EXIT:
    SAFE_RELEASE(pActor);  // *
    SAFE_RELEASE(pCamera); // *
    SAFE_RELEASE(pSceneManager); // *
    SAFE_RELEASE(pModel); // *
    //
    SAFE_RELEASE(pKeyboard);
    SAFE_RELEASE(pRender);
    SAFE_RELEASE(pGraphicCard);
    SAFE_RELEASE(pCore);
    // VXẻ
    System::Finalize();
    // I
    return 0;
}