//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmSearchItem.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfmSearchItem *fmSearchItem;

/****************************************************************************

	P R I V A T E

****************************************************************************/

//---------------------------------------------------------------------------
int TfmSearchItem::GetType(void)
{
	return type;
}

//---------------------------------------------------------------------------
void TfmSearchItem::SetType(int val)
{
	type = val;

	switch( type )
	{
	case 0:	// 0:Ȃ
		Visible = false;
		Edit1->Visible = false;
		ComboBox1->Visible = false;
		Panel2->Visible = false;
		break;

	case 1:	// 1:v
		Visible = true;
		Edit1->Visible = true;
		ComboBox1->Visible = false;
		Panel2->Visible = false;
		break;

	case 2:	// 2:l(`ȏA`ȉ)
		Visible = true;
		Edit1->Visible = false;
		ComboBox1->Visible = false;
		Panel2->Visible = true;
		break;

	case 3:	// 3:I
		Visible = true;
		Edit1->Visible = false;
		ComboBox1->Visible = true;
		Panel2->Visible = false;
		break;
	}
}
//---------------------------------------------------------------------------

void TfmSearchItem::SetItemName(UnicodeString text)
{
	CheckBox1->Caption = text;
}
//---------------------------------------------------------------------------


/****************************************************************************

	P U B L I C

****************************************************************************/

//---------------------------------------------------------------------------
__fastcall TfmSearchItem::TfmSearchItem(TComponent* Owner)
	: TForm(Owner)
{
	Visible = false;
	ClientHeight = Panel1->Height;
	Edit1->Parent = Panel1;
	Edit1->Align = alClient;
	ComboBox1->Parent = Panel1;
	ComboBox1->Align = alClient;
	Panel2->Parent = Panel1;
	Panel2->Align = alClient;
	Type = 0;

	Height = 30;
}
//---------------------------------------------------------------------------

bool __fastcall TfmSearchItem::Check(UnicodeString Text)
{
	int n = _wtoi( Text.w_str() );
	int lo = _wtoi( Edit2->Text.w_str() );
	int hi = _wtoi( Edit3->Text.w_str() );

	if (CheckBox1->Checked==false) {
		return true;
	}

	switch( type )
	{
	default:
		return true;

	case 1:	// 1:v
		return Text.Pos(Edit1->Text)!=0;

	case 2:	// 2:l(`ȏA`ȉ)
    return lo<=n && n<=hi;

	case 3:	// 3:I
		return ComboBox1->Text==Text;

	}
}
//---------------------------------------------------------------------------



