//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmSearch.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfmSearch *fmSearch;

/****************************************************************************

	P R I V A T E

****************************************************************************/


TfmSearchItem* TfmSearch::GetItem(UnicodeString Key)
{
	std::map<UnicodeString,TfmSearchItem*>::iterator Itr = items.find(Key);
	return Itr->second;
}
//---------------------------------------------------------------------------

/****************************************************************************

	P U B L I C

****************************************************************************/

//---------------------------------------------------------------------------
__fastcall TfmSearch::TfmSearch(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TfmSearch::Clear(void)
{
	std::map<UnicodeString,TfmSearchItem*>::iterator Itr = items.begin();

	while( Itr!=items.end() )
	{
		Itr->second->Visible = NULL;
		Itr->second->Parent = NULL;
		delete Itr->second;
		Itr->second = NULL;
		Itr++;
	}

	items.clear();
}
//---------------------------------------------------------------------------

TfmSearchItem* __fastcall TfmSearch::Add(UnicodeString Key,UnicodeString Text,int Type)
{
	TfmSearchItem *item = new TfmSearchItem(ScrollBox1);
	item->Visible = false;
	item->ItemName = Text;
	item->Parent = ScrollBox1;
	item->Align = alTop;
	item->Top = Height;
	item->Type = Type;

	items[Key] = item;

	return item;
}
//---------------------------------------------------------------------------

bool __fastcall TfmSearch::Execute(void)
{
	Tag = 0;
	ShowModal();

	return Tag==1;
}
//---------------------------------------------------------------------------

/****************************************************************************

	P U B L I S H E D

****************************************************************************/

void __fastcall TfmSearch::FormDestroy(TObject *Sender)
{
	Clear();
}
//---------------------------------------------------------------------------

void __fastcall TfmSearch::Button1Click(TObject *Sender)
{
	Tag = 1;
	Close();
}
//---------------------------------------------------------------------------

void __fastcall TfmSearch::Button2Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------

void __fastcall TfmSearch::FormShow(TObject *Sender)
{
	std::map<UnicodeString,TfmSearchItem*>::iterator Itr = items.begin();
	while( Itr!=items.end() )
	{
		Itr->second->CheckBox1->Checked = false;
		Itr->second->Edit1->Text = L"";
		Itr->second->Edit2->Text = L"0";
		Itr->second->Edit3->Text = L"99";
		Itr++;
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmSearch::FormKeyPress(TObject *Sender, wchar_t &Key)
{
	switch( Key )
	{
	case '\x1B':
		Close();
		break;
  }
}
//---------------------------------------------------------------------------

