//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "History.h"
#include "frmMain.h"
#include "TPluginGUI.h"
#include "TPluginList.h"
#include "frmPlugin.h"
#include "frmConfig.h"

#include "TLVSortPaint.hpp"


//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfmMain *fmMain;
TPluginGUI* Plugin;

/**
	@brief	CxgpID

		wv\IDg܂
*/
enum{
	MENU_CLOSE,		//!< 0 I
	MENU_NEW,     //!< 1 fbL
	MENU_OPEN,    //!< 2 fbLJ
	MENU_SAVE,    //!< 3 fbLۑ
	MENU_SEARCH,  //!< 4 
	MENU_CONFIG,  //!< 5 ݒ
	MENU_PLUGIN,	//!< 6 vOC؂ւ
	MENU_CLIP,		//!< 7 Nbv{[h

	MENU_ADD,			//!< 8 fbLACeǉ
	MENU_DEL,			//!< 9 fbLACe폜
	MENU_LAYER,		//!< 10 fbL؂ւ^u
	MENU_TEXT,		//!< 11 J[heLXg\

	MENU_HINT_IMAGE,	//!< 12 qg摜\
};



/** AvP[VpX */
#define	APP_PATH	ExtractFilePath(Application->ExeName)

#define PLUGIN_PATH	(APP_PATH + L"Plugin\\")

/** ݒt@C */
#define	APP_INI   APP_PATH + L"TcgExplorer.ini"

TLVSortPaint* LVSortPaint;

/****************************************************************************

	P R I V A T E

****************************************************************************/

UnicodeString TfmMain::GetTcgName(void)
{
	return tcgName;
}
//---------------------------------------------------------------------------

void TfmMain::SetTcgName(UnicodeString val)
{
	tcgName = val;
	Caption = UnicodeString().sprintf(L"%s - %s -",APP_NAME,tcgName.c_str());
}
//---------------------------------------------------------------------------

void TfmMain::Config(void)
{
	fmConfig->btnCardList->Font = lvCardList->Font;
	fmConfig->btnDeckList->Font = lvDeckList->Font;
	fmConfig->btnCardText->Font = RichEdit1->Font;
	fmConfig->cbCardListBuffer->Checked = lvCardList->DoubleBuffered;
	fmConfig->cbNoSaveCheck->Checked = NoSaveCheck;
	fmConfig->cbHighLoad->Checked = HighLoad;
	fmConfig->cbStatusHelp->Checked = HideStatusHelp;
	fmConfig->cbCardListOwnerDraw->Checked = lvCardList->OwnerDraw;
	fmConfig->cbShowHint->Checked = lvCardList->ShowHint;

	if (fmConfig->Execute()) {
		lvCardList->Font = fmConfig->btnCardList->Font;
		lvDeckList->Font = fmConfig->btnDeckList->Font;
		RichEdit1->Font = fmConfig->btnCardText->Font;
		lvCardList->DoubleBuffered = fmConfig->cbCardListBuffer->Checked;
		lvDeckList->DoubleBuffered = fmConfig->cbCardListBuffer->Checked;
		NoSaveCheck = fmConfig->cbNoSaveCheck->Checked;
		HighLoad = fmConfig->cbHighLoad->Checked;
		HideStatusHelp = fmConfig->cbStatusHelp->Checked;
		lvCardList->OwnerDraw = fmConfig->cbCardListOwnerDraw->Checked;
		lvDeckList->OwnerDraw = lvCardList->OwnerDraw;
		lvCardList->ShowHint = fmConfig->cbShowHint->Checked;
		lvDeckList->ShowHint = lvCardList->ShowHint;
	}
}
//---------------------------------------------------------------------------

// Cxg
void TfmMain::MenuEvent(int EventCode)
{
	lvCardList->Canvas->Lock();
	lvDeckList->Canvas->Lock();
	switch(EventCode )
	{
	case MENU_CLOSE:
		Close();
		break;
	case MENU_NEW:
		if (NoSaveDialog() ){
			Plugin->DeckNew();
			Plugin->DeckListUpdate(TabControl1,lvDeckList);
			Changed = Plugin->Changed;
		}
		break;
	case MENU_OPEN:
		if (NoSaveDialog() ){
			if (OpenDialog1->Execute(Handle)) {
				Plugin->DeckLoad(OpenDialog1->FileName);
				Plugin->DeckListUpdate(TabControl1,lvDeckList);
				Changed = Plugin->Changed;
			}
		}
		break;
	case MENU_SAVE:
		if (SaveDialog1->Execute(Handle)) {
			Plugin->DeckSave(SaveDialog1->FileName);
			Changed = Plugin->Changed;
		}
		break;
	case MENU_SEARCH:
		Plugin->Search(false);
		Plugin->CardListUpdate(lvCardList);
		Plugin->CardListSort(LVSortPaint->SortIndex,LVSortPaint->SortUp);
		SearchResult = Plugin->SearchResult;
		break;

	case MENU_CONFIG:
		Config();
		break;

	case MENU_CLIP:
		Plugin->DeckClipBoard();
		break;

	case MENU_ADD:
		if( TabControl1->TabIndex!=-1&&lvCardList->ItemIndex!=-1 ){
			Plugin->DeckAdd(lvCardList->ItemIndex,TabControl1,lvDeckList);
			Plugin->CardImage(0,0,false,NULL);
			Changed = Plugin->Changed;
		}
		break;
	case MENU_DEL:
		if( TabControl1->TabIndex!=-1&&lvDeckList->ItemIndex!=-1 ){
			Plugin->DeckDel(TabControl1->TabIndex,lvDeckList->ItemIndex);
			Plugin->DeckListUpdate(TabControl1,lvDeckList);
			Plugin->CardImage(0,0,false,NULL);
			Changed = Plugin->Changed;
		}
		break;

	case MENU_PLUGIN:
		if (NoSaveDialog() ){
			LoadPlugin(true);
		}
		break;

	case MENU_HINT_IMAGE:
		break;
	}
	lvCardList->Canvas->Unlock();
	lvDeckList->Canvas->Unlock();
}
//---------------------------------------------------------------------------

// vOC̗
void TfmMain::ListUpPlugin(void)
{
	PluginList->SearchPlugin(PLUGIN_PATH);
	TListBox* listBox = fmPlugin->ListBox1;
	listBox->Items->BeginUpdate();
	listBox->Clear();
	for(int i=0;i<PluginList->Count;i++ )
	{
		listBox->Items->Add( PluginList->Item[i]->TcgName );
	}
	listBox->Items->EndUpdate();
	listBox->ItemIndex = listBox->Items->IndexOf(TcgName);

}
//---------------------------------------------------------------------------

// vOCǂݍ
bool TfmMain::LoadPlugin(bool useDialog)
{
	Plugin->WriteCardListColumnInfomation(lvCardList->Columns);
	Plugin->WriteDeckListColumnInfomation(lvDeckList->Columns);

	ListUpPlugin();

	if (useDialog==true || fmPlugin->ListBox1->ItemIndex==-1) {
		if ( fmPlugin->Execute() ) {
			TcgName = PluginList->Item[fmPlugin->ListBox1->ItemIndex]->TcgName;
		}else{
			return true;
		}
	}

	PluginItemItr item = PluginList->FindData( TcgName );

	if (item!=NULL && Plugin->Load(item->FilePath,HighLoad) ) {
		lvCardList->Items->Count = 0;
		lvDeckList->Items->Count = 0;
		RichEdit1->Text = L"";
		Plugin->Search(true);
		Plugin->UpdateCardList(lvCardList,PopCardList->Items);
		Plugin->UpdateDeckList(lvDeckList,PopDeckList->Items);
		Plugin->CardListUpdate(lvCardList);
		Plugin->DeckListUpdate(TabControl1,lvDeckList);
		LVSortPaint->SortIndex = 0;
		LVSortPaint->SortUp = false;
		Plugin->CardListSort(LVSortPaint->SortIndex,LVSortPaint->SortUp);
	}

	SearchResult = Plugin->SearchResult;
	Changed = Plugin->Changed;

	return true;
}
//---------------------------------------------------------------------------

bool TfmMain::UnloadPlugin(void)
{
	Plugin->WriteCardListColumnInfomation(lvCardList->Columns);
	Plugin->WriteDeckListColumnInfomation(lvDeckList->Columns);

	return Plugin->Unload();
}
//---------------------------------------------------------------------------

void TfmMain::SetSearchResult(int no)
{
	StatusBar1->Panels->Items[0]->Text = UnicodeString().sprintf(L"Result : %5ld cards",no);
}
//---------------------------------------------------------------------------

void TfmMain::SetChanged(bool val)
{
	if (Plugin->Changed ) {
		StatusBar1->Panels->Items[1]->Text = L"ύX";
	}else{
		StatusBar1->Panels->Items[1]->Text = L"";
	}
}
//---------------------------------------------------------------------------

bool TfmMain::NoSaveDialog(void)
{
	if (Plugin->Changed && NoSaveCheck) {
		return MessageBoxEx(Handle,L"fbL̕ۑĂ܂",L"mF"
			,MB_OKCANCEL|MB_ICONWARNING,0)==IDOK;
	}else{
		return true;
	}
}
//---------------------------------------------------------------------------

void TfmMain::SetStatusHelp(int MenuID)
{
	UnicodeString Text;

	switch( MenuID )
	{
	case MENU_CLOSE:	Text = L"AvP[VI܂ (Alt+F4)";break;
	case MENU_NEW:		Text = L"fbLf[^܂(Ctrl+N)";break;
	case MENU_OPEN: 	Text = L"fbLf[^ǂݍ݂܂(Ctrl+L)";break;
	case MENU_SAVE: 	Text = L"fbLf[^ۑ܂(Ctrl+S)";break;
	case MENU_SEARCH: Text = L"_CAOJ܂(Ctrl+F)";break;
	case MENU_CONFIG: Text = L"ݒ_CAOJ܂";break;
	case MENU_PLUGIN: Text = L"vOC؂ւ܂";break;
	case MENU_CLIP:   Text = L"fbLf[^Nbv{[hɃRs[܂(Ctrl+C)";break;
	case MENU_ADD:    Text = L"If[^Pǉ܂(Enter܂̓_uNbN)";break;
	case MENU_DEL:    Text = L"If[^P炵܂(Enter܂̓_uNbN)";break;
	case MENU_LAYER:  Text = L"fbL̈ύX܂(^uI)";break;
	case MENU_TEXT:   Text = L"IĂf[^̃eLXg\";break;
	case MENU_HINT_IMAGE:	Text = L"IĂf[^̉摜\";break;
	}

	if (HideStatusHelp==false) {
		StatusBar1->Panels->Items[2]->Text = Text;
		Timer1->Enabled = false;
		Timer1->Enabled = true;
	}
}
//---------------------------------------------------------------------------


/****************************************************************************

	P U B L I C

****************************************************************************/


__fastcall TfmMain::TfmMain(TComponent* Owner)
	: TForm(Owner)
{
	LVSortPaint = new TLVSortPaint(lvCardList);
	fmConfig = new TfmConfig(this);
	fmPlugin = new TfmPlugin(this);
	PluginList = new TPluginList();
	Plugin = new TPluginGUI();

	fmConfig->LoadIniFile(APP_INI);

	LoadPlugin(false);

	Theme = new TTheme(lvCardList->Handle);
	Theme->SetWindowTheme(L"explorer");
	Theme->Open(L"listview");
}
//---------------------------------------------------------------------------

/****************************************************************************

	P U B L I S H E D

****************************************************************************/

void __fastcall TfmMain::FormDestroy(TObject *Sender)
{
	UnloadPlugin();
	fmConfig->SaveIniFile(APP_INI);

	Theme->Close();

	delete Theme;
	delete PluginList;
	delete Plugin;
	delete fmPlugin;
	delete fmConfig;
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::FormClose(TObject *Sender, TCloseAction &Action)
{
	if ( !NoSaveDialog() ){
		Action = caNone;
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::ToolButton1MouseUp(TObject *Sender, TMouseButton Button,
					TShiftState Shift, int X, int Y)
{
	TToolButton* toolButton = static_cast<TToolButton*>(Sender);
	MenuEvent(toolButton->Tag);
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::FormKeyDown(TObject *Sender, WORD &Key, TShiftState Shift)

{
	if (Shift.Contains(ssCtrl) ) {
		switch( Key )
		{
		case 'N':	MenuEvent(MENU_NEW);	break;
		case 'S':	MenuEvent(MENU_SAVE);	break;
		case 'O':	MenuEvent(MENU_OPEN);	break;
		case 'F':	MenuEvent(MENU_SEARCH);	break;
		case 'C': MenuEvent(MENU_CLIP); break;
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvCardListSelectItem(TObject *Sender, TListItem *Item, bool Selected)

{
	if (Selected) {
//		lvCardList->ShowHint = tbHint->Down;
		Plugin->CardListSelect(lvCardList->ItemIndex,RichEdit1);
		/*if ( lvCardList->ShowHint ){
			lvCardList->Hint = Plugin->GetCardListHint(Item->Index);
		}
		*/
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvDeckListSelectItem(TObject *Sender, TListItem *Item, bool Selected)

{
	if (Selected) {
		Plugin->DeckListSelect(TabControl1->TabIndex,Item->Index,RichEdit1);
//		lvDeckList->ShowHint = tbHint->Down;
		/*
		if ( lvDeckList->ShowHint ){
			lvDeckList->Hint = Plugin->GetDeckListHint(TabControl1->TabIndex
				,Item->Index);
		}
		*/
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvCardListDblClick(TObject *Sender)
{
	MenuEvent(MENU_ADD);
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvDeckListDblClick(TObject *Sender)
{
	MenuEvent(MENU_DEL);
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::TabControl1Changing(TObject *Sender, bool &AllowChange)
{
	Plugin->DeckLayerChanging(TabControl1->TabIndex,lvDeckList->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::TabControl1Change(TObject *Sender)
{
	Plugin->DeckLayerChange(TabControl1,lvDeckList);
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvCardListKeyPress(TObject *Sender, wchar_t &Key)
{
	switch( Key )
	{
	case VK_RETURN:
		MenuEvent(MENU_ADD);
		break;
	case 'i': // C[W\
	case 'I':
		break;
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvDeckListKeyPress(TObject *Sender, wchar_t &Key)
{
	switch( Key )
	{
	case VK_RETURN:
		MenuEvent(MENU_DEL);
		break;
	case 'i': // C[W\
	case 'I':
		break;
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::ToolButton1MouseMove(TObject *Sender, TShiftState Shift,
					int X, int Y)
{
	TControl* cnt = static_cast<TControl*>(Sender);
	static UnicodeString helpObjectName;

	if (helpObjectName !=cnt->Name) {
		SetStatusHelp(cnt->Tag);
		helpObjectName = cnt->Name;
		Plugin->CardImage(0,0,false,NULL);
	}
}
//---------------------------------------------------------------------------
void __fastcall TfmMain::Timer1Timer(TObject *Sender)
{
	StatusBar1->Panels->Items[2]->Text = "";
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvCardListAdvancedCustomDrawItem(TCustomListView *Sender,
					TListItem *Item, TCustomDrawState State, TCustomDrawStage Stage,
					bool &DefaultDraw)
{
	TRect rc;
	UnicodeString cardText;
	TCanvas* Cv = lvCardList->Canvas;

	if (Stage!=cdPostPaint) {return;}
	DefaultDraw = !lvCardList->OwnerDraw;
	Cv->Lock();
	SetBkMode(Cv->Handle,TRANSPARENT);

	// Ig
	if ( Item->Selected ){
		if ( Theme->Active ){
			Theme->DrawBackground(Cv->Handle,LVP_LISTITEM,LISS_SELECTED
				,&Item->DisplayRect(drBounds),&Item->DisplayRect(drBounds));
		}else{
			Cv->Brush->Color = clMenu;
			Cv->FillRect(Item->DisplayRect(drBounds) );
		}
	}

	// C
	ListView_GetItemRect(lvCardList->Handle,Item->Index, &rc, LVIR_LABEL);
	cardText = Plugin->GetCardListText(Item->Index,0);
	RTFtoHtml.DrawHtmlText(Cv,rc,cardText);

	// TuACe
	for(int i=1;i<lvCardList->Columns->Count;i++ )
	{
		cardText = Plugin->GetCardListText(Item->Index,i);
		ListView_GetSubItemRect(lvCardList->Handle,Item->Index,i,LVIR_LABEL,&rc);
		RTFtoHtml.DrawHtmlText(Cv,rc,cardText);
	}

	Cv->Unlock();
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvDeckListAdvancedCustomDrawItem(TCustomListView *Sender,
					TListItem *Item, TCustomDrawState State, TCustomDrawStage Stage,
					bool &DefaultDraw)
{
	TRect rc;
	UnicodeString cardText;
	TCanvas* Cv = lvDeckList->Canvas;

	if (Stage!=cdPostPaint) {return;}
	DefaultDraw = !lvDeckList->OwnerDraw;
	Cv->Lock();
	SetBkMode(Cv->Handle,TRANSPARENT);

	// Ig
	if ( Item->Selected ){
		if ( Theme->Active ){
			Theme->DrawBackground(Cv->Handle,LVP_LISTITEM,LISS_SELECTED
				,&Item->DisplayRect(drBounds),&Item->DisplayRect(drBounds));
		}else{
			SetBkMode(Cv->Handle,TRANSPARENT);
			Cv->Brush->Color = clMenu;
			Cv->FillRect(Item->DisplayRect(drBounds) );
		}
	}

	// ACe
	cardText = Plugin->GetDeckListText(TabControl1->TabIndex,Item->Index,0);
	ListView_GetItemRect(lvDeckList->Handle,Item->Index, &rc, LVIR_LABEL);
	RTFtoHtml.DrawHtmlText(Cv,rc,cardText);

	// TuACe
	for(int i=1;i<lvDeckList->Columns->Count;i++ )
	{
		cardText = Plugin->GetDeckListText(TabControl1->TabIndex,Item->Index,i);
		ListView_GetSubItemRect(lvDeckList->Handle,Item->Index,i,LVIR_LABEL,&rc);
		RTFtoHtml.DrawHtmlText(Cv,rc,cardText);
	}

	Cv->Unlock();
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvDeckListKeyDown(TObject *Sender, WORD &Key, TShiftState Shift)

{
	if (!Shift.Contains(ssCtrl)) {
		return;
	}

	switch( Key )
	{
	case VK_UP: //'[': // IACe
		if ( Plugin->DeckSwap(TabControl1->TabIndex,lvDeckList->ItemIndex,lvDeckList->ItemIndex-1) ){
			lvDeckList->ItemIndex--;
		}
		Plugin->DeckListUpdate(TabControl1,lvDeckList);
		break;

	case VK_DOWN://']': // IACe
		if ( Plugin->DeckSwap(TabControl1->TabIndex,lvDeckList->ItemIndex,lvDeckList->ItemIndex+1) ){
			lvDeckList->ItemIndex++;
		}
		Plugin->DeckListUpdate(TabControl1,lvDeckList);
		break;
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvDeckListMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift,
          int X, int Y)
{
	TListItem* item;

	switch( Button )
	{
	case mbRight:
		item = lvDeckList->GetItemAt(X,Y);
		Plugin->SearchItem(TabControl1,item,lvCardList);
		break;
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvCardListMouseDown(TObject *Sender, TMouseButton Button,
					TShiftState Shift, int X, int Y)
{
	CardListPoint = lvCardList->ClientToScreen(TPoint(X,Y));
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvDeckListMouseDown(TObject *Sender, TMouseButton Button,
					TShiftState Shift, int X, int Y)
{
	DeckListPoint = lvDeckList->ClientToScreen(TPoint(X,Y));
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvCardListClick(TObject *Sender)
{
	if( tbImage->Down && lvCardList->ItemIndex!=-1){
		Plugin->ShowCardImage(-1,lvCardList->ItemIndex,CardListPoint.x,CardListPoint.y);
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvDeckListClick(TObject *Sender)
{
	if( tbImage->Down && lvDeckList->ItemIndex!=-1 ){
		Plugin->ShowCardImage(TabControl1->TabIndex,lvDeckList->ItemIndex
			,DeckListPoint.x,DeckListPoint.y);
	}
}
//---------------------------------------------------------------------------

void __fastcall TfmMain::lvCardListColumnClick(TObject *Sender, TListColumn *Column)

{
	if( LVSortPaint->SortIndex==Column->Index ){
		LVSortPaint->SortUp = !LVSortPaint->SortUp;
		Plugin->CardListSort(LVSortPaint->SortIndex,LVSortPaint->SortUp);
	}else{
		LVSortPaint->SortIndex = Column->Index;
		Plugin->CardListSort(LVSortPaint->SortIndex,LVSortPaint->SortUp);
	}

	lvCardList->Repaint();
}
//---------------------------------------------------------------------------

