//---------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "frmConfig.h"
#include "frmMain.h"
#include <IniFiles.hpp>
#include "History.h"

//---------------------------------------------------------------------
#pragma resource "*.dfm"
TfmConfig *fmConfig;

void __fastcall WriteFontToIni(TIniFile* ini,UnicodeString Section,TFont* font)
{
	ini->WriteString(Section,L"Font",font->Name);
	ini->WriteInteger(Section,L"Size",font->Size);
	ini->WriteInteger(Section,L"Color",font->Color);
	ini->WriteBool(Section,L"Bold",font->Style.Contains(fsBold));
	ini->WriteBool(Section,L"Italic",font->Style.Contains(fsItalic));
	ini->WriteBool(Section,L"Underline",font->Style.Contains(fsUnderline));
	ini->WriteBool(Section,L"StrileOut",font->Style.Contains(fsStrikeOut));
}
//---------------------------------------------------------------------

void __fastcall ReadFontToIni(TIniFile* ini,UnicodeString Section,TFont* font)
{
	font->Name = ini->ReadString(Section,L"Font",font->Name);
	font->Size = ini->ReadInteger(Section,L"Size",font->Size);
	font->Color = static_cast<TColor>(ini->ReadInteger(Section,L"Color",font->Color));

	if (ini->ReadBool(Section,L"Bold",false)) {
		font->Style = font->Style << fsBold;
	}
	if (ini->ReadBool(Section,L"Italic",false)) {
		font->Style = font->Style << fsItalic;
	}
	if (ini->ReadBool(Section,L"Underline",false)) {
		font->Style = font->Style << fsUnderline;
	}
	if (ini->ReadBool(Section,L"StrileOut",false)) {
		font->Style = font->Style << fsStrikeOut;
	}
}

/**********************************************************************

	P U B L I C

**********************************************************************/

//---------------------------------------------------------------------
__fastcall TfmConfig::TfmConfig(TComponent* AOwner)
	: TForm(AOwner)
{
	Label1->Caption =  APP_NAME;
	Label2->Caption =  APP_VERSION;
}
//---------------------------------------------------------------------

bool TfmConfig::Execute(void)
{
	Tag = 0;
	ShowModal();
	return Tag;
}
//---------------------------------------------------------------------

void __fastcall TfmConfig::LoadIniFile(UnicodeString IniFile)
{
	TIniFile* ini = new TIniFile(IniFile);

	fmMain->Left = ini->ReadInteger(L"System",L"Left",0);
	fmMain->Top = ini->ReadInteger(L"System",L"Top",0);
	fmMain->Width = ini->ReadInteger(L"System",L"Width",800);
	fmMain->Height = ini->ReadInteger(L"System",L"Height",600);

	fmMain->pnlBottom->Height = ini->ReadInteger(L"System",L"Horizon",200);
	fmMain->TabControl1->Width = ini->ReadInteger(L"System",L"Vertical",300);

	fmMain->lvCardList->DoubleBuffered = ini->ReadBool(L"System",L"CardListDoubleBuffered",true);
	fmMain->lvDeckList->DoubleBuffered = fmMain->lvCardList->DoubleBuffered;

//	fmMain->lvCardList->ShowHint = ini->ReadBool(L"System",L"ShowHint",false);
//	fmMain->lvDeckList->ShowHint = fmMain->lvCardList->ShowHint;

	fmMain->StatusBar1->Top = fmMain->Height;
	fmMain->TcgName = ini->ReadString(L"System",L"TcgName",L"");
	fmMain->NoSaveCheck = ini->ReadBool(L"System",L"NoSaveCheck",true);
	fmMain->HighLoad = true;//ini->ReadBool(L"System",L"HighLoad",false);

	fmMain->lvCardList->OwnerDraw = ini->ReadBool(L"System",L"CardListOwnerDraw",false);
	fmMain->lvDeckList->OwnerDraw = ini->ReadBool(L"System",L"DeckListOwnerDraw",false);

//	fmMain->tbHint->Down = ini->ReadBool(L"System",L"ShowHint",false);
	fmMain->tbImage->Down = ini->ReadBool(L"System",L"ShowImage",false);

	ReadFontToIni(ini,L"CardList",fmMain->lvCardList->Font);
	ReadFontToIni(ini,L"DeckList",fmMain->lvDeckList->Font);
	ReadFontToIni(ini,L"CardText",fmMain->RichEdit1->Font);

	delete ini;
}
//---------------------------------------------------------------------

void __fastcall TfmConfig::SaveIniFile(UnicodeString IniFile)
{
	TIniFile* ini = new TIniFile(IniFile);

	ini->WriteInteger(L"System",L"Left",fmMain->Left);
	ini->WriteInteger(L"System",L"Top",fmMain->Top);
	ini->WriteInteger(L"System",L"Width",fmMain->Width);
	ini->WriteInteger(L"System",L"Height",fmMain->Height);

	ini->WriteInteger(L"System",L"Horizon",fmMain->pnlBottom->Height);
	ini->WriteInteger(L"System",L"Vertical",fmMain->TabControl1->Width);

	ini->WriteBool(L"System",L"CardListDoubleBuffered",fmMain->lvCardList->DoubleBuffered);
//	ini->WriteBool(L"System",L"DeckListDoubleBuffered",fmMain->lvDeckList->DoubleBuffered);
//	ini->WriteBool(L"System",L"ShowHint",fmMain->lvCardList->ShowHint);

	ini->WriteString(L"System",L"TcgName",fmMain->TcgName);
	ini->WriteBool(L"System",L"NoSaveCheck",fmMain->NoSaveCheck);
	ini->WriteBool(L"System",L"HighLoad",fmMain->HighLoad);

	ini->WriteBool(L"System",L"CardListOwnerDraw",fmMain->lvCardList->OwnerDraw);
	ini->WriteBool(L"System",L"DeckListOwnerDraw",fmMain->lvDeckList->OwnerDraw);

//	ini->WriteBool(L"System",L"ShowHint",fmMain->tbHint->Down );
	ini->WriteBool(L"System",L"ShowImage",fmMain->tbImage->Down );

	WriteFontToIni(ini,L"CardList",fmMain->lvCardList->Font);
	WriteFontToIni(ini,L"DeckList",fmMain->lvDeckList->Font);
	WriteFontToIni(ini,L"CardText",fmMain->RichEdit1->Font);

	delete ini;
}
//---------------------------------------------------------------------

void __fastcall TfmConfig::OKBtnClick(TObject *Sender)
{
	Tag = 1;
}
//---------------------------------------------------------------------------

void __fastcall TfmConfig::btnCardListMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift,
          int X, int Y)
{
	TButton* button = static_cast<TButton*>(Sender);

	FontDialog1->Font = button->Font;

	if ( FontDialog1->Execute(Handle) ){
		button->Font = FontDialog1->Font;
	}
}
//---------------------------------------------------------------------------

#include <shellapi.h>

void __fastcall TfmConfig::LinkLabel1Click(TObject *Sender)
{
	ShellExecute(NULL, L"open", L"http://www38.atwiki.jp/tcgexplorer/"
		, NULL , NULL, SW_SHOWNORMAL);

}
//---------------------------------------------------------------------------


