//---------------------------------------------------------------------------

#ifndef TThemeH
#define TThemeH
//---------------------------------------------------------------------------

#include <vcl.h>

#include "Uxtheme.h"
#include "vsstyle.h"

/**
	@brief	e[}ǗNX

	ȒPɃrWANXg悤ɂ܂B

*/
class TTheme
{
private:

	HANDLE hTheme;

	HWND__ * FWnd;

	/**
	@brief           -
	@param[in]
	*/
	int IsThemeActive(void)
{
	return ::IsThemeActive();
}

public:

	__property bool Active={read=IsThemeActive};

	/**
	@brief           -
	@param[in,out]   *hWnd
	*/
	TTheme(HWND__ *hWnd)
{
	hTheme = NULL;
	FWnd = hWnd;
}

	/**
	@brief           -
	*/
	~TTheme(void)
{}


	/**
	@brief           -
	@param[in]       Name
	@return          -
	*/
	int SetWindowTheme(UnicodeString Name="explorer")
{
	return ::SetWindowTheme(FWnd, Name.c_str(), NULL);
}

	/**
	@brief           -
	@param[in]       ClassList
	@return          -
	*/
	int Open(UnicodeString ClassList="listview")
{
	if (hTheme!=NULL) {
		Close();
	}
	hTheme = ::OpenThemeData(FWnd,ClassList.c_str());
	return 1;
}

	/**
	@brief           -
	@return          -
	*/
	int Close(void)
{
	int ret;

	if( hTheme!=NULL ){
		ret = ::CloseThemeData(hTheme);
		hTheme = NULL;
	}

	return ret;
}

	/**
	@brief           -
	@param[in,out]   *hDC
	@param[in]       PartID
	@param[in]       StateID
	@param[out]      *Rect
	@param[out]      *ClipRect
	@return          -
	*/
	int DrawBackground(HDC__ *hDC,int PartID,int StateID,const TRect *Rect
		,const TRect *ClipRect)
{
/*
	PartID
		LVP_LISTITEM
	StateID
		LISS_HOT
		LISS_SELECTED;
		LISS_HOTSELECTED
*/
	return ::DrawThemeBackground(hTheme,hDC,PartID,StateID,Rect,ClipRect);
}

	/**
	@brief           -
	@param[in,out]   *hDC
	@param[in]       PartID
	@param[in]       StateID
	@param[out]      lpwsText
	@param[in]       cchText
	@param[in]       dwTextFug
	@param[in]       dwTextFug2
	@param[out]      Rect
	@return          -
	*/
	int DrawText(HDC__ *hDC,int PartID,int StateID,const wchar_t* lpwsText
		,int cchText,DWORD dwTextFug,DWORD dwTextFug2,const TRect* Rect)
{
	return ::DrawThemeText(hTheme,hDC,PartID,StateID,lpwsText,cchText,dwTextFug,dwTextFug2,Rect);
}


};

#endif
