//---------------------------------------------------------------------------

#pragma hdrstop

#include "TPluginList.h"
#include <IOUtils.hpp>
#include <IniFiles.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)

TPluginList* PluginList=NULL;


void TPluginList::Clear(void)
{
	Items.clear();
}
//---------------------------------------------------------------------------

int TPluginList::GetCount(void)
{
	return static_cast<int>(Items.size());
}
//---------------------------------------------------------------------------

void TPluginList::SearchPlugin(UnicodeString PluginPath)
{
	TDirectory dir;
	TStringDynArray sdArray;

	Clear();

	sdArray = dir.GetFiles(PluginPath);

	for(int i=0;i<sdArray.Length;i++ )
	{
		if ( ExtractFileExt(sdArray[i])!=L".ini"){
			continue;
		}

		TIniFile* ini = new TIniFile(sdArray[i]);
		UnicodeString Name = ini->ReadString(L"System",L"Name",L"");
		int Version = ini->ReadInteger(L"System",L"Version",0);

		if ( Name.Length()!=0 ){
			TPluginItem item;
			item.TcgName = Name;
			item.FilePath = sdArray[i];
			Items.push_back(item);
		}

		delete ini;
	}

	return;
}
//---------------------------------------------------------------------------

PluginItemItr TPluginList::GetItem(int Index)
{
	return &Items[Index];
}
//---------------------------------------------------------------------------

PluginItemItr TPluginList::FindData(UnicodeString TcgName)
{
	PluginItemItr Itr = Items.begin();

	while(Itr!=Items.end())
	{
		if ( Itr->TcgName==TcgName ){
			return Itr;
		}
		Itr++;
	}

	return NULL;
}
//---------------------------------------------------------------------------

