//---------------------------------------------------------------------------

#pragma hdrstop

#include "TPluginGUI.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

#include "frmSearch.h"


/****************************************************************************

	P R I V A T E

****************************************************************************/

void __fastcall TPluginGUI::OnCardListMenuClick(TObject* Sender)
{
	TMenuItem* item = static_cast<TMenuItem*>(Sender);

	WriteCardListColumnInfomation(lvCardList->Columns);

	cardListSection->Item[item->Tag]->Visibled
		= !cardListSection->Item[item->Tag]->Visibled;

	UpdateCardList(lvCardList,miCardList);

}
//---------------------------------------------------------------------------

void __fastcall TPluginGUI::OnDeckListMenuClick(TObject* Sender)
{
	TMenuItem* item = static_cast<TMenuItem*>(Sender);

	WriteDeckListColumnInfomation(lvDeckList->Columns);

	deckListSection->Item[item->Tag]->Visibled
	 = !deckListSection->Item[item->Tag]->Visibled;

	UpdateDeckList(lvDeckList,miDeckList);
}
//---------------------------------------------------------------------------

/****************************************************************************

	P U B L I C

****************************************************************************/

//---------------------------------------------------------------------------
TPluginGUI::TPluginGUI(void)
{
	fmSearch = new TfmSearch(NULL);
}

//---------------------------------------------------------------------------
TPluginGUI::~TPluginGUI(void)
{
#define	RELEASE(A)	if (A!=NULL ){delete A;A=NULL;};
	RELEASE(fmSearch);
}
//---------------------------------------------------------------------------

/**
>eclasshclass̊֐Ăяo͉XɂĕB
ނ
*/
bool TPluginGUI::Load(UnicodeString IniFile,bool high)
{
	bool ret;

	ret = TPlugin::Load(IniFile,high);

	fmSearch->Clear();

	for(int i=0;i<cardParams->Count;i++ )
	{
		TCardParamItem* item = cardParams->Item[cardParams->Count-i-1];
		TfmSearchItem* searchItem = 	fmSearch->Add(item->Key,item->Name,item->Type);
		searchItem->ComboBox1->Items = item->List;
		if( searchItem->ComboBox1->Items->Count>0 ){
			searchItem->ComboBox1->ItemIndex = 0;
		}
	}

	return ret;
}
//---------------------------------------------------------------------------

/**
>eclasshclass̊֐Ăяo͉XɂĕB
ނ
*/
bool TPluginGUI::Unload(void)
{
	fmSearch->Clear();

	return TPlugin::Unload();
}

//---------------------------------------------------------------------------
void __fastcall TPluginGUI::UpdateColumn(TListColumns* Columns
	,TSectionList* sectionList,bool AddCount)
{
	TListColumn* column;
	UnicodeString key;

	Columns->BeginUpdate();
	Columns->Clear();

	// J[h
	if (AddCount) {
		column = Columns->Add();
		column->Caption = "";
		column->Width = 30;
	}

	for(int i=0;i<sectionList->ShowCount;i++ )
	{
		if( sectionList->ShowItem[i]->Visibled==false ){
			continue;
		}

		column = Columns->Add();
		column->Caption = sectionList->ShowItem[i]->Name;
		column->Width = sectionList->ShowItem[i]->Width;
	}

	Columns->EndUpdate();
}

//---------------------------------------------------------------------------
void __fastcall TPluginGUI::UpdateDeckLayer(TTabControl* TabControl)
{
	TabControl->Tabs->BeginUpdate();
	int tabIndex = TabControl->TabIndex;
	TabControl->Tabs->Clear();
	UnicodeString caption;

	for(int i=0;i<deckData->LayerCount;i++ )
	{
		caption.printf(L"%s %d/%d"
			,deckData->Layer[i]->Name
			,deckData->Layer[i]->Total
			,deckData->Layer[i]->TotalLimit
			);
		TabControl->Tabs->Add( caption );
	}
	TabControl->Refresh();
	TabControl->TabIndex = std::max(tabIndex,0);
	TabControl->Tabs->EndUpdate();
}
//---------------------------------------------------------------------------

bool TPluginGUI::Search(bool all)
{
	ReferenceCardItr Itr = cardListReference->Begin();

	if (all) {
		cardListResult->Clear();
		while( Itr!=cardListReference->End() )
		{
			cardListResult->Item[-1] = &Itr->second;
			Itr++;
		}
	}else{
		if ( fmSearch->Execute() ){
			cardListResult->Clear();

			while( Itr!=cardListReference->End() )
			{
				bool ret=true;
				for(int i=0;i<cardParams->Count;i++ )
				{
					TCardParamItem* item = cardParams->Item[i];
					TfmSearchItem* searchItem = fmSearch->Item[item->Key];
					ret &= searchItem->Check( Itr->second.SubItem[item->Key] );
				}

				if (ret==true) {
					cardListResult->Item[-1] = &Itr->second;
				}
				Itr++;
			}
		}
	}

	return true;
}
//---------------------------------------------------------------------------

void TPluginGUI::CardListSelect(int Index,TRichEdit* RichEdit)
{
	TCardItem* card = cardListResult->Item[Index];

	UnicodeString buff;
	for(int i=0;i<textKeyStrings->Count;i++ )
	{
		buff += card->SubItem[textKeyStrings->Strings[i]];
		buff += L"\n";
	}

	CardImage(0,0,CARD_HIDE,NULL);

	RTFtoHtml.SetText(RichEdit,buff);
}
//---------------------------------------------------------------------------

void TPluginGUI::DeckListSelect(int Layer,int Index,TRichEdit* RichEdit)
{
	UnicodeString UniqueID = deckData->Layer[Layer]->Item[Index]->UniqueID;
	TCardItem* card = cardListReference->Data[UniqueID];
	UnicodeString buff;
	for(int i=0;i<textKeyStrings->Count;i++ )
	{
		buff += card->SubItem[textKeyStrings->Strings[i]];
		buff += L"\n";
	}

	CardImage(0,0,CARD_HIDE,NULL);

	RTFtoHtml.SetText(RichEdit,buff);
}
//---------------------------------------------------------------------------

void TPluginGUI::DeckLayerChanging(int Layer,int Index)
{
	deckData->Layer[Layer]->ItemIndex = Index;
}
//---------------------------------------------------------------------------

void TPluginGUI::DeckLayerChange(TTabControl* TabControl,TListView* ListView)
{
	ListView->ItemIndex = -1;
	DeckListUpdate(TabControl,ListView);
	ListView->ItemIndex = deckData->Layer[TabControl->TabIndex]->ItemIndex;
	TabControl->Invalidate();
	ListView->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TPluginGUI::CardListUpdate(TListView* ListView)
{
	int ItemIndex = ListView->ItemIndex;

	ListView->Items->Count = cardListResult->Count;
	ListView->Refresh();
	ListView->ItemIndex = std::min(ItemIndex,ListView->Items->Count-1);
	ListView->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TPluginGUI::DeckListUpdate(TTabControl* TabControl,TListView* ListView)
{
	int itemIndex = ListView->ItemIndex;
	int tabIndex = std::max(TabControl->TabIndex,0);
	ListView->Items->BeginUpdate();

	UpdateDeckLayer(TabControl);
	TDeckLayer* layer = deckData->Layer[tabIndex];

	ListView->Items->Count = layer->Count;
//	ListView->Refresh();
	ListView->ItemIndex = std::min(itemIndex,ListView->Items->Count-1);
	ListView->Items->EndUpdate();
	ListView->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TPluginGUI::WriteCardListColumnInfomation(TListColumns* Columns)
{
	TSectionItem* item;

	for(int i=0;i<Columns->Count;i++ )
	{
		item = cardListSection->ShowItem[i];
		item->Width = Columns->Items[i]->Width;
	}

	cardListSection->SaveToFile(iniFile,cardListSectionFormat);
}
//---------------------------------------------------------------------------

void __fastcall TPluginGUI::WriteDeckListColumnInfomation(TListColumns* Columns)
{
	TSectionItem* item;

	for(int i=0;i<Columns->Count-1;i++ )
	{
		item = deckListSection->ShowItem[i];
		item->Width = Columns->Items[i+1]->Width;
	}

	deckListSection->SaveToFile(iniFile,deckListSectionFormat);
}
//---------------------------------------------------------------------------

bool __fastcall TPluginGUI::SearchItem(TTabControl* TabControl
	,TListItem* Item,TListView *ListView)
{
	if( TabControl->TabIndex==-1 ){
		return -1;
	}

	if( Item==NULL ){
		return -1;
	}

	DeckItemItr Itr = deckData->Layer[TabControl->TabIndex]->Item[Item->Index];

	for(int i=0;i<this->cardListResult->Count;i++ )
	{
		TCardItem* card = cardListResult->Item[i];
		if( card->SubItem[UniqueKey]==Itr->UniqueID ){
			ListView->Selected = ListView->Items->Item[i];
			ListView->Selected->MakeVisible(true);
		}
	}

	return -1;
}
//---------------------------------------------------------------------------

void __fastcall TPluginGUI::DeckAdd(int CardListIndex,TTabControl* TabControl
	,TListView* ListView)
{
	int index = TPlugin::DeckAdd(CardListIndex,TabControl->TabIndex);

	if( index>=0 ){
		DeckListUpdate(TabControl,ListView);
		ListView->Selected = ListView->Items->Item[index];
		ListView->Selected->MakeVisible(true);
	}
}
//---------------------------------------------------------------------------

//
bool __fastcall TPluginGUI::ShowCardImage(int LayerIndex,int ItemIndex,int X,int Y)
{
	TCardItem* card;

	if( LayerIndex==-1 ){
		card = cardListResult->Item[ItemIndex];
	}else{
		DeckItemItr deck = deckData->Layer[LayerIndex]->Item[ItemIndex];
		card = cardListReference->Data[deck->UniqueID];
	}

	if( card!=NULL ){
		CardImage(X,Y,CARD_SHOW,card->NoTagText["Image"].c_str());
	}

	return true;
}
//---------------------------------------------------------------------------

// J[hXg̃Jj[
void __fastcall TPluginGUI::UpdateCardList(TListView* ListView,TMenuItem* MenuItem)
{
	miCardList = MenuItem;
	lvCardList = ListView;

	UpdateColumn(ListView->Columns,cardListSection,false);

	miCardList->Clear();

	for(int i=2;i<cardListSection->Count;i++ )
	{
		TMenuItem* item = new TMenuItem(miCardList);
		item->Caption = cardListSection->Item[i]->Name;
		item->Checked = cardListSection->Item[i]->Visibled;
		item->OnClick = OnCardListMenuClick;
		item->Tag = i;
		miCardList->Add(item);
	}
}
//---------------------------------------------------------------------------

// fbLXg̃Jj[
void __fastcall TPluginGUI::UpdateDeckList(TListView* ListView,TMenuItem* MenuItem)
{
	TMenuItem* item;
	miDeckList = MenuItem;
	lvDeckList = ListView;
	miDeckList->Clear();

	UpdateColumn(ListView->Columns,deckListSection,true);

	for(int i=2;i<deckListSection->Count;i++ )
	{
		item = new TMenuItem(miDeckList);
		item->Caption = deckListSection->Item[i]->Name;
		item->Checked = deckListSection->Item[i]->Visibled;
		item->OnClick = OnDeckListMenuClick;
		item->Tag = i;
		miDeckList->Add(item);
	}
}
//---------------------------------------------------------------------------


