#include <vcl.h>

class TLVSortPaint : public TObject
{
private:
	/**  */
	TWndMethod WindowProcOld;

	/**  */
	TListView* FListView;

	/**  */
	int FSortIndex;

	/**  */
	bool FSortUp;

	/**  */
	void SetSortIndex(int Index){
		FSortIndex = Index;
		ColumnDraw(FListView);
	}

	/**  */
	void SetSortUp(bool Up){
		FSortUp = Up;
		ColumnDraw(FListView);
	}


	/**  */
	void ColumnDraw(TListView* ListView){
		Integer Index;
		HWND Hdr;
		THDItem HdItem;
		Hdr = ListView_GetHeader(ListView->Handle);

		//HDF_SORTUP or HDF_SORTDOWN
		for(Index=0;Index<ListView->Columns->Count;Index++ )
		{
			HdItem.mask = HDI_FORMAT;

			Header_GetItem(Hdr,ListView->Columns->Items[Index]->Index,&HdItem);
			HdItem.fmt = HdItem.fmt | HDF_BITMAP_ON_RIGHT | HDF_BITMAP;
			HdItem.fmt &= ~HDF_SORTUP;
			HdItem.fmt &= ~HDF_SORTDOWN;

			if( FSortIndex==Index ){
				if( FSortUp==true ){
					HdItem.fmt |= HDF_SORTUP;
				}else{
					HdItem.fmt |= HDF_SORTDOWN;
				}
			}

			Header_SetItem(Hdr,ListView->Columns->Items[Index]->Index,&HdItem);
		}
	}

	/**  */
	void __fastcall WindowProc(Messages::TMessage &Message)
	{
		if( Message.Msg==43 ){
			ColumnDraw(FListView);
		}
		WindowProcOld(Message);
	}

public:

	/** \[gCfbNX */
	__property int SortIndex={read=FSortIndex,write=SetSortIndex};

	/** \[g */
	__property bool SortUp={read=FSortUp,write=SetSortUp};

	/** RXgN^ */
	TLVSortPaint(TListView* ListView){

		FSortIndex = -1;
		FSortUp = false;
		FListView = ListView;
		WindowProcOld = FListView->WindowProc;
		FListView->WindowProc = WindowProc;
	}

	/** fXgN^ */
	__fastcall ~TLVSortPaint(void){
		FListView->WindowProc = WindowProcOld;
	}

};

