//---------------------------------------------------------------------------


#pragma hdrstop

#include "TSectionList.h"
#include <IniFiles.hpp>

//---------------------------------------------------------------------------

#pragma package(smart_init)

/****************************************************************************

	P R I V A T E

****************************************************************************/

int TSectionList::GetShowCount(void)
{
	int count=0;

	for(unsigned int i=0;i<resultItems.size();i++ )
	{
		if( resultItems[i]->Visibled ){
			count++;
		}
	}

	return count;
}
//---------------------------------------------------------------------------

TSectionItem* TSectionList::GetShowItem(int Index)
{
	int count=0;

	for(unsigned int i=0;i<resultItems.size();i++ )
	{
		if( resultItems[i]->Visibled ){
			if( count==Index ){
				return resultItems[i];
			}
			count++;
		}
	}

	return NULL;
}
//---------------------------------------------------------------------------

int TSectionList::GetCount(void)
{
	return static_cast<int>(resultItems.size());
}


TSectionItem* TSectionList::GetItem(int Index)
{
	return resultItems[Index];
}

/****************************************************************************

	P U B L I C

****************************************************************************/

int TSectionList::Init(UnicodeString IniFile,UnicodeString SectionFormat)
{
	TIniFile* ini = new TIniFile(IniFile);

	UnicodeString Section;
	UnicodeString Key;
	UnicodeString Name;
	int Width;
	bool Visibled;

	for(int i=0;;i++ )
	{
		Section.printf(SectionFormat.c_str(),i);
		Key = ini->ReadString(Section,L"Key",L"");
		Width = ini->ReadInteger(Section,L"Width",100);
		Name = ini->ReadString(Section,L"Name",L"");
		Visibled = ini->ReadBool(Section,L"Visibled",true);

		if (Key.Length()==0) {
			break;
		}
		AddItem( new TSectionItem(Name,Key,Width,Visibled) );
	}

	delete ini;
	return resultItems.size();
}

//---------------------------------------------------------------------------
void TSectionList::Term(void)
{
	for(unsigned int i=0;i<resultItems.size();i++ )
	{
		delete resultItems[i];
	}
	resultItems.clear();
	return;
}
//---------------------------------------------------------------------------

bool TSectionList::SaveToFile(UnicodeString IniFile,UnicodeString SectionFormat)
{
	TIniFile* ini = new TIniFile(IniFile);

	UnicodeString Section;
	TSectionItem* item;

	for(unsigned int i=0;i<resultItems.size();i++ )
	{
		Section.printf(SectionFormat.c_str(),i);
		ini->WriteString(Section,L"Key",resultItems[i]->Keys->CommaText);
		ini->WriteInteger(Section,L"Width",resultItems[i]->Width );
		ini->WriteBool(Section,L"Visibled",resultItems[i]->Visibled);
	}

	delete ini;
	return true;
}
//---------------------------------------------------------------------------
void TSectionList::AddItem(TSectionItem* item)
{
	resultItems.push_back( item );
}
//---------------------------------------------------------------------------


