//---------------------------------------------------------------------------


#pragma hdrstop

#include "TRTFtoHtml.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)


#define	RichText      richEdit->Text

THtmlColor HtmlColor;

TRTFtoHtml RTFtoHtml;

/**
	A  B 
*/
UnicodeString TextTransAtoB(UnicodeString Text,UnicodeString A,UnicodeString B)
{
	int pos;
	while(1)
	{
		pos = Text.Pos(A);
		if (pos==0) {
			break;
		}

		Text.Delete(pos,A.Length());
		Text.Insert(B,pos);

	}

	return Text;
}
//---------------------------------------------------------------------------

/****************************************************************************

	P R I V A T E

****************************************************************************/

/**
	Text^O菜B
	菜^O͑񂲂stdTagɓꂽɈꊇŕϊB

*/
void __fastcall TRTFtoHtml::TagCut(UnicodeString& Text,TFont* font)
{
	int begin,end,pos;
	UnicodeString tagText,endTag;
	TStringList* tagList = new TStringList();
	int offset=0;
	bool blocknote=false;

	stdTag.clear();

	// ^O̔o
	while(1)
	{
		TAG tag(font);

		begin = Text.Pos(L"<");
		if (begin==0) {break;}
		tag.pos = begin;
		end = Text.Pos(L">");
		if (end==0) {break;}
		begin++;

		tagText = Text.SubString(begin,end-begin);
		Text.Delete(tag.pos,tagText.Length()+2);

		tagList->CommaText = tagText;
		tag.Text = tagList->Strings[0];

		// ^O
		for(int i=1;i<tagList->Count;i++ )
		{
			UnicodeString st = tagList->Strings[i];
			if (st.Pos(L"color")!=0) {
				int n = st.Pos("=");
				tag.Color = static_cast<TColor>(HtmlColor.GetColor( st.SubString(n+1,st.Length()-n) ) );
			}
			if (st.Pos(L"size")!=0) {
				int n = st.Pos("=");
				tag.Size = st.SubString(n+1,st.Length()-n).ToInt();
			}
		}

		if (tag.Text==L"b") {tag.Bold = 1;}
		if (tag.Text==L"i") {tag.Italic = 1;}
		if (tag.Text==L"u") {tag.Underline = 1;}

		if (tag.Text==L"/b") {tag.Bold = -1;}
		if (tag.Text==L"/i") {tag.Italic = -1;}
		if (tag.Text==L"/u") {tag.Underline = -1;}

		if (tag.Text==L"big"){tag.Size++;}
		if (tag.Text==L"small") {tag.Size--;}

		stdTag.push_back(tag);
	}
	delete tagList;
}
//---------------------------------------------------------------------------

/**
	쐬stdTag烊b`GfBbgύXB
	^OɎ菜̂͊JnEIʒuȂ悤ɂ邽߁B
	ϊ𕶎Pʂōŝ̓^Odӏ̏̂߂łB
*/
void __fastcall TRTFtoHtml::setTagFunc(TRichEdit* richEdit)
{
	std::list<TAG>::iterator Itr;

	// Jn^Oƕ^Ȍ܂B
	Itr = stdTag.begin();
	while( Itr!=stdTag.end() )
	{
		richEdit->SelStart = Itr->pos-1;
		std::list<TAG>::iterator itr = Itr;

		// ^O
		while(itr!=stdTag.end())
		{
			UnicodeString buf;
			buf = L"/" + Itr->Text;

			if (itr->Text==buf) {
				if (Itr->Text=="blocknote") {
					richEdit->SelStart = Itr->pos;
					richEdit->Paragraph->Alignment = taLeftJustify;
					richEdit->Paragraph->LeftIndent = 0;
					richEdit->Paragraph->FirstIndent = 10;
				}else{

				for(int i=richEdit->SelStart;i<itr->pos-1;i++ )
				{
					richEdit->SelStart = i;
					richEdit->SelLength = 1;

					if( Itr->Bold ){
						richEdit->SelAttributes->Style = richEdit->SelAttributes->Style<<fsBold;
					}
					if( Itr->Italic ){
						richEdit->SelAttributes->Style = richEdit->SelAttributes->Style<<fsItalic;
					}
					if( Itr->Underline ){
						richEdit->SelAttributes->Style = richEdit->SelAttributes->Style<<fsUnderline;
					}

					richEdit->SelAttributes->Color = Itr->Color;
					richEdit->SelAttributes->Size = Itr->Size;
				}

				}

				stdTag.erase(itr);
				break;
			}
			itr++;
		}
		Itr++;
	}
}
//---------------------------------------------------------------------------

/**
*/
void __fastcall TRTFtoHtml::setReturn(TRichEdit* richEdit)
{
	std::list<TAG>::iterator Itr;

	// s
	Itr = stdTag.begin();
	int count=0; // sJEg
	while( Itr!=stdTag.end() )
	{
		if (Itr->Text==L"br" || Itr->Text==L"/br") {
			richEdit->SelStart = Itr->pos -1 + count;
			richEdit->SelLength = 0;
			richEdit->SelText = L"\n";
			count++;
		}
		Itr++;
	}
}
//---------------------------------------------------------------------------



/****************************************************************************

	P U B L I C

****************************************************************************/

TRTFtoHtml::TRTFtoHtml(void)
{

}

//---------------------------------------------------------------------------
void __fastcall TRTFtoHtml::SetText(TRichEdit* richEdit,UnicodeString Text)
{
try{
	TagCut(Text,richEdit->Font);
}catch(...)
{

}
	richEdit->Lines->BeginUpdate();

	richEdit->Text = Text;
	richEdit->SelStart = 0;
	richEdit->SelLength = richEdit->Text.Length();
	richEdit->SelAttributes = richEdit->DefAttributes;

	setTagFunc(richEdit);
	setReturn(richEdit);
	richEdit->Lines->EndUpdate();
}
//---------------------------------------------------------------------------

UnicodeString __fastcall TRTFtoHtml::BrFromCR(UnicodeString Text)
{
	int pos;
	UnicodeString A = "\n";
	UnicodeString B = "<br>";

	while(1)
	{
		pos = Text.Pos("\r");
		if (pos==0) {
			break;
		}
		Text.Delete(pos,1);
	}

	while(1)
	{
		pos = Text.Pos(A);
		if (pos==0) {
			break;
		}

		Text.Delete(pos,A.Length());
		Text.Insert(B,pos);
	}

	return Text;
}
//---------------------------------------------------------------------------

UnicodeString __fastcall TRTFtoHtml::CRFromBr(UnicodeString Text)
{
	int pos;
	UnicodeString A = "<br>";
	UnicodeString B = "\n";

	while(1)
	{
		pos = Text.Pos(A);
		if (pos==0) {
			break;
		}

		Text.Delete(pos,A.Length());
		Text.Insert(B,pos);
	}

	return Text;
}
//---------------------------------------------------------------------------
void __fastcall TRTFtoHtml::DrawHtmlText(TCanvas* Cv,TRect Rect,UnicodeString Text)
{
	int hmargin=0,vmargin=0;
	int x=Rect.Left+vmargin,y=Rect.Top+hmargin,fx=0,fy=0;
	UnicodeString buff = Text;
	TColor baseColor = Cv->Font->Color;

	TagCut(buff);

	// ^OȂꍇ͒ʏ`
	if( stdTag.size()==0 ){
		DRAWTEXTPARAMS prm;
		prm.cbSize = sizeof(DRAWTEXTPARAMS);
		prm.iTabLength = 4;
		prm.iLeftMargin = 2;
		prm.iRightMargin = 2;
		prm.uiLengthDrawn = 0;

		DrawTextEx(Cv->Handle
			,buff.c_str()
			,-1,&Rect,DT_SINGLELINE|DT_VCENTER|DT_END_ELLIPSIS|DT_NOCLIP|DT_NOPREFIX
			,&prm);

		return;
	}

	UnicodeString ch = L"...";
	int ew = Cv->TextWidth("....");
	int yy;
	TRect rr;

	// ^Oꍇ͂P`
	for(int i=1;i<buff.Length()+1;i++ )
	{
		if (buff[i]==L'\n'){
			continue;
		}
		std::list<TAG>::iterator Itr = stdTag.begin();
		while( Itr!=stdTag.end() )
		{
			if (Itr->pos==i) {
				UnicodeString us = Itr->Text;
				Cv->Font->Style = Itr->SetFontStyle(Cv->Font->Style);

				if( Itr->Text=="font" ){
					Cv->Font->Color = Itr->Color;
					Cv->Refresh();
					SetBkMode(Cv->Handle,TRANSPARENT);
				}
				if (Itr->Text=="/font") {
					Cv->Font->Color = baseColor;
					Cv->Refresh();
					SetBkMode(Cv->Handle,TRANSPARENT);
				}
			}
			Itr++;
		}
		fx = Cv->TextWidth(buff[i]);
		fy = Cv->TextHeight(buff[i]);

		yy = Rect.top+(Rect.Height()-fy)/2;
		rr = Rect;
		rr.left = x;
		rr.right = rr.left+fx;

		// g𒴂ȂuEEEvɕύX
		if ( (x+ew)>=Rect.Right ){
			Cv->Font->Color = baseColor;
			Cv->Refresh();
			SetBkMode(Cv->Handle,TRANSPARENT);
			DrawText(Cv->Handle,L"...",-1,&rr
				,DT_SINGLELINE|DT_VCENTER|DT_NOCLIP|DT_NOPREFIX);
			break;
		}else{
			ch = buff[i];
			Cv->Brush->Color = clGray;
			DrawText(Cv->Handle,ch.c_str(),-1,&rr
				,DT_SINGLELINE|DT_VCENTER|DT_NOCLIP|DT_NOPREFIX);
			x+=fx+vmargin;
		}
	}
}
