//---------------------------------------------------------------------------

#ifndef TPluginH
#define TPluginH
//---------------------------------------------------------------------------

#include "TSectionList.h"
#include "TDeckData.h"
#include "TCardParams.h"
#include "TCardListResult.h"
#include "TCardListReference.h"

#include "TRTFtoHtml.h"
#include "frmCardImage.h"

/**
	@brief	svOCNX

	s̃J[hAfbLȂǂ̃NXǗANX
	ڑ삷邱ƂȂ悤ɂ邽߂̃NXB

	\ZNV
		No     	J[hԍ
		Image		J[h摜
		Limit  	ʖ


	QƃJ[hXgȂdll͉\ȂB



*/
class TPlugin
{

private:

	/** ݃[hĂsbf */
	UnicodeString tcgName;

	/** Ǘpj[NL[ */
	UnicodeString uniqueKey;

	/** J[hXgt@C */
	TStringList* cardList;

	/** vOCo[W
		݂͖gp
	*/
	int version;

	/**
	@brief           Init@C̃[h
	@param[in]       asIniFile	Init@C
	@return          true	

	Iniǂݏ̊֐x̂ŎB
	݂SectionFormat̐͌Ă܂B
	*/
	bool HighLoad(AnsiString asIniFile);

	/**
	@brief           x_CAO̕\
	@param[out]      lpwsText	G[bZ[W{
	@param[out]      lpwsTitle	bZ[W^Cg

	MessageBoxExŌx_CAO\܂
	*/
	void AlartDialog(const wchar_t* lpwsText,const wchar_t* lpwsTitle);

	/**
	@brief           [hĂsgetter
	@return          [hĂs
	*/
	UnicodeString GetTcgName(void);

	/**
	@brief           o[Wgetter
	@return          o[W
	*/
	int GetVersion(void);

	/**
	@brief           fbLύXtOgetter
	@return          fbLύXtO
	*/
	bool IsChanged(void);

	/**
	@brief           f[^getter
	@return					 f[^
	*/
	int GetSearchResult(void);

	/**
	@brief           fbLeLXg쐬
	@return          fbLeLXg

	uۑvuNbv{[hv{eLXgȂ̂łB
	*/
	AnsiString DeckText(void);

	/** C[WZipt@C */
	UnicodeString zipFile;

protected:

	/** [hinit@C */
	UnicodeString iniFile;

	/** eLXgGAɕ\L[Xg */
	TStringList* textKeyStrings;

	/** J[hXgZNVtH[}bg */
	UnicodeString cardListSectionFormat;

	/** fbLXgZNVtH[}bg */
	UnicodeString deckListSectionFormat;

	/** J[hp[^ */
	TCardParams *cardParams;

	/** fbLXg */
	TDeckData *deckData;

	/** QƗpJ[hXg */
	TCardListReference *cardListReference;

	/** ʃJ[hXg */
	TCardListResult *cardListResult;

	/** J[hXgJ */
	TSectionList *cardListSection;

	/** fbLXgJ */
	TSectionList *deckListSection;


public:

	/** vpeB:o[W */
	__property int Version={read=GetVersion};

	/** vpeB:TCG */
	__property UnicodeString TcgName={read=GetTcgName};

	/** vpeB:ύXtO */
	__property bool Changed={read=IsChanged};

	/** vpeB:f[^ */
	__property int SearchResult={read=GetSearchResult};

	/** vpeB:j[NL[ */
	__property UnicodeString UniqueKey={read=uniqueKey};

	/**
	@brief           RXgN^
	*/
	TPlugin(void);

	/**
	@brief           fXgN^
	*/
	~TPlugin(void);

	/**
	@brief           vOC[h
	@param[in]       IniFile ǂݍރt@C
	@param[in]       high ǂݍ
	@return          true	
	@return					 false s
	*/
	bool Load(UnicodeString IniFile,bool high);

	/**
	@brief           vOCJ
	@return          true 
	@return					 false s
	*/
	bool Unload(void);

	/**
	@brief           fbLǂݍ
	@param[in]       DeckFile  fbLt@C
	@return          true 	
	@return					 false s

	sbfقȂꍇ̓G[_CAO\܂B

	@note	ۑ`UnicodesjisɕύXɂȂ܂ 2011/10/29
	*/
	bool DeckLoad(UnicodeString DeckFile);

	/**
	@brief           fbLۑ
	@param[in]       DeckFile  fbLt@C
	@return          true	
	@return					 false	s

	@note	ۑ`UnicodesjisɕύXɂȂ܂ 2011/10/29
	*/
	bool DeckSave(UnicodeString DeckFile);

	/**
	@brief           Nbv{[hɃfbL\t
	*/
	void DeckClipBoard(void);

	/**
	@brief           fbLf[^
	@return          true	
	@return					 false s
	*/
	bool DeckNew(void);

	/**
	@brief           fbLɒǉ
	@param[in]       Index  Xg̃CfbNX
	@param[in]       Layer ǉ̈
	@return          >=0 ǉfbLCfbNX
	@return					 -1	s
	*/
	int DeckAdd(int Index,int Layer);

	/**
	@brief           fbL炷
	@param[in]       Layer	폜̈
	@param[in]       Index  폜CfbNX
	@return          -1	s
	*/
	int DeckDel(int Layer,int Index);

	/**
	@brief           fbLXg̃ACeւ
	@param[in]       Layer ̈CfbNX
	@param[in]       SrcIndex  O
	@param[in]       DestIndex  
	@return          -
	*/
	int DeckSwap(int Layer,int SrcIndex,int DestIndex);


	/**
	@brief           ʃXg̃eLXg擾
	@param[in]       Index	CfbNX
	@param[in]       SubItem	TuACeCfbNX
	@return          YeLXg
	*/
	UnicodeString __fastcall GetCardListText(int Index,int SubItem);

	/**
	@brief           fbLXg̃eLXg擾
	@param[in]       LayerIndex	̈CfbNX
	@param[in]       Index	XgCfbNX
	@param[in]       SubItem	TuCfbNX
	@return          -
	*/
	UnicodeString __fastcall GetDeckListText(int LayerIndex,int Index,int SubItem);

	/** J[hC[W\ */
	#define	CARD_SHOW		1
	/** J[hC[W\ */
	#define CARD_HIDE   0
	void __fastcall CardImage(int X,int Y,int Visibled,wchar_t* lpFileName);


	/** J[hXg\[g */
	void __fastcall CardListSort(int ColumnIndex,int SortUp);

};


#endif
