//---------------------------------------------------------------------------


#pragma hdrstop

#include "TPlugin.h"
#include <IniFiles.hpp>
#include <Clipbrd.hpp>
#include <stdio.h>

//---------------------------------------------------------------------------

#pragma package(smart_init)

// szDatahedendň͂܂ꂽԂ
UnicodeString GetSectionText(char hed,char end,const char* szData)
{
	UnicodeString as = szData;
	int n1 = as.Pos(hed);
	if( n1!=1 ){
  	return L"";
	}
	as = as.Delete(1,n1);

	int n2 = as.Pos(end);

	as = as.SetLength(n2-1);
	return as;
}
//---------------------------------------------------------------------------

// szDataKey = ValueԂ܂B
int GetKeyValue(char* *Key,char* *Value, char* szData)
{
	char* eq;

	eq = strstr(szData,"\n");
	if (eq!=NULL) {
		*eq = '\0';
	}

	*Key = &szData[0];
	eq = strstr(szData,"=");

	if (eq==NULL) {
		*Key = NULL;
		*Value = NULL;
		return -1;
	}

	char* hd = eq;
	*Value = eq;

	while( *hd=='='|| *hd==' '|| *hd=='\t' ){hd++;}
	*Value = hd;
	while( *eq=='='||*eq==' '||*eq=='\t' )
	{
		*eq = '\0';
		eq--;
	}

	return 0;
}

//---------------------------------------------------------------------------

/****************************************************************************

	P R I V A T E

****************************************************************************/

void TPlugin::AlartDialog(const wchar_t* lpwsText,const wchar_t* lpwsTitle)
{
	MessageBoxEx(NULL,lpwsText,lpwsTitle
			,MB_OK|MB_ICONERROR,0);
}
//---------------------------------------------------------------------------

UnicodeString TPlugin::GetTcgName(void)
{
	return tcgName;
}
//---------------------------------------------------------------------------

int TPlugin::GetVersion(void)
{
	return version;
}
//---------------------------------------------------------------------------

bool TPlugin::IsChanged(void)
{
	return deckData->Changed;
}
//---------------------------------------------------------------------------

int TPlugin::GetSearchResult(void)
{
	return cardListResult->Count;
}
//---------------------------------------------------------------------------

AnsiString TPlugin::DeckText(void)
{
	AnsiString Text;

	for(int i=0;i<deckData->LayerCount;i++ )
	{
		Text += UnicodeString().sprintf(L"\n[%s]\n",deckData->Layer[i]->Name.c_str());

		for(int j=0;j<deckData->Layer[i]->Count;j++ )
		{
			DeckItemItr item = deckData->Layer[i]->Item[j];
			TCardItem *cardItem = cardListReference->Data[item->UniqueID];

			Text += UnicodeString().sprintf(L"%2d\t%s",item->Count,item->UniqueID.c_str());

			for(int k=1;k<deckListSection->ShowCount;k++ )
			{
				TSectionItem* column = deckListSection->ShowItem[k];
				Text += L"\t";
				for(int l=0;l<column->Keys->Count;l++ )
				{
					Text += cardItem->SubItem[column->Keys->Strings[l]];
				}
			}

			Text += L"\n";
		}
	}

	return Text;
}
//---------------------------------------------------------------------------

/*
	TIniFilegpf[^ǂݍ݂x̂ō
	\KȂ̂ŃG[o邩Ȃ
*/
bool TPlugin::HighLoad(AnsiString asIniFile)
{
	#define	HIGH_LOAD_BUFFER	2048

	FILE* fp = fopen(asIniFile.c_str(),"rt");
	if (fp==NULL) {
		return false;
	}

	char szBuff[HIGH_LOAD_BUFFER];
	TCardItem cardItem;
	bool cardSection=false;
	AnsiString asBuff;
	char* key;
	char* value;

	while( fgets(szBuff,HIGH_LOAD_BUFFER,fp)!=NULL )
	{
		asBuff = GetSectionText('[',']',szBuff);
		if ( !asBuff.IsEmpty() ) {
			if ( asBuff.Pos("CardData")!=0){
				if (cardItem.SubItem[uniqueKey].Length()!=0) {
					cardListReference->SetFindData(cardItem.SubItem[uniqueKey],cardItem);
				}
				cardItem.Clear();
				cardSection = true;
			}else{
				cardSection = false;
			}
		}else{
			if (cardSection==true ){
				if ( GetKeyValue(&key,&value,szBuff)==0 ){
					cardItem.SubItem[key] = value;
try{
					cardParams->FindData(key)->AddList(value);
}catch(...){
//	MessageBox(NULL,UnicodeString().printf(L"p[^ɐ錾ĂȂF%s",key.c_str()).c_str(),L"HighLoad",MB_OK);
}
				}
			}
		}
	}
	if (cardItem.SubItem[uniqueKey].Length()!=0) {
		cardListReference->SetFindData(cardItem.SubItem[uniqueKey],cardItem);
	}

	fclose(fp);

	return true;
}
//---------------------------------------------------------------------------

/****************************************************************************

	P U B L I C

****************************************************************************/

TPlugin::TPlugin(void)
{
	cardParams = new TCardParams();
	deckData = new TDeckData();
	cardListSection = new TSectionList();
	deckListSection = new TSectionList();
	cardListResult = new TCardListResult();
	cardListReference = new TCardListReference();
	fmCardImage = new TfmCardImage(NULL);

	textKeyStrings = new TStringList();
	cardList = new TStringList();
}
//---------------------------------------------------------------------------

TPlugin::~TPlugin(void)
{
#define	RELEASE(A)	if (A!=NULL ){delete A;A=NULL;};

	RELEASE(cardList);
	RELEASE(textKeyStrings);
	RELEASE(cardListResult);
	RELEASE(cardListReference);
	RELEASE(cardParams);
	RELEASE(deckData);
	RELEASE(cardListSection);
	RELEASE(deckListSection);
	RELEASE(fmCardImage);
}
//---------------------------------------------------------------------------

/*
	J[hf[^ǂݍގɈӊOƎԂ̂Łu[hvƂ~H
*/
bool TPlugin::Load(UnicodeString IniFile,bool high)
{
	int ret;

	Unload();

	iniFile = IniFile;

	TIniFile *ini = new TIniFile(IniFile);

	tcgName = ini->ReadString(L"System",L"Name",L"");
	uniqueKey = ini->ReadString(L"System",L"UniqueKey",L"No");
	textKeyStrings->CommaText = ini->ReadString(L"System",L"TextKey",L"Text");
	version = ini->ReadInteger(L"System",L"Version",0);
	cardList->CommaText = ExtractFileName(ini->ReadString(L"System","CardList",IniFile));
	zipFile = ini->ReadString(L"System",L"Image",L"");

	fmCardImage->ZipList->CommaText = zipFile;
	for(int i=0;i<fmCardImage->ZipList->Count;i++ )
	{
		fmCardImage->ZipList->Strings[i]
		 = ExtractFilePath(Application->ExeName)+ "plugin\\" + fmCardImage->ZipList->Strings[i];
	}

	cardListSectionFormat = ini->ReadString("System","CardListFormat","CardListSection%02d");
	deckListSectionFormat = ini->ReadString("System","DeckListFormat","DeckListSection%02d");

	delete ini;

	if (tcgName.Length()==0 ){
		return false;
	}
	if (uniqueKey.Length()==0) {
		return false;
	}

	cardParams->Init(iniFile);

	// \
	for(int i=0;i<cardList->Count;i++ )
	{
		UnicodeString cardFile = ExtractFilePath(iniFile)+cardList->Strings[i];
		if (high) {
			HighLoad(cardFile);
		}else{
			cardListReference->CardParams = cardParams;
			cardListReference->Init(cardFile);
		}
	}
	// J[hXgZNV
	ret=cardListSection->Init(IniFile,cardListSectionFormat);

	if( cardListSection->Count==0 ){
		// UniqueKey擪Text錾ȊÕp[^玩
		TCardParamItem* it = cardParams->FindData(UniqueKey);
		if( it==NULL ){ // UniqueKeyG[
		}
		cardListSection->AddItem(new TSectionItem(it->Name,it->Key,100,true) );
		for(int i=0;i<cardParams->Count;i++ ){
			it = cardParams->Item[i];
			if( it->Key==UniqueKey ){
				continue;
			}
			if( textKeyStrings->IndexOf(it->Key)!=-1 ){
				continue;
			}
			cardListSection->AddItem(new TSectionItem(it->Name,it->Key,100,true) );
		}
	}
	for(int i=0;i<cardListSection->Count;i++ )
	{
		TSectionItem* item = cardListSection->Item[i];
		if( item->Name==NULL || item->Name==L"" ){
			item->Name = cardParams->FindData( item->Keys->Strings[0] )->Name;
		}
	}

	// fbLXgZNV
	ret=deckListSection->Init(IniFile,deckListSectionFormat);
	if( deckListSection->ShowCount==0 ){ // bZ[W\Ď쐬
		TCardParamItem* it = cardParams->FindData(UniqueKey);
		if( it==NULL ){ // UniqueKeyG[
		}
		deckListSection->AddItem(new TSectionItem(it->Name,it->Key,100,true) );
		for(int i=0;i<cardParams->Count;i++ ){
			it = cardParams->Item[i];
			if( it->Key==UniqueKey ){
				continue;
			}
			if( textKeyStrings->IndexOf(it->Key)!=-1 ){
				continue;
			}
			deckListSection->AddItem(new TSectionItem(it->Name,it->Key,100,true) );
		}
	}
	for(int i=0;i<deckListSection->Count;i++ )
	{
		TSectionItem* item = deckListSection->Item[i];
		if (item->Name==L"") {
			item->Name = cardParams->FindData(item->Keys->Strings[0])->Name;
		}
	}

	deckData->Init(IniFile.w_str());

	return true;
}
//---------------------------------------------------------------------------

bool TPlugin::Unload(void)
{
	tcgName = L"";
	iniFile = L"";
	uniqueKey = L"";
	textKeyStrings->Clear();
	version = 0;
	zipFile = L"";

	cardParams->Term();
	cardListReference->Term();
	cardListSection->Term();
	deckListSection->Term();
	deckData->Term();

	return true;
}
//---------------------------------------------------------------------------

/*
	AnsiStringɂȂ܂B
*/
bool TPlugin::DeckLoad(UnicodeString DeckFile)
{
	AnsiString deckFile = DeckFile;
	char szBuff[1024]={NULL};
	int layerIndex = -2;

	FILE* fp = fopen(deckFile.c_str(),"rt");
	if (fp==NULL) {
		AlartDialog(L"t@CJ܂ł",L"f[^[hG[");
		return false;
	}

	DeckNew();

	AnsiString buffer;
	while( fgets(szBuff,1024,fp)!=NULL )
	{
		switch( szBuff[0] )
		{
		case '=': // TCG
			buffer="";
			if (layerIndex!=-2) {
				AlartDialog(L"Qڂ̂sbfݒ",L"f[^[hG[");
				goto DeckLoadError;
			}
			if (TcgName!=GetSectionText('=','=',szBuff) ) {
				AlartDialog(L"sbfႢ܂",L"f[^[hG[");
				goto DeckLoadError;
			}
			layerIndex++;
			break;

		case '[': // ̈
			buffer="";
			layerIndex++;
			if (deckData->Layer[layerIndex]->Name!=GetSectionText('[',']',szBuff)) {
				AlartDialog(L"̈於Ⴄ",L"f[^[hG[");
				goto DeckLoadError;
			}
			break;

		default:
			{
				int count=0;
				char szUniqueID[128]={NULL};
				sscanf(szBuff,"%d %s",&count,&szUniqueID);

				for(int i=0;i<count;i++ )
				{
					deckData->Layer[layerIndex]->Add(szUniqueID);
				}
			}
			break;
		}
	}

	deckData->Changed = false;
	fclose(fp);
	return true;

DeckLoadError:
	fclose(fp);
	DeckNew();
	return false;
}

//---------------------------------------------------------------------------
/*
	TDeckDataƃJ[hgpłȂ̂PluginŎ
	Nbv{[hɑeLXgƋp̂߂ɕύX\

	R[hAnsiɒ܂B
*/
bool TPlugin::DeckSave(UnicodeString DeckFile)
{
	AnsiString deckFile = DeckFile;

	FILE* fp = fopen(deckFile.c_str(),"wt");
	if (fp==NULL) {
		return false;
	}

	AnsiString Text = UnicodeString().sprintf(L"=%s=\n",TcgName.c_str())+DeckText();
	fprintf(fp,Text.c_str() );
	fclose(fp);

	deckData->Changed = false;
	return true;
}
//---------------------------------------------------------------------------

void TPlugin::DeckClipBoard(void)
{
	TClipboard* clip = new TClipboard();
	UnicodeString us = DeckText();

	clip->Clear();
	clip->SetTextBuf( us.w_str() );

	delete clip;
}
//---------------------------------------------------------------------------

bool TPlugin::DeckNew(void)
{
	deckData->Clear();
	deckData->Changed = false;

	fmCardImage->Enabled = false;
	fmCardImage->Enabled = true;

	return true;
}
//---------------------------------------------------------------------------

#define	LIMIT_TAG	L"Limit"

int TPlugin::DeckAdd(int Index,int Layer)
{
	TCardItem* card = cardListResult->Item[Index];

	UnicodeString us = card->NoTagText[LIMIT_TAG];
	int n = _wtoi(us.c_str());

	fmCardImage->Enabled = false;
	fmCardImage->Enabled = true;

	return deckData->Layer[Layer]->Add(card->SubItem[uniqueKey],n);
}
//---------------------------------------------------------------------------

int TPlugin::DeckDel(int Layer,int Index)
{
	fmCardImage->Enabled = false;
	fmCardImage->Enabled = true;

	CardImage(0,0,false,NULL);

	return deckData->Layer[Layer]->Del(Index);
}
//---------------------------------------------------------------------------

int TPlugin::DeckSwap(int Layer,int SrcIndex,int DestIndex)
{
	fmCardImage->Enabled = false;
	fmCardImage->Enabled = true;

	return deckData->Layer[Layer]->Swap(SrcIndex,DestIndex)==0;
}
//---------------------------------------------------------------------------

UnicodeString __fastcall TPlugin::GetCardListText(int Index,int SubItem)
{
	TCardItem* card = cardListResult->Item[Index];
	UnicodeString buff;

	for(int i=0;i<cardListSection->ShowItem[SubItem]->Keys->Count;i++)
	{
		buff += card->SubItem[cardListSection->ShowItem[SubItem]->Keys->Strings[i]];
	}

	return buff;
}
//---------------------------------------------------------------------------


UnicodeString __fastcall TPlugin::GetDeckListText(int LayerIndex,int Index,int SubItem)
{
	TDeckLayer* layer = deckData->Layer[LayerIndex];
	TCardItem* card = cardListReference->Data[layer->Item[Index]->UniqueID];
	UnicodeString buff;

	if (SubItem==0 ){
		return layer->Item[Index]->Count;
	}
	else{
		for(int i=0;i<deckListSection->ShowItem[SubItem-1]->Keys->Count;i++)
		{
			buff += card->SubItem[ deckListSection->ShowItem[SubItem-1]->Keys->Strings[i] ];
		}
		return buff;
	}
}
//---------------------------------------------------------------------------

void __fastcall TPlugin::CardImage(int X,int Y,int Visibled,wchar_t* lpFileName)
{
	if( Visibled ){
		if( fmCardImage->LoadImageW(lpFileName) ){
			fmCardImage->Left = X-10;
			fmCardImage->Top = Y-10;
			fmCardImage->Timer1->Enabled = true;
		}
	}else{
		fmCardImage->Hide();
		fmCardImage->Timer1->Enabled = false;
	}
}

//---------------------------------------------------------------------------
void __fastcall TPlugin::CardListSort(int ColumnIndex,int SortUp)
{
	cardListResult->Sort(cardListSection->ShowItem[ColumnIndex]->Keys,SortUp);
}

//---------------------------------------------------------------------------

