//---------------------------------------------------------------------------


#pragma hdrstop

#include "TDeckLayer.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

/****************************************************************************

	P R I V A T E

****************************************************************************/

int TDeckLayer::GetTotal(void)
{
	int total=0;
	std::vector<TDeckItem>::iterator Itr = List.begin();

	while(Itr!=List.end())
	{
		total += Itr->Count;
		Itr++;
	}

	return total;
}
//---------------------------------------------------------------------------

int TDeckLayer::GetCount(void)
{
	return static_cast<int>(List.size());
}
//---------------------------------------------------------------------------

DeckItemItr TDeckLayer::GetItem(int Index)
{
	return &List[Index];
}
//---------------------------------------------------------------------------
int TDeckLayer::GetTotalLimit(void)
{
	return totalLimit;
}
//---------------------------------------------------------------------------

int TDeckLayer::GetItemLimit(void)
{
	return itemLimit;
}
//---------------------------------------------------------------------------

UnicodeString TDeckLayer::GetName(void)
{
	return name;
}
//---------------------------------------------------------------------------

void TDeckLayer::SetItemIndex(int Index)
{
	itemIndex = Index;
}
//---------------------------------------------------------------------------

int TDeckLayer::GetItemIndex(void)
{
	return itemIndex;
}
//---------------------------------------------------------------------------

bool TDeckLayer::IsChanged(void)
{
	return changed;
}
//---------------------------------------------------------------------------

void TDeckLayer::SetChanged(bool val)
{
	changed = val;
}
//---------------------------------------------------------------------------


/****************************************************************************

	P U B L I C

****************************************************************************/

TDeckLayer::TDeckLayer(UnicodeString Name,int TotalLimit,int ItemLimit)
	: totalLimit(TotalLimit),itemLimit(ItemLimit)
{
	name = Name;
	Clear();
}
//---------------------------------------------------------------------------

void TDeckLayer::Clear(void)
{
	List.clear();
	itemIndex = -1;
	changed = false;
}
//---------------------------------------------------------------------------


int TDeckLayer::Add(UnicodeString UniqueID,int Limit)
{
	if (GetTotal()>=GetTotalLimit()) {
		return -1;
	}

	DeckItemItr item = FindItem(UniqueID);
	if(  Limit==0 ){
		Limit = GetItemLimit();
	}

	if (item->Count>=Limit) {
		return -2;
	}

	item->Count = item->Count+1;
	changed = true;

	return IndeOf(UniqueID);
}
//---------------------------------------------------------------------------

int TDeckLayer::Del(int Index)
{
	DeckItemItr item = GetItem(Index);

	item->Count = item->Count-1;
	changed = true;

	if (item->Count<=0) {
		List.erase(item);
		return 0;
	}

	return 1;
}
//---------------------------------------------------------------------------

int TDeckLayer::IndeOf(UnicodeString UniqueID)
{
	DeckItemItr Itr = List.begin();
	int n=0;

	while( Itr!=List.end() )
	{
		if (Itr->UniqueID==UniqueID) {
			return n;
		}
		Itr++;
		n++;
	}

	return -1;
}
//---------------------------------------------------------------------------

DeckItemItr TDeckLayer::FindItem(UnicodeString UniqueID)
{
	DeckItemItr Itr = List.begin();

	while(Itr!=List.end())
	{
		if (Itr->UniqueID==UniqueID) {
			return &Itr.operator *();
		}
		Itr++;
	}

	TDeckItem item(UniqueID);
	List.push_back(item);

	return FindItem(UniqueID);
}
//---------------------------------------------------------------------------

int TDeckLayer::Swap(int SrcIndex,int DestIndex)
{
	if( SrcIndex < 0 || Count <= SrcIndex
	|| DestIndex < 0 || Count <= DestIndex ){
  	return -1;
	}

	DeckItemItr src = Item[SrcIndex];
	DeckItemItr dest = Item[DestIndex];

	int cnt = src->Count;
	UnicodeString id = src->UniqueID;

	src->Count = dest->Count;
	src->UniqueID = dest->UniqueID;

	dest->Count = cnt;
	dest->UniqueID = id;

	return 0;
}
//---------------------------------------------------------------------------


