//---------------------------------------------------------------------------


#pragma hdrstop

#include "TDeckData.h"
#include <stdio.h>
#include <IniFiles.hpp>

//---------------------------------------------------------------------------

#pragma package(smart_init)

/****************************************************************************

	P R I V A T E

****************************************************************************/

int TDeckData::GetLayerCount(void)
{
	return static_cast<int>(layers.size());
}
//---------------------------------------------------------------------------

TDeckLayer* TDeckData::GetLayer(int Index)
{
	return &layers[Index];
}
//---------------------------------------------------------------------------

bool TDeckData::IsChanged(void)
{
	bool changed=false;

	std::vector<TDeckLayer>::iterator Itr = layers.begin();
	while( Itr!=layers.end())
	{
		changed |= Itr->Changed;
		Itr++;
	}

	return changed;
}
//---------------------------------------------------------------------------

void TDeckData::SetChanged(bool val)
{
	std::vector<TDeckLayer>::iterator Itr = layers.begin();
	while( Itr!=layers.end())
	{
		Itr->Changed = val;
		Itr++;
	}
}
//---------------------------------------------------------------------------


/****************************************************************************

	P U B L I C

****************************************************************************/

//---------------------------------------------------------------------------

bool TDeckData::Init(UnicodeString IniFile)
{
	TIniFile* ini = new TIniFile(IniFile);

	UnicodeString Name;
	UnicodeString Section;

	int TotalLimit=0;
	int ItemLimit=0;

	tcgName = ini->ReadString(L"System",L"Name",L"").w_str();

	SectionFormat = ini->ReadString("System","DeckLayerFormat","DeckLayer%02d");

	for(int i=0;;i++ )
	{
		Section.printf(SectionFormat.c_str(),i);
		Name = ini->ReadString(Section,L"Name","");
		TotalLimit = ini->ReadInteger(Section,L"TotalLimit",-1);
		ItemLimit = ini->ReadInteger(Section,L"ItemLimit",-1);

		if (Name.Length()==0 || TotalLimit==-1 || ItemLimit==-1) {
			break;
		}

		layers.push_back( TDeckLayer(Name.w_str(),TotalLimit,ItemLimit) );
	}

	delete ini;

	return true;
}
//---------------------------------------------------------------------------

bool TDeckData::Term(void)
{
	layers.clear();
	return true;
}
//---------------------------------------------------------------------------

void TDeckData::Clear(void)
{
	std::vector<TDeckLayer>::iterator Itr = layers.begin();
	while( Itr!=layers.end())
	{
		Itr->Clear();
		Itr++;
	}

	Changed = false;
}
//---------------------------------------------------------------------------


