//---------------------------------------------------------------------------


#pragma hdrstop

#include <IniFiles.hpp>
#include "TCardParams.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

/****************************************************************************

	P R I V A T E

****************************************************************************/

int TCardParams::GetCount(void)
{
	return static_cast<int>(Items.size() );
}
//---------------------------------------------------------------------------

TCardParamItem* TCardParams::GetItem(int Index)
{
	if (0<= Index && Index < GetCount() ) {
		return Items[Index];
	}else{
		return NULL;
	}
}
//---------------------------------------------------------------------------

/****************************************************************************

	P U B L I C

****************************************************************************/

TCardParams::TCardParams(void)
{

}
//---------------------------------------------------------------------------

TCardParams::~TCardParams(void)
{

}
//---------------------------------------------------------------------------

bool TCardParams::Init(UnicodeString IniFile)
{
	TIniFile* ini = new TIniFile(IniFile);

	UnicodeString Key;
	UnicodeString Name;
	UnicodeString Section;
	int Type;
	int Width;

	for(int i=0;;i++ )
	{
		Section.printf(L"Param%02d",i);

		Key = ini->ReadString(Section,L"Key",L"");
		Name = ini->ReadString(Section,L"Name",L"");
		Type = ini->ReadInteger(Section,L"Type",0);
		Width = ini->ReadInteger(Section,L"Width",100);

		if (Key.Length()==0 || Name.Length()==0 || Type==-1) {
			break;
		}

		TCardParamItem *item = new TCardParamItem(Key,Name,Type);
		item->Index = i;
		item->Width = Width;
		Items.push_back( item );
	}

	delete ini;
	return true;
}
//---------------------------------------------------------------------------

bool TCardParams::Term(void)
{
	Items.clear();
	return true;
}
//---------------------------------------------------------------------------

TCardParamItem* TCardParams::FindData(UnicodeString Key)
{
	std::vector<TCardParamItem*>::iterator Itr = Items.begin();

	while(Itr!=Items.end())
	{
		if ((*Itr)->Key==Key) {
			return *Itr;
		}

		Itr++;
	}

	return NULL;//Items.end();
}
//---------------------------------------------------------------------------

void TCardParams::SaveToFile(UnicodeString IniFile)
{
	TIniFile *ini = new TIniFile(IniFile);
	UnicodeString Section;

	for(int i=0;i<Count;i++ )
	{
		Section.printf(L"Param%02d",i);
		ini->WriteInteger(Section,L"Width",Item[i]->Width);
	}

	delete ini;
}
//---------------------------------------------------------------------------

void TCardParams::Add(TCardParamItem* Data)
{
	Items.push_back(Data);
}
//---------------------------------------------------------------------------


