// ---------------------------------------------------------------------------

#pragma hdrstop

#include "TCardListResult.h"
#include <algorithm>

// ---------------------------------------------------------------------------

#pragma package(smart_init)

/** **************************************************************************

P R I V A T E

 *************************************************************************** */

int TCardListResult::GetCount(void) {
		return static_cast<int>(items.size());
}
// ---------------------------------------------------------------------------

TCardItem* TCardListResult::GetItem(int Index) {
		return items[Index];
}
// ---------------------------------------------------------------------------

void TCardListResult::SetItem(int Index, TCardItem* CardItem) {
		items.push_back(CardItem);
}
// ---------------------------------------------------------------------------

/** **************************************************************************

P U B L I C

 *************************************************************************** */

void TCardListResult::Clear(void) {
		items.clear();
}
// ---------------------------------------------------------------------------

int TCardListResult::IndexOf(UnicodeString Key, UnicodeString UniqueID) {
		for (int i = 0; i < Count; i++) {
				if (Item[i]->SubItem[Key] == UniqueID) {
						return i;
				}
		}

		return 0;
}

// ---------------------------------------------------------------------------
TStringList* CardSortKeys;
bool CardSortUp;

struct CardSort{

	int operator()( TCardItem* lhs, TCardItem* rhs )const
	{
		UnicodeString usLeft;
		UnicodeString usRight;

		for(int i=0;i<CardSortKeys->Count;i++ ){
			usLeft += lhs->NoTagText[CardSortKeys->Strings[i]];
			usRight += rhs->NoTagText[CardSortKeys->Strings[i]];
		}

		if (CardSortUp) {
			return usLeft > usRight;
		}else{
			return usLeft < usRight;
		}
	}
};

// ---------------------------------------------------------------------------
int TCardListResult::Sort(TStringList* Keys,bool SortUp)
{
	if( Keys->Count==0 ){
		return -1;
	}

	CardSortKeys = Keys;
	CardSortUp = SortUp;
	std::stable_sort(items.begin(),items.end(),CardSort());

	return 0;
}
// ---------------------------------------------------------------------------
