//---------------------------------------------------------------------------


#pragma hdrstop

#include "TCardListReference.h"
#include <IniFiles.hpp>"

//---------------------------------------------------------------------------

#pragma package(smart_init)

/****************************************************************************

	P R I V A T E

****************************************************************************/


TCardItem* TCardListReference::FindData(UnicodeString FindKey)
{
	std::map<UnicodeString,TCardItem>::iterator Itr = Items.find(FindKey);
	if (Itr!=Items.end()) {
		return &Itr->second;
	}else{
		return NULL;
	}
}
//---------------------------------------------------------------------------


/****************************************************************************

	P U B L I C

****************************************************************************/


TCardListReference::TCardListReference(void)
	: sectionsMySelf(false)
{
	cardParams = NULL;
}
//---------------------------------------------------------------------------

TCardListReference::~TCardListReference(void)
{
	Term();
}
//---------------------------------------------------------------------------

void TCardListReference::SetCardParams(TCardParams* CardParams)
{
	if (cardParams==NULL) {
		cardParams = CardParams;
	}
}
//---------------------------------------------------------------------------

bool TCardListReference::Init(UnicodeString IniFile)
{
	return ReadFromFile(IniFile);
}
//---------------------------------------------------------------------------

void TCardListReference::Term(void)
{
	Items.clear();

	if (sectionsMySelf==true) {
		cardParams->Term();
		delete cardParams;
		cardParams = NULL;
		sectionsMySelf = false;
	}
}
//---------------------------------------------------------------------------

bool TCardListReference::ReadFromFile(UnicodeString IniFile)
{
	if (cardParams==NULL) {
		cardParams = new TCardParams();
		cardParams->Init(IniFile);
		sectionsMySelf = true;
	}

	TIniFile* ini = new TIniFile(IniFile);
	UnicodeString Section;
	UnicodeString Key;
	UnicodeString Value;
	bool IsContinue=true;

	uniqueKey = ini->ReadString(L"System",L"UniqueKey",L"No");
	SectionFormat = ini->ReadString("System","CardDataFormat","CardData%04d");

	if ( uniqueKey.Length()==0 ){
		uniqueKey = cardParams->Item[0]->Key;
	}

	for(int i=0;IsContinue==true;i++ )
	{
		Section.printf(SectionFormat.c_str(),i);
		TCardItem item;
		IsContinue = false;

		for(int j=0;j<cardParams->Count;j++ )
		{
			Key = cardParams->Item[j]->Key;
			Value = ini->ReadString(Section,Key,L"");
			item.SubItem[Key] = Value;
			IsContinue |= Value.Length()!=0;
		}

		if (IsContinue==true) {
			Items[ item.SubItem[uniqueKey] ] = item;
		}
	}

	delete ini;

	return true;
}
//---------------------------------------------------------------------------

bool TCardListReference::SaveToFile(UnicodeString IniFile)
{
	TIniFile* ini = new TIniFile(IniFile);
	std::map<UnicodeString,TCardItem>::iterator Itr = Items.begin();
	UnicodeString Section;
	UnicodeString Key;
	int i=0;

	while( Itr!=Items.end() )
	{
		Section.printf(SectionFormat.c_str(),i);
		for(int j=0;j<cardParams->Count;j++)
		{
			Key = cardParams->Item[j]->Key;
			ini->WriteString(Section,Key,Itr->second.SubItem[Key]);
		}

		Itr++;
		i++;
	}

	delete ini;

	return true;
}
//---------------------------------------------------------------------------

ReferenceCardItr TCardListReference::Begin(void)
{
	return Items.begin();
}
//---------------------------------------------------------------------------

ReferenceCardItr TCardListReference::End(void)
{
	return Items.end();
}
//---------------------------------------------------------------------------

void TCardListReference::SetFindData(UnicodeString FindKey,TCardItem CardItem)
{
	Items[FindKey] = CardItem;
}
//---------------------------------------------------------------------------





