package udp.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class UDPServer implements Runnable {

    private static final int MAX_DATAGRAM_BYTES = 512;
    private static final int MAX_SEND_QUEUE = 4;
    private static final int MAX_RECV_QUEUE = 40;

    DatagramSocket socket_;
    DatagramPacket packet_ = null;

    public UDPServer(int port) throws SocketException {
        this.socket_ = new DatagramSocket(port);

        //約4データグラムぶんの送信キュー
        socket_.setSendBufferSize(MAX_DATAGRAM_BYTES * MAX_SEND_QUEUE);

        //約40データグラムぶんの受信キュー（穴埋めバイトを含む）
        socket_.setReceiveBufferSize( (MAX_DATAGRAM_BYTES + 1) * MAX_RECV_QUEUE);

    }

    @Override
    public void run() {

        while(true) {
            try {
                System.out.println("start...");
                byte[] buffer = new byte[8192];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                socket_.receive(packet);
                System.out.println("receive...");
                new ConnectionHandler(socket_, packet).run();
            } catch (IOException e) {
                // TODO 自動生成された catch ブロック
                e.printStackTrace();
            }
        }

    }

}
