package udp.server;

public class RoundTripTimer {

    float roundTripTime = 0.0f;
    float smoothedTripTime = 0.0f;
    float deviation = 0.75f;
    short retransmissions = 0;

    float currentTimeout = minmax(calculateRetransmitTimeout());


    private int calculateRetransmitTimeout() {
        final float t1  = smoothedTripTime;
        final float t2  = 4.0f * deviation;
        final float sum = t1 + t2;
        return (int) sum;
    }

    private float minmax(float rto) {
        final int minTimeout = ReliabilityConstants.MIN_RETRANSMIT_TIMEOUT;
        final int maxTimeout = ReliabilityConstants.MIN_RETRANSMIT_TIMEOUT;

        final float max = Math.max(rto,  minTimeout);
        final float min = Math.min(max, maxTimeout);

        return min;
    }

    void newPacket() {
        retransmissions = 0;
    }

    float currentTimeout() {
        return currentTimeout;
    }

    void stoppedAt(long ms) {
        roundTripTime = ms / 1000f;

        double delta = roundTripTime - smoothedTripTime;
        smoothedTripTime += delta / 8.0f;
        deviation += (Math.abs(delta) - deviation ) / 4.0f;

        currentTimeout = minmax(calculateRetransmitTimeout());
    }

    boolean isTimeout() {

        currentTimeout *= 2;
        retransmissions++;
        return retransmissions > ReliabilityConstants.MAX_RETRANSMISSIONS;

    }
}
