package udp.server;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public class ReliableDatagramSocket extends DatagramSocket {

    RoundTripTimer roundTripTimer = new RoundTripTimer();

    private boolean reinit = false;
    private long sendSequenceNo = 0;
    private long recvSequenceNo = 0;

    {
        init();
    }

    public ReliableDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(bindaddr);
        init();
    }

    public ReliableDatagramSocket(DatagramSocketImpl impl) {
        super(impl);
        // TODO 自動生成されたコンストラクター・スタブ
    }

    public ReliableDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
        init();
    }

    public ReliableDatagramSocket(int port) throws SocketException {
        super(port);
        // TODO 自動生成されたコンストラクター・スタブ
    }

    private void init() {
        this.roundTripTimer = new RoundTripTimer();
    }

    public void connect(SocketAddress dest) {
        try {
            super.connect(dest);
        } catch (SocketException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        }
        init();
    }

    public synchronized void sendReceive(DatagramPacket sendPacket,
            DatagramPacket recvPacket
            ) {
        if (reinit) {
            init();
            reinit = false;
        }

        roundTripTimer.newPacket();
        long start = System.currentTimeMillis();
        long sequenceNumber = getSendSequenceNo();
    }

    private long getSendSequenceNo() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }
}
