package udp.file;


import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

/**
 * 画像などのバイナリファイルを読み込むサンプルです。
 *
 */
public class BinaryFileReader {

    private final String filePath;


    public BinaryFileReader(String filePath) {
        this.filePath = filePath;
    }

    /**
     * メインメソッド
     * @param args
     */
    public static void main(String[] args) {
        final String path = "system.properties";
        BinaryFileReader reader = new BinaryFileReader(path);
//        byte[] bytess = reader.readByte();
//        final String text = reader.readText();
//
//        final Properties p = new Properties();
//        p.load();

//        int count = 0;
//        for (byte[] bytes : bytess) {
//            count += bytes.length;
//        }
//        System.out.println("全部で" + bytess.length + "バイト読み込みました。");
//        System.out.println(text);

       final Map<String, String> map = reader.readProperties();

       System.out.println(map.get("address"));
    }

    /**
     * バイナリファイルを読み込みます。
     *
     * @return 読み込んだデータをバイトの2次元配列で返します。
     */
    public byte[][] read() {







        BufferedInputStream fis = null;
        List<byte[]> list = new ArrayList<byte[]>();
        try {
            // 入力元ファイル
            File file = new File(filePath);

            fis = new BufferedInputStream(new FileInputStream(file));

            int avail;
            // 読み込み可能なバイト数づつ読み込む
            while ((avail = fis.available()) > 0) {
                byte[] bytes = new byte[avail];
                fis.read(bytes);

                list.add(bytes);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (fis != null) {
                    // ストリームは必ず finally で close します。
                    fis.close();
                }
            } catch (IOException e) {
            }
        }
        byte[][] result = new byte[list.size()][];
        list.toArray(result);

        return result;
    }


    public Map<String, String> readProperties() {
        final File file = new File(filePath);

        final Map<String, String> map = new HashMap<String, String>(5);

        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            final Properties p = new Properties();
            p.load(inputStream);


            for (final Entry<Object, Object> entry : p.entrySet()) {
                final Object key   = entry.getKey();
                final Object value = entry.getValue();

                final String k = toString(key);
                final String v = toString(value);

                map.put(k, v);
            }

        } catch (FileNotFoundException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        } catch (IOException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        } finally {
            close(inputStream);

        }

        return map;
    }

    private String toString(final Object aObject) {

        if (null == aObject) {
            return "";
        }

        return aObject.toString();
    }

    public byte[] readByte() {
        final File file = new File(filePath);
        final long size = file.length();
        final byte[] data = new byte[(int)size];

        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            inputStream.read(data);
        } catch (FileNotFoundException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        } catch (IOException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        } finally {
            close(inputStream);

        }

        return data;
    }

    public String readText() {
        final byte[] data = readByte();

        if ( null == data) {
            return "";
        }

        return new String(data);
    }

    private void close(final Closeable aCloseable) {
        if (null == aCloseable) {
            return;
        }

        try {
            aCloseable.close();
        } catch (IOException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        }
    }
}
