package udp.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;

import udp.file.BinaryFileReader;

public class UDPClient implements Runnable {

    private static final int MAX_DATAGRAM_BYTES = 512;
    private static final int MAX_SEND_QUEUE = 1;
    private static final int MAX_RECV_QUEUE = 4;
    private static final int MAX_RETRIES = 4;
    private static final int TIMEOUT = 2 * 1000;

    DatagramSocket socket_;
    DatagramPacket packet_;

    final byte[] buffer_;

    public UDPClient(final String path) throws SocketException, UnknownHostException {

        final BinaryFileReader propReader = new BinaryFileReader(path);
        final Map<String, String> map = propReader.readProperties();

        final String      ipAddress = map.get("address");
        final InetAddress address   = InetAddress.getByName( ipAddress );
        final int         port      = Integer.parseInt(map.get("port"));

        final int sendBuffer = Integer.parseInt(map.get("buffer.send"));
        final int recvBuffer = Integer.parseInt(map.get("buffer.recieve"));

        final String dataPath = map.get("data.path");
        final BinaryFileReader dataReader = new BinaryFileReader(dataPath);
        buffer_= dataReader.readByte();

        this.socket_ = new DatagramSocket(); //使い捨ての一時的なポート
        this.packet_ = new DatagramPacket(buffer_, buffer_.length, address, port);

        socket_.setSendBufferSize(sendBuffer);
        socket_.setReceiveBufferSize(recvBuffer);
    }


    // 間隔を増しながらリトライを繰り返す
    // リプライがなければInterruptedIOExceptionを投げる
    public int sendRecieve(byte[] buffer, int offset, int length) throws IOException {
            packet_.setData(buffer, offset, length);
            int timeout = TIMEOUT;

            for (int i = 0; i < MAX_RETRIES; i++) {

                socket_.send(packet_);

                try {

                socket_.setSoTimeout(timeout);
                socket_.receive(packet_);
                return packet_.getLength();

                } catch (InterruptedIOException e) {
                    // TODO 自動生成された catch ブロック
                    e.printStackTrace();
                    timeout *= 2;
                }

            }

            throw new IOException("over retry times");
    }

    @Override
    public void run() {
        try {
            // TODO 自動生成されたメソッド・スタブ
            sendRecieve(buffer_, 0, buffer_.length);
        } catch (IOException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        }
    }

}
