/*
 * Decompiled with CFR 0.152.
 */
package udp.server;

public class RoundTripTimer {
    float roundTripTime = 0.0f;
    float smoothedTripTime = 0.0f;
    float deviation = 0.75f;
    short retransmissions = 0;
    float currentTimeout = this.minmax(this.calculateRetransmitTimeout());

    private int calculateRetransmitTimeout() {
        float t1 = this.smoothedTripTime;
        float t2 = 4.0f * this.deviation;
        float sum = t1 + t2;
        return (int)sum;
    }

    private float minmax(float rto) {
        boolean minTimeout = true;
        boolean maxTimeout = true;
        float max = Math.max(rto, 1.0f);
        float min = Math.min(max, 1.0f);
        return min;
    }

    void newPacket() {
        this.retransmissions = 0;
    }

    float currentTimeout() {
        return this.currentTimeout;
    }

    void stoppedAt(long ms) {
        this.roundTripTime = (float)ms / 1000.0f;
        double delta = this.roundTripTime - this.smoothedTripTime;
        this.smoothedTripTime = (float)((double)this.smoothedTripTime + delta / 8.0);
        this.deviation = (float)((double)this.deviation + (Math.abs(delta) - (double)this.deviation) / 4.0);
        this.currentTimeout = this.minmax(this.calculateRetransmitTimeout());
    }

    boolean isTimeout() {
        this.currentTimeout *= 2.0f;
        this.retransmissions = (short)(this.retransmissions + 1);
        return this.retransmissions > 4;
    }
}

