/*
 * Decompiled with CFR 0.152.
 */
package udp.server;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import udp.server.RoundTripTimer;

public class ReliableDatagramSocket
extends DatagramSocket {
    RoundTripTimer roundTripTimer = new RoundTripTimer();
    private boolean reinit = false;
    private long sendSequenceNo = 0L;
    private long recvSequenceNo = 0L;

    public ReliableDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(bindaddr);
        this.init();
        this.init();
    }

    public ReliableDatagramSocket(DatagramSocketImpl impl) {
        super(impl);
        this.init();
    }

    public ReliableDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
        this.init();
        this.init();
    }

    public ReliableDatagramSocket(int port) throws SocketException {
        super(port);
        this.init();
    }

    private void init() {
        this.roundTripTimer = new RoundTripTimer();
    }

    @Override
    public void connect(SocketAddress dest) {
        try {
            super.connect(dest);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        this.init();
    }

    public synchronized void sendReceive(DatagramPacket sendPacket, DatagramPacket recvPacket) {
        if (this.reinit) {
            this.init();
            this.reinit = false;
        }
        this.roundTripTimer.newPacket();
        long start = System.currentTimeMillis();
        long sequenceNumber = this.getSendSequenceNo();
    }

    private long getSendSequenceNo() {
        return 0L;
    }
}

