/*
 * Decompiled with CFR 0.152.
 */
package udp.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import udp.file.BinaryFileReader;

public class UDPClient
implements Runnable {
    private static final int MAX_DATAGRAM_BYTES = 512;
    private static final int MAX_SEND_QUEUE = 1;
    private static final int MAX_RECV_QUEUE = 4;
    private static final int MAX_RETRIES = 4;
    private static final int TIMEOUT = 2000;
    DatagramSocket socket_;
    DatagramPacket packet_;
    final byte[] buffer_;

    public UDPClient(String path) throws SocketException, UnknownHostException {
        BinaryFileReader propReader = new BinaryFileReader(path);
        Map<String, String> map = propReader.readProperties();
        String ipAddress = map.get("address");
        InetAddress address = InetAddress.getByName(ipAddress);
        int port = Integer.parseInt(map.get("port"));
        int sendBuffer = Integer.parseInt(map.get("buffer.send"));
        int recvBuffer = Integer.parseInt(map.get("buffer.recieve"));
        String dataPath = map.get("data.path");
        BinaryFileReader dataReader = new BinaryFileReader(dataPath);
        this.buffer_ = dataReader.readByte();
        this.socket_ = new DatagramSocket();
        this.packet_ = new DatagramPacket(this.buffer_, this.buffer_.length, address, port);
        this.socket_.setSendBufferSize(sendBuffer);
        this.socket_.setReceiveBufferSize(recvBuffer);
    }

    public int sendRecieve(byte[] buffer, int offset, int length) throws IOException {
        this.packet_.setData(buffer, offset, length);
        int timeout = 2000;
        int i = 0;
        while (i < 4) {
            this.socket_.send(this.packet_);
            try {
                this.socket_.setSoTimeout(timeout);
                this.socket_.receive(this.packet_);
                return this.packet_.getLength();
            }
            catch (InterruptedIOException e) {
                e.printStackTrace();
                timeout *= 2;
                ++i;
            }
        }
        throw new IOException("over retry times");
    }

    @Override
    public void run() {
        try {
            this.sendRecieve(this.buffer_, 0, this.buffer_.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

