
our $version = "strangeworld.pl 081021";

use lib "./lib";

use strict;

use MSN;
use URI::Escape;
use Digest::MD5 qw/ md5_hex /;
use Data::Dumper;

our $handle;
our $password;

our $botname;

our $admin;

our $datafile;
our $motdfile;
our $adminfile;

our %style_default;
our %style_system;
our %style_error;

our $setting_newcomer;

our $save_log_to_datafile;

our $debug;

require "config.pl";
require "command.pl";


our $msn = new MSN( Handle => $handle, Password => $password );

$msn->setClientInfo
(
	Client		=> 'MSNC7',
	
	MultiPacket	=> 1,
	DirectMessage	=> 0,
	
	ViewInk		=> 1,
	CreateInk	=> 1,
	
	Video		=> 0,
	Winks		=> 1,
	VoiceMessage	=> 0,
	SIP		=> 1,
	
	SecureCannel	=> 0,
	
	SharedDrive	=> 0,
	SharedSearch	=> 0,
);

$msn->setHandlers(
	Connected		=> \&Connected,
	
	Message			=> \&Message,
	Typing			=> \&Typing,
	
	Status			=> \&Status,
	
	ContactAddingUs		=> \&ContactAddingUs,
	ContactRemovingUs	=> \&ContactRemovingUs,
	
	MemberJoined		=> \&MemberJoined,
	RoomUpdated		=> \&RoomUpdated,
	
	Shake			=> \&Shake,
	Wink			=> \&Wink,
	Ink			=> \&Ink,
	FileReceiveInvitation	=> \&FileReceiveInvitation,
);

$msn->{Debug} = $msn->{ShowTX} = $msn->{ShowRX} = 1 if( $debug );


our $contacts	= 0;
our %timeouts	= ();

our $data	= eval{ require( $datafile ) } || eval{ require( $datafile."_tmp" ) } || {};
our %data	= %$data;

our $motdtime	= 0;

our @logs	= ();
our $logs_max	= 200;

our $pop_count	= 86400 * 7;

$data{SYSTEM}->{lastboot} = $data{SYSTEM}->{boottime};
$data{SYSTEM}->{boottime} = time();

$SIG{INT} = $SIG{HUP} = $SIG{QUIT} = $SIG{TERM} = \&forceQuit;

if ( $save_log_to_datafile && exists $data{LOG} )
{
	@logs = @{ $data{LOG} };
}


$msn->connect();

for ( ;; )
{
	timeoutEvent();
	$msn->do_one_loop();
}



sub Connected
{
	my( $self ) = @_;
	
	setTimeout( \&ping, 10 );
	
	updateName();
	changeTopic( $data{SYSTEM}->{topic} );
}

sub Message
{
	my( $self, $email, $name, $message, %style ) = @_;
	
	my $hash = hash( $email );
	
	
	$message =~ s/([\r\n\s]|　)+$//;
	return unless( checkMessage( $email, $message ) );
	
	if ( $message =~ m{^[\!\/\#](\w+)(?:\s+([^\n]*))?$} )
	{
		my( $cmd, $data ) = ( "cmd_". $1, defined $2 ? $2 : '' );
		
		no strict 'refs';
		return if( defined &{ $cmd } && &{ $cmd }( $email, $data ) );
	}
	
	
	$data{$hash}->{away} = 0;
	$data{SYSTEM}->{count}++; $data{$hash}->{count}++;
	
	broadcast( $email, $message, %style, Name => $name );
}

sub Typing
{
	my( $self, $email, $name ) = @_;
	
	foreach my $convo ( values %{ $msn->getConvoList() } )
	{
		if ( $email ne ( keys %{ $convo->getMembers() } )[0] )
		{
			$convo->sendTyping( $msn->{Handle} );
		}
	}
	
	setTimeout( \&ping, 60 );
}

sub Status
{
	my( $self, $email, $status, $cid ) = @_;
	
	my $hash = hash( $email );
	
	if ( $status eq "NLN" )
	{
		if ( $data{$hash}->{lastmotd} <= $motdtime )
		{
			if   ( $data{$hash}->{newcomer} )
			{
				cmd_info( $email ); $data{$hash}->{newcomer} = 0;
			}
			else {
				cmd_motd( $email );
			}
			
			$data{$hash}->{lastmotd} = time();
		}
	}
}

sub ContactAddingUs
{
	my( $self, $email ) = @_;
	
	my $hash = hash( $email );
	
	unless ( exists $data{$hash} )
	{
		$data{$hash} = { %$setting_newcomer };
		writeData();
		
		broadcast( $msn->{Handle}, "しんじんさんいらっしゃ～い。", %style_system );
	}
	
	print "ADD $hash\n";
	
	$msn->addContact( $email );
}

sub ContactRemovingUs
{
	my( $self, $email ) = @_;
	
	my $hash = hash( $email );
	
	print "REM $hash\n";
	
	$msn->remContact( $email );
}

sub MemberJoined
{
	my( $self, $email, $name ) = @_;
	
	$self->sendMessage( "メンバの招待には対応していません。\n$msn->{Handle}を登録してください。", %style_error );
	$self->leave();
}

sub RoomUpdated
{
	my( $self, $total ) = @_;
	
	if ( $total >= 2 ) {
	$self->sendMessage( "メンバの招待には対応していません。\n$msn->{Handle}を登録してください。", %style_error );
	$self->leave();
	}
}

sub Ink
{
	my( $self, $email, $data ) = @_;
	
#	foreach my $Contact ( onlineList() )
#	{
#		$msn->call( $Contact->{Email}, $data, ( Type => "Ink" ) )
#	}
	
	$self->sendMessage( "手書きメッセージには対応していません。", %style_error );
}

sub FileReceiveInvitation
{
	my( $self ) = @_;
	$self->sendMessage( "ファイルの送受信には対応していません。", %style_error );
}

sub Shake
{
	my( $self, $email, $name ) = @_;
	
	sendMessage( $email, "うるせぇバカ！", %style_error );
	$self->sendDataCast( "ID: 1\r\n" );
}

sub Wink
{
	my( $self, $email, $name, $data ) = @_;
	
	sendMessage( $email, "ウィンクの送信には対応していません。", %style_error );
}


sub onlineList
{
	my @onlines = ();
	
	foreach my $handle ( $msn->getContactList( 'FL' ) )
	{
		my $Contact = $msn->getContact( $handle );
		
		if ( !$data{ hash( $Contact->{Email} ) }->{away} &&
			$Contact->{Status} && $Contact->{Status} ne 'FLN' )
		{
			push( @onlines, $Contact );
		}
	}
	
	return @onlines;
}

sub checkMessage
{
	my( $email, $message ) = @_;
	
	my $hash = hash( $email );
	
	return 0 if( !$message || $message =~ /^AutoMessage:/ );
	
	
	if ( $data{$hash}->{limit} || $data{$hash}->{karma} > 3 )
	{
		if ( length( $message ) > 100 )
		{
			sendMessage( $email, "あなたの投稿は100byte以内に制限されています。", %style_error );
			return 0;
		}
		
		if ( $message =~ tr/\n/\n/ >= 3 )
		{
			sendMessage( $email, "あなたの投稿は3行以内に制限されています。", %style_error );
			return 0;
		}
	}
	else {
		if ( $message =~ tr/\n/\n/ >= 9 )
		{
			sendMessage( $email, "10行以上のメッセージは送信できません。", %style_error );
			return 0;
		}
	}
	
	if ( $data{$hash}->{post} > time() )
	{
		if   ( $data{$hash}->{limit} )
		{
			sendMessage( $email, "送信間隔が短過ぎます。- $message", %style_error );
			return 0;
		}
		else {
			$data{$hash}->{karma}++;
			
			sendMessage( $email, "送信間隔が短過ぎます。- $message", %style_error );
			return 0;
		}
	}
	
	
	$data{$hash}->{karma}-- if( $data{$hash}->{karma} > 0 );
	$data{$hash}->{post} = time() + ( $data{$hash}->{limit} || exp() * log( $data{$hash}->{karma} + 1 ) || 1 );
	
	return 1;
}

sub sendMessage
{
	my( $email, $message, %style ) = @_;
	
	my $hash = hash( $email );
	
	$msn->call( $email, ( $data{$hash}->{fusiana} ? "$style{Name} : $message" : "$message" ), %style );
}

sub broadcast
{
	my( $email, $message, %style ) = @_;
	
	my $hash = hash( $email );
	
	%style =
	(
		Font		=> uri_unescape( $style{Font} )
							|| $style_default{Font},
		Color		=> $style{Color} 	|| $style_default{Color},
		Effect		=> $style{Effect} 	|| $style_default{Effect},
		CharacterSet	=> $style{CharacterSet} || $style_default{CharacterSet},
		PitchFamily	=> $style{PitchFamily}	|| $style_default{PitchFamily},
		
		Name		=> exists $style{Name} ? $style{Name} : $style_default{Name}
	);
	
	
	if ( !$data{$hash}->{kotehan} && $email ne $handle )
	{
		%style = %style_default;
	}
	
	
	foreach my $Contact ( onlineList() )
	{
		my $hash = hash( $Contact->{Email} );
		
		next if( $Contact->{Email} eq $email );
		
		next if( $data{$hash}->{tpo} ne '' &&
				index( "$email $style{Name}", $data{$hash}->{tpo} ) != -1 );
		
		
		sendMessage( $Contact->{Email}, $message, %style );
	}
	
	writeLog( $email, $message, %style );
	
	print "MSG $hash\n";
	
	setTimeout( \&ping, 60 );
}

sub writeLog
{
	my( $email, $message, %style ) = @_;
	
	unshift( @logs, { Time => time(), Message => $message, Style => \%style } );
	@logs = @logs[ 0 .. $logs_max - 1 ];
}

sub changeTopic
{
	my( $topic ) = @_;
	
	$data{SYSTEM}->{topic} = $topic;
	
	my $uux = "<Data><PSM>$topic</PSM><CurrentMedia></CurrentMedia></Data>";
	$msn->{Notification}->sendraw( "UUX", length( $uux ). "\r\n$uux" );
}

sub quit
{
	writeData();
	
	exit;
}

sub forceQuit
{
	setTimeout( \&ping, 0 );
	setTimeout( \&updateName, 0 );
	
	$msn->setName( $botname );
	
	setTimeout( \&quit, 1 );
}

sub ping
{
	foreach my $convo ( values %{ $msn->getConvoList() } )
	{
		$convo->sendTyping();
	}
	
	setTimeout( \&ping, 60 );
	
	writeData();
	$motdtime = ( stat( $motdfile ) )[9];
}

sub updateName
{
	my $contacts_signin = 0;
	my $contacts_online = 0;
	
	foreach my $Contact ( onlineList() )
	{
		$contacts_signin++;
		$contacts_online++ if( $Contact->{Status} eq 'NLN' );
		
		$data{ hash( $Contact->{Email} ) }->{lastjoin} = time();
	}
	
	my $new_contacts = "$contacts_online/$contacts_signin";
	
	if ( $new_contacts != $contacts )
	{
		$contacts = $new_contacts;
		$msn->setName( "$botname $contacts" );
	}
	
	setTimeout( \&updateName, 10 );
}


sub setTimeout
{
	my( $function, $delay, @parameters ) = @_;
	
	if ( $delay > 0 )
	{
		$timeouts{ $function } =
		{
			time		=> time() + $delay,
			
			function	=> $function,
			parameters	=> @parameters
		};
	}
	else {
		delete $timeouts{$function};
	}
}

sub timeoutEvent
{
	foreach my $key ( keys %timeouts )
	{
		if ( $timeouts{$key}->{time} < time() )
		{
			my $function   = $timeouts{$key}->{function};
			my @parameters = $timeouts{$key}->{parameters};
			
			delete $timeouts{$key};
			
			&{ $function }( @parameters );
		}
	}
}

sub writeData
{
	if ( $save_log_to_datafile )
	{
		$data{LOG} = \@logs;
	}
	
	open( my $fh, ">$datafile"."_tmp" );
	print $fh Dumper( \%data ); close( $fh );
	
	unlink( $datafile );
	rename( $datafile."_tmp", $datafile );
}

sub hash
{
	our %cache; my $str = shift;
	return exists $cache{$str} ? $cache{$str} : $cache{$str} = md5_hex( $str );
}

sub date
{
	my @date = localtime( shift );
	
	return sprintf(
		"%04d/%02d/%02d %02d:%02d:%02d",
		$date[5] + 1900,
		$date[4] + 1,
		$date[3],
		$date[2],
		$date[1],
		$date[0],
	);
}
