#================================================
package MSN::Util;
#================================================

use strict;
use warnings;


my %errlist;

$errlist{200} = 'Invalid Syntax';
$errlist{201} = 'Invalid parameter';
$errlist{205} = 'Invalid user';
$errlist{206} = 'Domain name missing';
$errlist{207} = 'Already logged in';
$errlist{208} = 'Invalid User Name';
$errlist{209} = 'Invlaid Friendly Name';
$errlist{210} = 'List Full';
$errlist{213} = 'Invalid Rename Request';
$errlist{215} = 'User already on list';
$errlist{216} = 'User not on list';
$errlist{217} = 'User not online';
$errlist{218} = 'Already in that mode';
$errlist{219} = 'User is in the opposite list';
$errlist{223} = 'Too Many Groups';
$errlist{224} = 'Invalid Groups ';
$errlist{225} = 'User Not In Group';
$errlist{227} = 'Group is not Empty';
$errlist{228} = 'Group on Hotmail Already Exists';
$errlist{229} = 'Group Name too long';
$errlist{230} = 'Cannont Remove Group Zero';
$errlist{231} = 'Invalid Group';
$errlist{280} = 'Switchboard Failed';
$errlist{281} = 'Transfer to Switchboard failed';
$errlist{282} = 'P2P Error';

$errlist{300} = 'Required Field Missing';
$errlist{301} = 'Too Many Hits to FND';
$errlist{302} = 'Not Logged In';

$errlist{402} = 'Contact List Unavailable';
$errlist{403} = 'Error Accessing Contact List (Servers are experiencing problems)';
$errlist{420} = 'Bot is not a member of the Windows Live Messenger Beta';

$errlist{500} = 'Internal Server Error';
$errlist{501} = 'Database Server Error';
$errlist{502} = 'Command Disabled';
$errlist{510} = 'File Operation Failed';
$errlist{511} = 'User the bot tried to connect with is banned';
$errlist{520} = 'Memory Allocation Failed';
$errlist{540} = 'Challenge Response Failed';

$errlist{600} = 'Server Is Busy';
$errlist{601} = 'Server Is Unavailable';
$errlist{602} = 'Peer Name Server is Down';
$errlist{603} = 'Database Connection Failed';
$errlist{604} = 'Server Going Down';
$errlist{605} = 'Server Unavailable';

$errlist{700} = 'Could Not Create Connection';
$errlist{707} = 'Could Not Create Connection';
$errlist{710} = 'Bad CVR Parameter Sent';
$errlist{711} = 'Write is Blocking';
$errlist{712} = 'Session is Overloaded';
$errlist{713} = 'Calling blocked or offline user too rapidly';
$errlist{714} = 'Too Many Sessions';
$errlist{715} = 'Command Not Expected';
$errlist{717} = 'Bad Friend File';
$errlist{731} = 'Badly Formated CVR';

$errlist{800} = 'Display Name/Status Changed too Rapidly / Too many new conversations requested.';

$errlist{910} = 'Server Too Busy';
$errlist{911} = 'Authentication Failed. Invalid ticket';
$errlist{912} = 'Server Too Busy';
$errlist{913} = 'Not allowed While Hidden';
$errlist{914} = 'Server Not Available';
$errlist{915} = 'Server Not Available';
$errlist{916} = 'Server Not Available';
$errlist{917} = 'Authentication Failed';
$errlist{918} = 'Server Too Busy';
$errlist{919} = 'Server Too Busy';
$errlist{920} = 'Not Accepting New Users';
$errlist{921} = 'Server Too Busy: User Digest';
$errlist{922} = 'Server Too Busy';
$errlist{923} = 'Kids Passport Without Parental Consent';
$errlist{924} = 'Passport Account Not Verified';
$errlist{928} = 'Authenication Failed. Invalid ticket';


my %cidlist =
(
	Client		=> 0x0000000,
	
	WinMobile	=> 0x0000001,
	MSN8User	=> 0x0000002,
	ViewInk		=> 0x0000004,
	CreateInk	=> 0x0000008,
	
	Video		=> 0x0000010,
	MultiPacket	=> 0x0000020,
	MSNMobile	=> 0x0000040,
	MSNDirect	=> 0x0000080,
	
	Unknown_21	=> 0x0000100,
	WebClient	=> 0x0000200,
	Unknown_24	=> 0x0000400,
	TGWClient	=> 0x0000800,
	
	Space		=> 0x0001000,
	MediaCenterUser	=> 0x0002000,
	DirectMessage	=> 0x0004000,
	Winks		=> 0x0008000,

	SharedSearch	=> 0x0010000,
	Bot		=> 0x0020000,
	VoiceMessage	=> 0x0040000,
	SecureCannel	=> 0x0080000,
	
	SIP		=> 0x0100000,
	Unknown_52	=> 0x0200000,
	SharedDrive	=> 0x0400000,
	Unknown_54	=> 0x0800000,
	
	OneCare		=> 0x1000000,
	SupportsTurn	=> 0x2000000,
	ViaUNN		=> 0x4000000,
	Unknown_64	=> 0x2000000,
);


sub convertError
{
	my $err = shift;
	
	return ( $errlist{$err} || 'unknown error' );
}

sub convertFromCid
{
	my $cid = shift;

	my $info = {};
	
	if    ( $cid >= 0x70000000 )	{ $info->{Client} = 'MSNC7'; }
	elsif ( $cid >= 0x60000000 )	{ $info->{Client} = 'MSNC6'; }
	elsif ( $cid >= 0x50000000 )	{ $info->{Client} = 'MSNC5'; }
	elsif ( $cid >= 0x40000000 )	{ $info->{Client} = 'MSNC4'; }
	elsif ( $cid >= 0x30000000 )	{ $info->{Client} = 'MSNC3'; }
	elsif ( $cid >= 0x20000000 )	{ $info->{Client} = 'MSNC2'; }
	elsif ( $cid >= 0x10000000 )	{ $info->{Client} = 'MSNC1'; }
	else				{ $info->{Client} = 'Unknown'; }

	foreach ( keys %cidlist )
	{
		$info->{ $_ } = ( $cid & $cidlist{ $_ } ) ? 1 : 0;
	}
	
	return $info;
}

sub convertToCid
{
	my %info = @_;

	my $cid = 0;

	if    ( !defined $info{Client} )	{ $cid = 0x40000000; }
	
	elsif ( $info{Client} eq 'MSNC7' )	{ $cid = 0x70000000; }
	elsif ( $info{Client} eq 'MSNC6' )	{ $cid = 0x60000000; }
	elsif ( $info{Client} eq 'MSNC5' )	{ $cid = 0x50000000; }
	elsif ( $info{Client} eq 'MSNC4' )	{ $cid = 0x40000000; }
	elsif ( $info{Client} eq 'MSNC3' )	{ $cid = 0x30000000; }
	elsif ( $info{Client} eq 'MSNC2' )	{ $cid = 0x20000000; }
	elsif ( $info{Client} eq 'MSNC1' )	{ $cid = 0x10000000; }
	elsif ( $info{Client} eq 'MSNC0' )	{ $cid = 0x00000000; }
	
	else					{ $cid = 0x40000000; }

	foreach ( keys %info )
	{
		$cid += $cidlist{ $_ } if ( $info{ $_ } );
	}

	return $cid;
}


1;
