
our %MESSAGE = ();

$MESSAGE{INFO} = <<__EOT__;
こちらは あやしいわーるど＠MSN ですヽ(´ー｀)ノ

＠MSN は MSN Messenger を利用したチャットです。

あなたが送ったメッセージが ＠MSN に登録されている
サインイン中の全員に配信されるようになっています。
その際にメールアドレスは他の人には表示されません。

顔文字の横に表示されているのは現在の参加人数です。
参加者の名前は /names で表示することができます。

メッセージの配信を停止するには禁止をしてください。

詳細な説明については /help で読むことができます。
__EOT__


$MESSAGE{HELP} = <<__EOT__;
こちらは あやしいわーるど＠MSN ですヽ(´ー｀)ノ

＠MSN は MSN Messenger を利用したチャットです。

あなたが送ったメッセージが ＠MSN に登録されている
サインイン中の全員に配信されるようになっています。
その際にメールアドレスは他の人には表示されません。

顔文字の横に表示されているのは現在の参加人数です。
参加者の名前は /names で表示することができます。

メッセージの配信を停止するには禁止をしてください。

詳細な説明については /help で読むことができます。
__EOT__



sub cmd_topic
{
	my( $email, $data ) = @_;
	
	changeTopic( $data ) if( $data ne '' );
	sendMessage( $email, "現在のトピック：$data{SYSTEM}->{topic}", %style_system );
	
	return 1;
}

sub cmd_showname
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		$data{ hash( $email ) }->{fusiana} = 1;
		sendMessage( $email, "設定しました。", %style_system );
		
		return 1;
	}
}

sub cmd_hidename
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		$data{ hash( $email ) }->{fusiana} = 0;
		sendMessage( $email, "設定しました。", %style_system );
		
		return 1;
	}
}

sub cmd_mode
{
	my( $email, $data ) = @_;
	
	if ( $data eq '+a' )
	{
		$data{ hash( $email ) }->{kotehan} = 0;
		sendMessage( $email, "設定しました。", %style_system );
		
		return 1;
	}
	
	if ( $data eq '-a' )
	{
		$data{ hash( $email ) }->{kotehan} = 1;
		sendMessage( $email, "設定しました。", %style_system );
		
		return 1;
	}
}

sub cmd_tpo
{
	my( $email, $data ) = @_;
	
	$data{ hash( $email ) }->{tpo} = $data;
	sendMessage( $email, "設定しました。", %style_system );
	
	return 1;
}

sub cmd_away
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		$data{ hash( $email ) }->{away} = 1;
		sendMessage( $email, "設定しました。", %style_system );
		
		return 1;
	}
}

sub cmd_part
{
	return cmd_away( @_ );
}


sub cmd_join
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		$data{ hash( $email ) }->{away} = 0;
		sendMessage( $email, "設定しました。", %style_system );
		
		return 1;
	}
}

sub cmd_admin
{
	my( $email, $data ) = @_;
	
	if ( $data ne '' )
	{
		open( my $fh, ">>$adminfile" );
		print $fh date( time() )." $data\n"; close( $fh );
		
		sendMessage( $email, "ありがとうございました。", %style_system );
		
		return 1;
	}
	else {
		my %code = 
		(
			NLN => "オンライン",
			FLN => "オフライン",
			HDN => "オフライン",
			BSY => "取り込み中",
			IDL => "退席中",
			AWY => "退席中",
			BRB => "一時退席中",
			PHN => "電話中",
			LUN => "昼休み"
		);
		
		my $status = $code{ $msn->getContactStatus( $admin ) || "FLN" };
		sendMessage( $email, "管理人のステータス : $status", %style_system );
		
		return 1;
	}
}

sub cmd_invite
{
	my( $email, $data ) = @_;
	
	my $message = "$email さんがあなたを あやしいわーるど＠MSN に招待しました。\n".
		      "参加される場合は $msn->{Handle} をあなたのメンバリストに登録してください。";
	
	if ( $data =~ /^\S+\@\S+\.\S+$/ )
	{
		sendMessage( $data, $message, %style_system );
		return 1;
	}
}

sub cmd_info
{
	my( $email, $data ) = @_;
	
	chomp( $MESSAGE{INFO} );
	
	if ( $data eq '' )
	{
		sendMessage( $email, $MESSAGE{INFO}, %style_system );
		return 1;
	}
}

sub cmd_help
{
	my( $email, $data ) = @_;
	
	my $hash = hash( $email );
	
	my $message = $MESSAGE{HELP};

	$message .= "　送信者表示 : ". ( $data{$hash}->{fusiana} ? "ON"   : "OFF"  ). "　";
	$message .= "　匿名モード : ". ( $data{$hash}->{kotehan} ? "固定" : "空白" ). "\n";
	
	$message .= "　禁止ワード : $data{$hash}->{tpo}" if( $data{$hash}->{tpo} ne '' );
	
	chomp( $message );
	
	if ( $data eq '' )
	{
		sendMessage( $email, $message, %style_system );
		return 1;
	}
}

sub cmd_stat
{
	my( $email, $data ) = @_;
	
	my $hash = hash( $email );
	
	
	my $population = 0;
	
	foreach my $handle ( $msn->getContactList( 'FL' ) )
	{
		$population++ if( $data{ hash( $handle ) }->{lastjoin} > time - $pop_count );
	}
	
	my $message = "";
	
	$message .= "前回起動 : ". ( date( $data{SYSTEM}->{lastboot} ) ). "\n";
	$message .= "今回起動 : ". ( date( $data{SYSTEM}->{boottime} ) ). "\n";
	$message .= "連続稼動 : ". ( time() - $data{SYSTEM}->{boottime} ). "秒\n";
	$message .= "投稿回数 : ". ( $data{SYSTEM}->{count} ). "回\n";
	$message .= "総住人数 : ". ( $population ). "人\n";
	
	chomp( $message );
	
	if ( $data eq '' )
	{
		sendMessage( $email, $message, %style_system );
		return 1;
	}
}

sub cmd_stats
{
	return cmd_stat( @_ );
}

sub cmd_motd
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		$data{ hash( $email ) }->{lastmotd} = time();
		
		open( my $fh, "$motdfile" );
		read( $fh, my $message, ( stat( $motdfile ) )[7] ); close( $fh );
		
		sendMessage( $email, $message, %style_system );
		return 1;
	}
}

sub cmd_names
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		my $message = ''; my $anonymous = 0;
		
		foreach my $Contact ( onlineList() )
		{
			unless ( $data{ hash( $Contact->{Email} ) }->{kotehan} )
			{
				$anonymous++;
			}
			else {
				$message .= uri_unescape( $Contact->{Friendly} ). "　";
			}
		}
		
		$message .= "空白$anonymous人" if ( $anonymous > 0 );
		
		
		sendMessage( $email, $message, %style_system );
		return 1;
	}
}

sub cmd_member
{
	return cmd_names( @_ );
}

sub cmd_members
{
	return cmd_names( @_ );
}

sub cmd_log
{
	my( $email, $data ) = @_;
	
	my $hash = hash( $email );
	
	my $lognum = $data{$hash}->{lognum} || 5;
	
	if ( $data eq "" && $data{$hash}->{lastlogt} > time() - 180 )
	{
		$data = $data{$hash}->{lastlogn} + $lognum;
	}
	
	$data = 0 if ( ! defined $logs[$data] );
	
	for ( my $i = $data; $i < $data + $lognum; $i++ )
	{
		if( ! defined $logs[$i] )
		{
			sendMessage( $email, "これ以上はありません。", %style_system );
			last;
		}
		
		sendMessage
		(
			$email,
			date( $logs[$i]->{Time} ). " ". $logs[$i]->{Style}->{Name}. "\n". $logs[$i]->{Message},
			( %{ $logs[$i]->{Style} }, Name => sprintf( "log %03d", $i ) )
		);
	}
	
	$data{$hash}->{lastlogn} = $data;
	$data{$hash}->{lastlogt} = time();
	
	return 1;
}

sub cmd_l
{
	return cmd_log( @_ );
}

sub cmd_lognum
{
	my( $email, $data ) = @_;
	
	my $hash = hash( $email );
	
	if ( $data > 0 && $data <= 20 )
	{
		$data{$hash}->{lognum} = $data;
		
		sendMessage( $email, "設定しました。", %style_system );
		
		return 1;
	}
	else
	{
		sendMessage( $email, "値は 1 ～ 20 でなければなりません。", %style_system );
		
		return 0;
	}
}

sub cmd_count
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		sendMessage( $email, "あなたの投稿回数 - ". int( $data{ hash( $email ) }->{count} ). "回", %style_system );
		return 1;
	}
}

sub cmd_karma
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		sendMessage( $email, "あなたのカルマ - ". int( $data{ hash( $email ) }->{karma} ), %style_system );
		return 1;
	}
}

sub cmd_ping
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		sendMessage( $email, "/pong", %style_system );
		return 1;
	}
}

sub cmd_time
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		sendMessage( $email, date( time() ), %style_system );
		return 1;
	}
}

sub cmd_version
{
	my( $email, $data ) = @_;
	
	if ( $data eq '' )
	{
		sendMessage( $email, "$version\n$MSN::VERSION", %style_system );
		return 1;
	}
}


sub cmd_limit
{
	my( $email, $data ) = @_;
	
	if ( $email eq $admin )
	{
		if ( $data =~ /^(\w+)\s+(\d+)$/ )
		{
			if ( exists $data{$1} )
			{
				$data{$1}->{limit} = int( $2 );
				sendMessage( $email, "設定しました。", %style_system );
			}
			else {
				sendMessage( $email, "存在しません。", %style_system );
			}
		}
		else {
			sendMessage( $email, "コマンドが不正です。", %style_system );
		}
		
		return 1;
	}
}

sub cmd_quit
{
	my( $email, $data ) = @_;
	
	if ( $email eq $admin )
	{
		setTimeout( \&quit, 5 );
		
		setTimeout( \&ping, 0 );
		setTimeout( \&updateName, 0 );
		
		$msn->setName( $botname );
		
		broadcast( $msn->{Handle}, $data || "再起動します。", %style_system );
		
		writeData();
		
		return 1;
	}
}

sub cmd_debug
{
	my( $email, $data ) = @_;
	
	if ( $email eq $admin )
	{
		writeData();
		
		open( my $fh, ">debug.txt" );
		print $fh Dumper( \$msn ); close( $fh );
		
		return 1;
	}
}

1;
