use lib "./lib";

use MSN;


## MODIFY THESE FOR YOUR BOT ##
my $handle = 'bot@domain.com';
my $password = 'password';
my $admin = 'admin@domain.com';


# create an MSN object showing all server errors and other errors
my $msn = new MSN( 'Handle' => $handle, 'Password' => $password );

# OR create an MSN object with all error messages turned off
#my $msn = new MSN( 'Handle' => $handle, 'Password' => $password, 'ServerError' => 0, 'Error' => 0 );

# OR create an MSN object with full debugging info
#my $msn = new MSN( 'Handle' => $handle, 'Password' => $password, 'AutoloadError' => 1, 'Debug' => 1, 'ShowTX' => 1, 'ShowRX' => 1 );

# example of setting client info
$msn->setClientInfo( 'Client' => 'MSNC2' );

# example of setting client capabilites (caps)
$msn->setClientCaps( 'Client-Name' => 'MSN Bot/1.0', 'Chat-Logging' => 'Y', 'Client-Template' => 'None' );

# example of setting the default message style and P4 name
$msn->setMessageStyle( 'Effect' => 'BI', 'Color' => 'FF0000', 'Name' => 'MSN Bot' );


# set handlers
$msn->setHandler( 'Connected' => \&Connected );
$msn->setHandler( 'Message' => \&Message );


# connect to the server
$msn->connect();


# run the bot
my $run = 1;
while( $run )
{
	$msn->do_one_loop();
}


################################################
# handlers
################################################

sub Connected
{
	my $self = shift;

	print( "Connected\n" );

   # example of a call with style and P4 name
	$msn->call( $admin, "I am connected!", 'Effect' => 'BI', 'Color' => '00FF00', 'Name' => 'Your Bot' );
}

sub Message
{
	my( $self, $username, $name, $message, %style ) = @_;

	if( $message =~ /^!exit$/i )     				# exits the bot
	{
		$msn->disconnect( );
		$run = 0;
	}
	elsif( $message =~ /^!broadcast\s+(.*)$/i )  # sends a broadcast message
	{
		# example of a broadcast with style and P4 name
		$reply = $msn->broadcast( $1, 'Effect' => 'BI', 'Color' => '0000FF', 'Name' => 'Broadcaster' );
	}
	else                                         # repeats what the user said
	{
		$self->sendMessage( $message, %style );
	}
}
