#!ruby -Ku
#Windowsのプロンプトの場合は、rbファイルをSJISに変換した上で、上のオプションを「-Ks」にしてください。
require 'openssl'

@item_names = [] # アカウント情報を一意に決めるための内部名
@print_names = [] # 表示名
@get_functions = [] # 読み出した口座情報関数取得用の配列
@make_account = [] # アカウント情報登録のための関数の配列
@login_functions = [] # ログインのみの機能も実装するかもしれないので、分けて取得。
@format_functions = [] # 書式を整える関数（オプション）取得用の配列

require 'lib_a_require' # 自作ライブラリ（口座情報、暗号復号 with openssl）読み出し。

puts "マスターパスワードを入力してください。"
case RUBY_PLATFORM.downcase
when /mswin(?!ce)|mingw|cygwin|bccwin/
  @osname = "windows"
when /linux/
  @osname ="linux"
end

key = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
key = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。


# 登録されているかどうかのフラグを設定
flags = Array.new(@item_names.length, false)

account_info = Array.new(@item_names.length, false) # ログインアカウント保存用配列

if File.exist?("account_passwd")
  enc_passes = []
  dec_passes = []
  enc_passes = open("account_passwd", "rb"){ |f| f.read }
  begin
    dec_passes = enc_passes.decrypt(key).split("\n")
  rescue
    STDERR.puts "パスワードが違います！ パスワードファイルを解読できません。" if $!.to_s == 'bad decrypt'
    exit
  end
  dec_passes.map! {|l| l.split(",")}

  # 登録されている関数のアカウント情報があるかどうか順番に見ていく。
  # あったら、それを見つけた順に格納。

  @item_names.each_with_index do |x, i|
    dec_passes.each do |y|
      if y[0] == x
        flags[i] = true
        account_info[i] = y
      end
    end
  end

end


# 登録（関数とアカウント情報の両方）されているアカウントを順番に表示
@print_names.each_with_index do |x,i|
  print i.to_s + "." + x + " "
  print "\n"
end
puts "x.マスターパスワード変更"

select_no = gets.chomp

case select_no
when /\d+/
  if flags[select_no.to_i] == true
    puts @print_names[select_no.to_i] + "のアカウント情報はすでに登録されています。"
    puts "書き換えますか？ y or n"
    select_rw = gets.chomp
    exit if select_rw != "y"
  end
  if @make_account[select_no.to_i] == false
    account_info[select_no.to_i] = make_account_default(select_no.to_i)
  else
    make_an_account = @make_account[select_no.to_i] + "(" + select_no + ")"
    account_info[select_no.to_i] = instance_eval make_an_account
  end
  flags[select_no.to_i] = true

when "x"
  puts "マスターパスワードを変更します。"
  puts "新しいマスターパスワードを入力してください。"
  if @osname == "linux"
    key = `stty -echo;read line;stty echo; echo $line`.chomp
    puts "確認のため、もう一度新しいマスターパスワードを入力してください。"
    if key != `stty -echo;read line;stty echo; echo $line`.chomp
      puts "入力されたものが一致しません。"
      puts "確認のため、もう一度新しいマスターパスワードを入力してください。"
      if key != `stty -echo;read line;stty echo; echo $line`.chomp
        puts "入力されたものが一致しません。"
        puts "マスターパスワードは変更されませんでした。スクリプトを終了します。"
        exit
      end
    end

  elsif @osname == "windows"
    key = gets.chomp # Windowsの場合はキー入力を隠さない。
    puts "確認のため、もう一度新しいマスターパスワードを入力してください。"
    if key != gets.chomp # Windowsの場合はキー入力を隠さない。
      puts "入力されたものが一致しません。"
      puts "確認のため、もう一度新しいマスターパスワードを入力してください。"
      if key != gets.chomp # Windowsの場合はキー入力を隠さない。
        puts "入力されたものが一致しません。"
        puts "マスターパスワードは変更されませんでした。スクリプトを終了します。"
        exit
      end
    end
  end
  puts "マスターパスワードが変更されました。"
   
else
  puts "有効な値ではありません。スクリプトを終了します。"
  exit
end


# カンマや行区切りごとに暗号化すると、復号化できなくなるので、まとめて一気に暗号化
raw = "" # これに全部詰め込む

account_info.each_with_index do |x,i|
  next if flags[i] == false
  x.each_with_index do |y,j|
    raw = raw + y
    next if j == x.length - 1
    raw = raw + ","
  end
  raw = raw + "\n"
end

# ファイル書き込み
open("account_passwd", "w") do |f|
  f.write raw.encrypt(key)
  puts "登録されました。"
end

