#!ruby -Ku
# get_a_info.rb用のライブラリ

# クラス定義追加
# Stringクラスにopensslを使った暗号・複号のメソッドを追加
require 'openssl'
class String
  CIPHER_ALGORITHM = "aes-256-cbc"
  def encrypt(password)
    enc = OpenSSL::Cipher::Cipher.new(CIPHER_ALGORITHM)
    enc.encrypt
    enc.pkcs5_keyivgen(password)
    enc.update(self) + enc.final
  end
  def decrypt(password)
    dec = OpenSSL::Cipher::Cipher.new(CIPHER_ALGORITHM)
    dec.decrypt
    dec.pkcs5_keyivgen(password)
    dec.update(self) + dec.final
  end
end

# Arrayクラスに2次元配列を表示させるためのメソッドを追加
class Array
  def print_table
    self.each do |x|
      x.each_with_index do |y, j|
        print y
        next if j == x.length - 1
        print "\t"
      end
      print "\n"
    end
  end
end

# HTMLのテーブルを疑似2次元配列に変換する関数を定義
def store_table(t) # 引数はffオブジェクトのテーブルを想定
  table_array \
    = Array.new(t.row_count){ Array.new(t.column_count) }
  i = 0 # tableオブジェクトにeach_with_indexが実装されていないので。
  t.each do |x|
    j = 0
    x.each do |y|
      table_array[i][j] = y.text
      j += 1
    end
    i += 1
  end
  return table_array
end

# アカウント情報登録関数が登録されていない場合に呼び出す関数
def make_account_default(index)
  an_account_info = []
  puts "【注意】専用のアカウント登録関数がない口座情報を入力する場合は、入力すべきデータ数もわからないため、ここで入力データ数も入力します。"
  puts "最後に入力する値はパスワードの可能性が高いので、その時だけ、入力内容が画面に表示されなくなります。(linuxのみ）"
  print "\n"
  
  puts "このアカウントにログインする際に入力が必要なデータの数を入力してください。"
  input_number = gets.chomp
  if input_number =~ /\d+/
    input_number = input_number.to_i
  else
    puts "数値ではない値が入力されています！ スクリプトを終了します。"
    exit
  end
  0.upto(input_number) do |i|
    if i == 0
      an_account_info[i] = @item_names[index]
    elsif i == input_number
      puts "最後の値を入力してください。（キー入力は画面には表示されません）" if @osname == "linux"
      puts "最後の値を入力してください。" if @osname == "windows"
      an_account_info[i] = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
      an_account_info[i] = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。
    else
      puts i.to_s + "つ目の値をを入力してください。"
      an_account_info[i] = gets.chomp
    end
  end
return an_account_info
end
