# get_a_info.rb用のライブラリ
# 清書関数
=begin
・仕様
○金融機関口座
############################################
・照会口座
・預金残高
・明細
照会期間
日付、摘要、引出し額、預入れ額、残高
############################################

○クレカ
############################################
・口座情報
カード名
請求先口座
支払日
請求額

・次回支払い額
日付、利用店名・商品名等、支払い区分、請求額

・未確定分
日付、利用店名・商品名等、支払い区分、請求額
（利用額合計）
############################################
=end

def formatUFJ(outputs, index)
  kugiri = "◆" + @print_names[index]
  kouza = "照会口座\t" + outputs[2][1][0] + " " + outputs[2][1][1] + " " + outputs[2][1][2]
  zandaka = "残高\t" + outputs[2][1][3]
  meisai_title = "▼明細\t照会期間 " + outputs[3][1][1]
  meisai_header = "日付\t" + "摘要\t" + "引出し金額\t" + "預入れ金額\t" + "差引残高"
  
  puts kugiri
  puts kouza
  puts zandaka
  puts meisai_title

  puts meisai_header
  outputs[4].each_with_index do |x,i|
    next if i == 0
    print x[0] + "\t"
    print x[1] + x[2] + "\t"
    print x[3].chop.chop.chop + "\t"
    print x[4].chop.chop.chop + "\t"
    print x[5].chop.chop.chop + "\n"
  end
end

def formatJP(outputs, index)
  kugiri = "◆" + @print_names[index]
  kouza = "照会口座\t" + outputs[2][0].split(" ")[11]
  zandaka = "残高\t" + outputs[1][0][1]
  meisai_title = "▼明細\t照会期間 " + outputs[2][0].split(" ")[13].slice(15..20) + outputs[2][0].split(" ")[14..27].join
  meisai_header = "日付\t" + "摘要\t" + "引出し金額\t" + "預入れ金額\t" + "差引残高"
  
  puts kugiri
  puts kouza
  puts zandaka
  puts meisai_title
  puts meisai_header
  outputs[3].each_with_index do |x,i|
    next if i == 0
    print x[0] + "\t"
    print x[3] + "\t"
    print x[1].chop.chop.chop + "\t"
    print x[2].chop.chop.chop + "\t"
    print x[4].chop.chop.chop + "\n"
  end
end

def formatMitsui(outputs, index)
  kugiri = "◆" + @print_names[index]
  kouza = "照会口座\t" + outputs[1][0][1]
  zandaka = "残高\t" + outputs[1][1][1]
  meisai_title = "▼明細\t照会期間 " + outputs[2][0].split(" ")[0..6].join
  meisai_header = "日付\t" + "摘要\t" + "引出し金額\t" + "預入れ金額\t" + "差引残高"
  
  puts kugiri
  puts kouza
  puts zandaka
  puts meisai_title
  puts meisai_header
  outputs[3].each_with_index do |x,i|
    next if i == 0 || i == outputs[3].length - 1
    print x[0] + "\t"
    print x[3] + "\t"
    print x[1].chop.chop.chop + "\t"
    print x[2].chop.chop.chop + "\t"
    print x[4].chop.chop.chop + "\n"
  end
end

def formatView(outputs, index)
  kugiri = "◆" + @print_names[index]
  card = "カード\t" + outputs[1][1][1]
  kouza = "引落口座\t" + outputs[1][3][1]
  day = "支払日\t" + outputs[1][8][1]
  gaku = "次回支払い金額\t" + outputs[1][9][1]
  
  meisai_header = "日付\t" + "摘要\t" + "支払い区分\t" + "請求額"
  
  puts kugiri
  puts card
  puts kouza
  puts day
  puts gaku

  puts meisai_header
  outputs[4].each_with_index do |x,i|
    print x[0] + "\t"
    print x[1] + "\t"
    print x[2] + "\t"
    print x[3] + "\n"
  end

  outputs[5].print_table
  puts meisai_header
  outputs[6].each_with_index do |x,i|
    next if i == 0
    print x[0] + "\t"
    print x[1].split(" ")[1] + "\t"
    print x[3] + "\t"
    print x[2].split("(")[0] + "\n"
  end 
end

def formatRakuten(outputs, index)
  kugiri = "◆" + @print_names[index]
  card = "カード\t" + outputs[1][0][1]
  kouza = "引落口座\t" + outputs[1][2][1]
  day = "支払日\t" + outputs[1][1][1]
  gaku = "次回支払い金額\t" + outputs[1][5][1]
  
  meisai_header = "日付\t" + "摘要\t" + "支払い区分\t" + "請求額"
  
  puts kugiri
  puts card
  puts kouza
  puts day
  puts gaku

  puts "▼利用明細"
  puts meisai_header
  outputs[3].each_with_index do |x,i|
    next if i == 0 || i == outputs[3].length - 1
    print x[0] + "\t" # 日付
    print x[1] + "\t"
    print x[3] + "\t"
    print x[6] + "\n"
  end
  puts "次回リボ払い分\t" + outputs[5][1][0] + "\t" + "\t" + outputs[5][1][7]
  puts "次回リボ払い分\t" + outputs[5][2][0] + "\t" + "\t" + outputs[5][2][7]

  puts "▼楽天カード次々回以降支払い額"
  puts meisai_header
  outputs[7].each_with_index do |x,i|
    next if i == 0
    if i == outputs[7].length - 1
      puts "\t\t" + x[0] + "\t" + x[1]
      next
    end
    print x[0] + "\t" # 日付
    print x[1] + "\t"
    print x[2] + "\t"
    print x[3] + "\n"
  end
end
def formatSaison(outputs, index)
  kugiri = "◆" + @print_names[index]
  card = "カード\t" + outputs[2][0][1]
  kouza = "引落口座\t" + outputs[2][0][3]
  day = "支払日\t" + outputs[1][0].split(" ")[2]
  gaku = "次回支払い金額\t" + outputs[3][1][3]
  
  meisai_header = "日付\t" + "摘要\t" + "支払い区分\t" + "請求額"
  
  puts kugiri
  puts card
  puts kouza
  puts day
  puts gaku

  puts "▼利用明細"
  puts meisai_header
  outputs[5].each_with_index do |x,i|
    print x[0] + "\t" # 日付
    print x[1] + "\t"
    print x[3] + "\t"
    print x[4].chop.chop.chop + "\n"
 end

  puts "▼セゾンカード次々回以降支払い額"
  puts meisai_header
  outputs[9].each_with_index do |x,i|
    next if i == 0
    print x[0] + "\t" # 日付
    print x[1] + "\t"
    print x[3] + "\t"
    print x[5].chop.chop.chop + "\n"
  end
end
