#!ruby -Ku
# get_a_info用のライブラリ（ダミー）
# ライブラリを追加した場合のイメージをつかむためのダミーです。
# 名前以外は、UFJ口座取得の内容そのままですが。。。
# ほかの口座に対応したい場合は、こんな感じで追加ライブラリをつくってください。
# ライブラリのファイルをget_a_info.rbと同じディレクトリに配置して、
# lib_a_requireの最後に「require '追加ライブラリ名（.rbなしのファイル名）'」と
# 書き加えておけば、get_a_info、makepasswdfileを実行した際の選択肢一覧に表示されるはずです。

@item_names << "Dummy" # アカウント情報を一意に決めるための内部名
@print_names << "ダミー" # 選択画面に表示する名前
@get_functions << "get_dummy" # 口座情報取得関数を()なしで指定。

# ここ以下がオプション。

# アカウント情報登録のための関数の配列。
# ここがfalseのままだとデフォルトの登録用関数が呼ばれる。
# デフォルトの関数は、lib_a_methodsのmake_account_defaultです。
@make_account << false
@login_functions << "login_dummy" # ログインのみを指定した時に呼び出させる関数。
@format_functions << false # 書式を整える関数取得用の配列（未実装の場合はfalseを入れてください。）

# 関数のサンプル（UFJ口座用と同じ内容）
def login_dummy(ff,account_info)
  ff.goto("https://entry11.bk.mufg.jp/ibg/dfw/APLIN/loginib/login?_TRANID=AA000_001")
  ff.text_field(:name, "KEIYAKU_NO").value = account_info[1]
  ff.text_field(:name, "PASSWORD").value = account_info[2]
  ff.button(:type, "button").click
  ff.link(:onClick, /AD001_002/).click
end

def get_dummy(ff,account_info)
  loginUFJ(ff,account_info)
  out = []
  out << ['◆UFJ口座']
  ff.radio(:name, "KIKAN_RADIO").click
  ff.button(:class, "button carryOut").click

  1.upto(4) do |i|
    out << store_table(ff.table(:index, i))
  end
  ff.link(:onClick, /logout/).click # ログアウト
  print "\n"

  return out # 取得した情報を疑似3次元配列で返す。
end

# 口座登録用関数のサンプルは、lib_a_defaultを見てください。
# とくにつくらなくても、汎用のデフォルト関数が使えます。

def format_dummy(outputs, index) # 使っていないが、サンプルとして登録。
  kugiri = "◆" + @print_names[index]
  kouza = "照会口座\t" + outputs[2][1][0] + " " + outputs[2][1][1] + " " + outputs[2][1][2]
  zandaka = "残高\t" + outputs[2][1][3]
  meisai_title = "▼明細\t照会期間 " + outputs[3][1][1]
  meisai_header = "日付\t" + "摘要\t" + "引出し金額\t" + "預入れ金額\t" + "差引残高"
  
  puts kugiri
  puts kouza
  puts zandaka
  puts meisai_title

  puts meisai_header
  outputs[4].each_with_index do |x,i|
    next if i == 0
    print x[0] + "\t"
    print x[1] + x[2] + "\t"
    print x[3] + "\t"
    print x[4] + "\t"
    print x[5] + "\n"
  end
end
