
#!ruby -Ku
# get_a_info.rb用のライブラリ

# 関数情報をインスタンス変数の配列に登録。配列はget_a_info.rb（makepasswdfile.rb）で宣言されている。
# ここではデフォルトとして6つの関数情報を登録している。
@item_names << "UFJ" # アカウント情報を一意に決めるための内部名
@print_names << "東京三菱UFJダイレクト" # 選択画面に表示する名前
@get_functions << "getUFJ" # 口座情報取得関数を()なしで指定。
# ここからオプション。
@make_account << "make_accountUFJ" # アカウント情報登録のための関数の配列
@login_functions << "loginUFJ" # ログインのみのときに呼び出される関数の配列
@format_functions << "formatUFJ" # 書式を整える関数の配列

@item_names << "JP"
@print_names << "ゆうちょダイレクト"
@get_functions << "getJP"
@make_account << "make_accountJP"
@login_functions << "loginJP"
@format_functions << "formatJP"

@item_names << "Mitsui"
@print_names << "三井住友(SMBC)ダイレクト"
@get_functions << "getMitsui"
@make_account << "make_accountMitsui"
@login_functions << "loginMitsui"
@format_functions << "formatMitsui"

@item_names << "View"
@print_names << "Viewカード"
@get_functions << "getView"
@make_account << "make_accountView"
@login_functions << "loginView"
@format_functions << "formatView"

@item_names << "Rakuten"
@print_names << "楽天カード"
@get_functions << "getRakuten"
@make_account << "make_accountRakuten"
@login_functions << "loginRakuten"
@format_functions << "formatRakuten"

@item_names << "Saison"
@print_names << "セゾンカード"
@get_functions << "getSaison"
@make_account << "make_accountSaison"
@login_functions << "loginSaison"
@format_functions << "formatSaison"


# デフォルトとしてUFJ、ゆうちょ、三井住友、Viewカード、楽天カード、セゾンカード用の関数を登録
#　長くなったので、書式を整えるための関数は、別のライブラリに記述した。そのライブラリを読み込み。
require 'lib_a_format'

# UFJ DIRECT
def loginUFJ(ff,account_info)
  ff.goto("https://entry11.bk.mufg.jp/ibg/dfw/APLIN/loginib/login?_TRANID=AA000_001")
  ff.text_field(:name, "KEIYAKU_NO").value = account_info[1]
  ff.text_field(:name, "PASSWORD").value = account_info[2]
  ff.button(:type, "button").click
end

def getUFJ(ff,account_info)
  loginUFJ(ff,account_info)
  ff.link(:onClick, /AD001_002/).click
  out = [] # 格納するのは配列でないといけない。あとでprint_tableするため。
  out << ['◆UFJ口座']
  ff.radio(:name, "KIKAN_RADIO").click
  ff.button(:class, "button carryOut").click
  1.upto(4) do |i|
    out << store_table(ff.table(:index, i)) # lib_a_methodsで定義している自作関数、配列にテーブルを格納。
  end
  ff.link(:onClick, /logout/).click # ログアウト
  return out
end

def make_accountUFJ(index)
  an_account_info = []
  an_account_info[0] = @item_names[index] # "UFJ"
  puts "UFJのご契約番号を入力してください。"
  an_account_info[1] = gets.chomp

  puts "UFJのパスワードを入力してください。"
  an_account_info[2] = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
  an_account_info[2] = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。

  return an_account_info
end


# ゆうちょ
def loginJP(ff,account_info)
  ff.goto("https://direct.jp-bank.japanpost.jp/tp1web/U010101SCK.do")
  ff.text_field(:name, "okyakusamaBangou1").value = account_info[1]
  ff.text_field(:name, "okyakusamaBangou2").value = account_info[2]
  ff.text_field(:name, "okyakusamaBangou3").value = account_info[3]
  ff.text_field(:name, "loginPassword").value = account_info[4]
  ff.button(:name, "U010103").click
end

def getJP(ff,account_info)
  loginJP(ff,account_info)
  ff.link(:onClick, /.*U070101BLC.*/).click
  ff.radio(:index, 2).click
  ff.button(:name, "U070102").click
  out = [] # 格納するのは配列でないといけない。あとでprint_tableするため。
  out << ['◆ゆうちょ口座']
  out << store_table(ff.table(:index, 1)) # 残高

  out << [ff.p(:class, "infotxt").text]
  out << store_table(ff.table(:index, 2)) # 明細
  
  ff.back # 通常のログアウトだと、プロンプトが表示されてしまう。「戻る」を使うと強制ログアウトなのを利用。
  ff.button(:onClick, /LoadHomepage/).click

  return out
end

def make_accountJP(index)
  an_account_info = []
  an_account_info[0] = @item_names[index] # "JP"
  puts "ゆうちょダイレクトのお客様番号をハイフンで分割して入力してください。（1/3）"
  an_account_info[1] = gets.chomp
  puts "ゆうちょダイレクトのお客様番号をハイフンで分割して入力してください。（2/3）"
  an_account_info[2] = gets.chomp
  puts "ゆうちょダイレクトのお客様番号をハイフンで分割して入力してください。（3/3）"
  an_account_info[3] = gets.chomp
  puts "ゆうちょダイレクトのパスワードを入力してください。"
  an_account_info[4] = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
  an_account_info[4] = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。
  return an_account_info
end

# 三井住友
def loginMitsui(ff,account_info)
  ff.goto("https://direct.smbc.co.jp/aib/aibgsjsw5001.jsp")
  ff.text_field(:name, "USRID1").value = account_info[1]
  ff.text_field(:name, "USRID2").value = account_info[2]
  ff.text_field(:name, "PASSWORD").value = account_info[3]
  ff.button(:name, "bLogon.y").click
end

def getMitsui(ff,account_info)
  loginMitsui(ff,account_info)
  ff.link(:href, /.*RYUDO_ACCNT_IDX=0/).click
  out = [] # 格納するのは配列でないといけない。あとでprint_tableするため。
  out << ['◆三井住友口座']
  out << store_table(ff.table(:index, 1))

  out << [ff.h2(:index, 1).text] # 入出金明細のタイトル
  out << store_table(ff.table(:index, 2))
  
  ff.link(:href, /.*imgLogoff\.y/).click

  return out
end

def make_accountMitsui(index)
  an_account_info = []
  an_account_info[0] = @item_names[index] # "Mitsui"
  puts "SMBCダイレクトの契約者番号をハイフンで分割して入力してください。（1/2）"
  an_account_info[1] = gets.chomp
  puts "SMBCダイレクトの契約者番号をハイフンで分割して入力してください。（2/2）"
  an_account_info[2] = gets.chomp

  puts "SMBCダイレクトのパスワードを入力してください。"
  an_account_info[3] = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
  an_account_info[3] = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。

  return an_account_info
end

# Viewカード
def loginView(ff,account_info)
  ff.goto("https://viewsnet.jp/default.htm")
  ff.text_field(:name, "id").value = account_info[1]
  ff.text_field(:name, "pass").value = account_info[2]
  ff.button(:type, "image").click
end

def getView(ff,account_info)
  loginView(ff,account_info)
  ff.link(:href, /Pid=V0300_001/).click
#　確定後データ
  ff.link(:id, "HlAfter").click
  ff.button(:id, "BtnList").click
  out = [] # 格納するのは配列でないといけない。あとでprint_tableするため。
  out << ['◆Viewカード支払い次回支払い額'] # 試験的
  out << store_table(ff.table(:index, 14))

# 詳細画面
  ff.link(:id,"HlDetail").click
  temp = [];temp2 = [] # 表が特殊なので、処理した上で表示させる。
  temp << store_table(ff.table(:index,14))
  out << ["▼利用明細"]
  out << ["日付\t利用店名・商品名等\t支払い区分\t請求額"]
  3.step(16,2) do |i|
    temp2 <<  [temp[0][i][0],temp[0][i][2],temp[0][i][5],temp[0][i][6]]
  end
  out << temp2
  
  ff.link(:id,"HlBack").click

# 元画面に戻る。（なぜか2回戻らないと戻れない）
  ff.link(:href, /Pid=V0300_001/).click


# 確定前データ
  out << ['◆Viewカード次々回以降支払い額'] # 試験的
  ff.link(:id, "HlPre").click
  ff.button(:id, "BtnList").click

  out << store_table(ff.table(:index, 15))
  out.last.delete_at(1) # 余計な項目があるので、1,2を消す。
  out.last.delete_at(1)
  out << store_table(ff.table(:index, 16)) # 合計額

# ログアウト
  ff.link(:href, /V0100_002.aspx/).click
  ff.button(:id, "Logout").click

  return out
end

def make_accountView(index)
  an_account_info = []
  an_account_info[0] = @item_names[index] # "View"
  puts "ViewカードのサービスIDを入力してください。"
  an_account_info[1] = gets.chomp

  puts "Viewカードのパスワードを入力してください。"
  an_account_info[2] = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
  an_account_info[2] = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。

  return an_account_info
end


# 楽天カード
def loginRakuten(ff,account_info)
  ff.goto("https://e-navi.rakuten-kc.co.jp/login/show")
  sleep 2 # ページの読み込みに時間がかかってエラーが出るため。
  ff.text_field(:name, "u").value = account_info[1]
  ff.text_field(:name, "p").value = account_info[2]

  ff.button(:name, "login2").click
end

def getRakuten(ff,account_info)
  loginRakuten(ff,account_info)
  sleep 2 # ページの読み込みに時間がかかってエラーが出るため。
  ff.link(:href, "/specific").click
  ff.link(:href, /.*tab_no\/2\//).click

  out = [] # 格納するのは配列でないといけない。あとでprint_tableするため。
  out << ['◆楽天カード次回支払い額']
  out << store_table(ff.table(:index, 1))
  out << ["▼回数指定払い明細"]
  out << store_table(ff.table(:index, 3))
  out << ["▼リボ払い明細"]
  out << store_table(ff.table(:index, 4))

  ff.link(:href, /.*tab_no\/1\//).click

  out << ['◆楽天カード次々回以降支払い額']
  out << store_table(ff.table(:index, 1))

  ff.link(:href, /logout/).click

  return out
end

def make_accountRakuten(index)
  an_account_info = []
  an_account_info[0] = @item_names[index] # "Rakuten"
  puts "楽天カードのユーザID（メールアドレス）を入力してください。"
  an_account_info[1] = gets.chomp

  puts "楽天カードのパスワードを入力してください。"
  an_account_info[2] = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
  an_account_info[2] = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。

  return an_account_info
end

# セゾンカード
def loginSaison(ff,account_info)
  ff.goto("https://netanswerplus.saisoncard.co.jp/WebPc/welcomeSCR.do")

  ff.text_field(:name, "inputId").value = account_info[1]
  ff.text_field(:name, "inputPassword").value = account_info[2]
  ff.button(:name, "login").click
end

def getSaison(ff,account_info)
  loginSaison(ff,account_info)
  ff.link(:href, /\/WebPc\/USC0101BLC01.do/).click
# 確定分
  out = [] # 格納するのは配列でないといけない。あとでprint_tableするため。
  out << ['◆セゾンカード次回支払い額']
  out << [ff.h4(:index, 1).text] # 何月分お支払いご利用明細
  
  out << store_table(ff.table(:index, 1)) # 引き落とし口座情報
  out << store_table(ff.table(:index, 2)) # 合計額
  out << ["▼利用明細"]

  out << store_table(ff.table(:index, 3))
  out << store_table(ff.table(:index, 4))

# 未確定分
  ff.link(:href, /.*nonTargetMonth=1.*/).click

#　未確定分詳細一覧
  out << ['◆セゾンカード次々回以降支払い額']
  out << [ff.h1(:index, 2).text] # 何月分ご利用明細
  out << store_table(ff.table(:index, 1)) # 明細
  out << store_table(ff.table(:index, 2)) # 合計

# Logout
  ff.link(:href, /\/WebPc\/USL0100BLC01/).click

  return out
end

def make_accountSaison(index)
  an_account_info = []
  an_account_info[0] = @item_names[index] #"Saison"
  puts "セゾンカードのユーザID（NetアンサーID）を入力してください。"
  an_account_info[1] = gets.chomp

  puts "セゾンカード（Netアンサー）のパスワードを入力してください。"
  an_account_info[2] = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
  an_account_info[2] = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。

  return an_account_info
end
