#!ruby -Ku
# get_a_info用のライブラリ
# ほかの口座に対応したい場合は、こんな感じで追加ライブラリをつくってください。
# ライブラリのファイルをget_a_info.rbと同じディレクトリに配置して、
# lib_a_requireの最後に「require '追加ライブラリ名（.rbなしのファイル名）'」と
# 書き加えておけば、get_a_info、makepasswdfileを実行した際の選択肢一覧に表示されるはずです。
# 未確定月のデータの取得・清書が怪しいです。（自分カードからの支払いがなかったため）
# 間違っていたらごめんなさい。

@item_names << "VISA" # アカウント情報を一意に決めるための内部名
@print_names << "三井住友VISAカード" # 選択画面に表示する名前
@get_functions << "getVISA" # 口座情報取得関数を()なしで指定。

# ここ以下がオプション。

# アカウント情報登録のための関数の配列
@make_account << "make_accountVISA"
@login_functions << "loginVISA" # ログインのみを指定した時に呼び出させる関数。
@format_functions << "formatVISA" # 書式を整える関数取得用の配列（未実装の場合はfalseを入れてください。）

def loginVISA(ff,account_info)
  ff.goto("https://www.smbc-card.com/mem/top/index.jsp")
  ff.text_field(:name, "userid").value = account_info[1]
  ff.text_field(:name, "password").value = account_info[2]
  ff.button(:name, "login01").click
 end

def getVISA(ff,account_info)
  loginVISA(ff,account_info)
  ff.link(:href, /web_meisai_top/).click
 
  out = []
  out << ['◆三井住友VISAカード']
  out << store_table(ff.table(:index,16))
  out << store_table(ff.table(:index,22))
  out << store_table(ff.table(:index,25))

  ff.select_list(:index, 1).value = ff.select_list(:index,1)[8].value
  ff.button(:src, /go/).click
  out << store_table(ff.table(:index,12))
  out << store_table(ff.table(:index,14))

  ff.link(:href, /logout/).click

  return out # 取得した情報を疑似3次元配列で返す。
end

def make_accountVISA(index)
  an_account_info = []
  an_account_info[0] = @item_names[index]
  puts "VpassIDを入力してください。"
  an_account_info[1] = gets.chomp

  puts "Vpassのパスワードを入力してください。"
  an_account_info[2] = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
  an_account_info[2] = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。

  return an_account_info
end


def formatVISA(outputs, index) # 使っていないが、サンプルとして登録。
  kugiri = "◆" + @print_names[index]
  card = "カード\t" + outputs[1][3][1]
  kouza = "引落口座\t" + outputs[2][0][1]
  day = "支払日\t" + outputs[1][1][1]
  gaku = "次回支払い金額\t" + outputs[1][2][1]
  
  meisai_header = "日付\t" + "摘要\t" + "支払い区分\t" + "請求額"
  
  puts kugiri
  puts card
  puts kouza
  puts day
  puts gaku

  puts "▼利用明細"
  puts meisai_header
  outputs[3].each_with_index do |x,i|
    next if i < 3 || i == outputs[3].length - 1
    print x[1] + "\t" # 日付
    print x[2] + "\t"
    print x[4] + "\t"
    print x[3] + "\n"
  end

  puts "▼三井住友VISAカード次々回以降支払い額"
  puts meisai_header
  outputs[5].each_with_index do |x,i|
    next if i < 3
    print x[1] + "\t" # 日付
    print x[2] + "\t"
    print x[4] + "\t"
    print x[3] + "\n"
  end
end
