#!ruby -Ku
# irbで動作確認するときようのテキストです。
# irbを起動したあとに、コピペで読み込ませることを想定しています。

require 'openssl' # パスワードの暗号復号に使うので、最初に呼び出す。

@item_names = [] # アカウント情報を一意に決めるための内部名
@print_names = [] # 表示名
@get_functions = [] # 読み出した口座情報関数取得用の配列
@make_account = [] # アカウント情報登録のための関数の配列
@login_functions = [] # ログインのみの関数の配列
@format_functions = [] # 書式を整える関数（オプション）取得用の配列

# 関数ライブラリとデフォルトの口座用関数だけrequire
require 'lib_a_methods'
require 'lib_a_default'

 # ログインアカウント保存用配列
account_info = Array.new(@item_names.length, false)

# アカウント情報が登録されているかどうかのフラグの配列を設定
flags = Array.new(@item_names.length, false)

# キー入力を隠すコマンドがOS依存なのでOS判定。
case RUBY_PLATFORM.downcase
when /mswin(?!ce)|mingw|cygwin|bccwin/
  @osname = "windows"
when /linux/
  @osname ="linux"
end

puts "マスターパスワードを入力してください。"
key = `stty -echo;read line;stty echo; echo $line`.chomp if @osname == "linux"
key = gets.chomp if @osname == "windows" # Windowsの場合はキー入力を隠さない。

###### パスワードの入力があるので、コピペの場合はここで切ること ##########

if File.exist?("account_passwd")
  enc_passes = []
  dec_passes = []
  enc_passes = open("account_passwd", "rb"){ |f| f.read }
  begin
    dec_passes = enc_passes.decrypt(key).split("\n")
  rescue
    STDERR.puts "パスワードが違います！ パスワードファイルを解読できません。" if $!.to_s == 'bad decrypt'
    exit
  end
  dec_passes.map! {|l| l.split(",")}

  # 登録されている関数のアカウント情報があるかどうか順番に見ていく。
  # あったら、それを見つけた順に格納。

  @item_names.each_with_index do |x, i|
    dec_passes.each do |y|
      if y[0] == x
        flags[i] = true
        account_info[i] = y
      end
    end
  end
end
# gemsのライブラリはロードが遅いので、パスワード入力後にロード。
require 'rubygems'

# 作業用ブラウザインスタンス作成コマンド
# Windowsの場合はWatir＋IEで動くようにしてある。Vista+IE7だt「ログインのみ」だけ対応。
# それ以降の情報取得はHTMLのオブジェクトの読み込み方の違いからか、うまく動かなかった。
# テーブル名をIndexを使わずに一意に決められる方法があれば、両方で同じように動くかもしれない。
# Windowsの場合は、パスワード入力の際に文字が隠れないという制限がある。（僕がどうやって隠すか知らないため）
if @osname == "linux"
  require 'firewatir'
  new_browser = "ff = FireWatir::Firefox.new"
elsif @osname == "windows"
  require 'watir'
  new_browser = "ff = Watir::IE.new"
end

# ここまで。

# 新しいライブラリをつくって、実験する時は「load 'newlib.rb'」のように
# loadを使うと、修正後の再読み込みができる。
# ただ、@のついた関数への追記がそこに入っていると配列にどんどん追記されて、
# 期待通りの動きをしないもしれないので注意。
