package gui;

import java.awt.BorderLayout;

import javax.media.opengl.awt.GLCanvas;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.WindowConstants;

import manager.Manager;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Point;

public class PI_Window extends JFrame implements WindowListener{

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private GLCanvas canvas = null;
	private GL_Event glEvent = null;  //  @jve:decl-index=0:

	// 管理クラス
	private Manager manager = null;
	
	// パネル管理
	CardLayout clPanel = null;  //  @jve:decl-index=0:
	
	/**
	 * This is the default constructor
	 */
	public PI_Window(Manager manager) {
		super();
		this.manager = manager;
		manager.window = this;
		initialize();
		addWindowListener(this);
//		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setVisible(true);
		manager.animator.start();		// setVisible(true)のあとにスタートさせないとエラー
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(600, 622);
		this.setLocation(new Point(0, 22));
		this.setContentPane(getJContentPane());
		this.setTitle("Palmiters Insect");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.gridy = 0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.weighty = 1.0;
			gridBagConstraints.gridx = 0;
			jContentPane = new JPanel();
			clPanel = new CardLayout();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.setPreferredSize(new Dimension(600, 600));
			jContentPane.add(getGLCanvas(), gridBagConstraints);
		}
		return jContentPane;
	}

	/**
	 * This method initializes painter_ogl	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private GLCanvas getGLCanvas() {
		if (canvas == null) {
			canvas = new GLCanvas();
			manager.canvas = canvas;
			glEvent = new GL_Event(manager);
			manager.canvas.addGLEventListener(glEvent);
			manager.canvas.addMouseListener(glEvent);
			manager.canvas.addMouseMotionListener(glEvent);
			manager.canvas.addKeyListener(glEvent);
			manager.canvas.setFocusable(true);	// setForcusable(true)しないとうまく動作しない
			canvas.setName("canvas");
		}
		return canvas;
	}

	// windowListener
	public void windowActivated(WindowEvent e) {}

	public void windowClosed(WindowEvent e) {}

	public void windowClosing(WindowEvent e) {
        new Thread(new Runnable() {
        	public void run() {
        		if(manager != null)
        			if(manager.animator != null)
        				manager.animator.stop();
        		System.exit(0);
            }
          }).start();
	}

	public void windowDeactivated(WindowEvent e) {}

	public void windowDeiconified(WindowEvent e) {}

	public void windowIconified(WindowEvent e) {}

	public void windowOpened(WindowEvent e) {	}
	
}  //  @jve:decl-index=0:visual-constraint="-18,5"
