package gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

// 描画クラス
public class PI_Logo_Painter extends JPanel{
	private static final long serialVersionUID = 1L;
	// 描画パネル用インスタンス
	private BufferedImage image = null;		//メモリ上のイメージ
	private Graphics2D imageGraphics;			//イメージのGraphicsインスタンス

	// ロゴ
	private BufferedImage Logo = null;

	// フィールド
	private Dimension d;				//描画領域
	public int w;							//描画領域の幅
	public int h;							//描画領域の高さ

	public int x1, x2, y11, y12, y21, y22;
	public int X1, X2, Y1, Y2;
	public int count=0;

	// コンストラクタ
	public PI_Logo_Painter(){
	}

	// paintComponent
	public void paintComponent(Graphics g){
		// このパネルのサイズを取得
		d = this.getSize();

		// 初期化処理(メモリ上にイメージ領域が確保されていないとき、インスタンスを作成)
		if(image==null || w!=d.width || h!=d.height){

			// このパネルのサイズを取得
			w = d.width;
			h = d.height;

			// パネルと同じサイズのイメージ量いきをメモリ上に作成
			image = (BufferedImage)createImage(w, h);

			// メモリ上のイメージに描画するためのGraphicsインスタンスを作成
			imageGraphics = image.createGraphics();
			imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		}

		// このパネルに描画するための準備
		super.paintComponent(g);

		readImage();
		g.drawImage(Logo, 10, 10, this);
	}

	// 画像ファイルの読み込み
	private void readImage(){
		try{
			Logo = ImageIO.read(new File("png/Palmiters.png"));
		}
		catch(IOException ie){
			ie.printStackTrace();
		}
	}
}
