package gui;

import java.awt.BorderLayout;

import javax.media.opengl.awt.GLCanvas;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.WindowConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import manager.Manager;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.CardLayout;
import java.util.StringTokenizer;

public class PI_Analysis2_Window extends JFrame implements ActionListener, ChangeListener{

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JPanel painter_Analysis = null;
	private GLCanvas canvas = null;
	private GL_Event glEvent = null;  //  @jve:decl-index=0:
    private JButton Button[] = new JButton[13];
	public JComboBox combo[] = new JComboBox[2];
    private JSlider slider1, slider2;
	private JLabel text[] = new JLabel[16];
	private TextField tf[] = new TextField[12];

	private boolean flag_switch = true;
	private boolean flag_window = true;
	private boolean flag_Graph1 = true;
	private boolean flag_Graph2 = true;
	private String str;

	PI_Logo_Window newwin;    //ﾕｰｻﾞｰ定義ｸﾗｽのｵﾌﾞｼﾞｪｸﾄ

	// 管理クラス
	private Manager manager = null;

	// パネル管理
	GridBagLayout clPanel = null;  //  @jve:decl-index=0:

	/**
	 * This is the default constructor
	 */
	public PI_Analysis2_Window(Manager manager) {
		super();
		this.manager = manager;
		manager.window_Analysis2 = this;
		initialize();
		this.setLocation(910, 0);
		setVisible(true);
	}

	/**
	 * This method initializes this
	 *
	 * @return void
	 */
	private void initialize() {
		this.setSize(316,500);
		this.setContentPane(getJContentPane());
		this.setTitle("Palmiters Insect Control");
	}

	/**
	 * This method initializes jContentPane
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.add(getPainter(), getPainter().getName());
			getPainter().setBounds(10, 20, 280, 80);
			jContentPane.setLayout(null);

//			//スライダー
//			slider1 = new JSlider(0, 1500, 20);
//			slider2 = new JSlider(0, 1000, 200);
//			slider1.setBounds(10, 270, 140, 30);
//			slider2.setBounds(150, 270, 140, 30);
//			jContentPane.add(slider1);
//			jContentPane.add(slider2);
//			//スライダーにリスナを追加
//			slider1.addChangeListener(this);
//			slider2.addChangeListener(this);

			//テキスト
			//テキスト内容を設定
			text[0] = new JLabel("Status");
			text[1] = new JLabel("Graph1 Control");
			text[2] = new JLabel("Graph2 Control");
			text[3] = new JLabel("Parameter Control");
			text[4] = new JLabel("Initial Behavior :");
			text[5] = new JLabel("Diff Behavior :");
			text[6] = new JLabel("Energy Rod :");
			text[7] = new JLabel("Energy Diff :");
			text[8] = new JLabel("Energy Init :");
			text[9] = new JLabel("Rest Turn :");
			text[10] = new JLabel("Energy Rest :");
			text[11] = new JLabel("Rest :");
			text[12] = new JLabel("Fb Diff Count :");
			text[13] = new JLabel("Fb Diff Span :");
			text[14] = new JLabel("Food First Point :");
			text[15] = new JLabel("Food Breadth :");
			//テキストのフォントを設定
			for(int i=0; i<4; i++){
				text[i].setFont(new java.awt.Font("Impact", Font.PLAIN, 18));
			}
		    //テキストの位置・大きさを設定
			text[0].setBounds(5, 0, 200, 20);
			text[1].setBounds(5, 100, 200, 20);
			text[2].setBounds(5, 200, 200, 20);
			text[3].setBounds(5, 248, 200, 20);
			text[4].setBounds(10, 270, 90, 20);
			text[5].setBounds(21, 290, 85, 20);
			text[6].setBounds(29, 310, 75, 20);
			text[7].setBounds(32, 330, 70, 20);
			text[8].setBounds(34, 350, 70, 20);
			text[9].setBounds(38, 370, 65, 20);
			text[10].setBounds(174, 270, 75, 20);
			text[11].setBounds(216, 290, 35, 20);
			text[12].setBounds(171, 310, 80, 20);
			text[13].setBounds(175, 330, 75, 20);
			text[14].setBounds(155, 350, 95, 20);
			text[15].setBounds(167, 370, 85, 20);
			for(int i=0;i<16;i++)
				jContentPane.add(text[i]);

		    final JCheckBox cb[] = new JCheckBox[10];
			//チェックボックス
		    cb[0] = new JCheckBox("Pals Num", true);
		    cb[0].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[0].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[0] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[0] = false;
		        }
		    });
		    cb[0].setBounds(10, 120, 90, 20);
		    cb[0].addChangeListener(this);
		    cb[1] = new JCheckBox("Baits Num", true);
		    cb[1].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[1].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[1] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[1] = false;
		        }
		    });
		    cb[1].setBounds(10, 140, 90, 20);
		    cb[1].addChangeListener(this);
		    cb[2] = new JCheckBox("Dead Num");
		    cb[2].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[2].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[2] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[2] = false;
		        }
		    });
		    cb[2].setBounds(10, 160, 90, 20);
		    cb[2].addChangeListener(this);
		    cb[3] = new JCheckBox("Divs Num");
		    cb[3].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[3].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[3] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[3] = false;
		        }
		    });
		    cb[3].setBounds(10, 180, 90, 20);
		    cb[3].addChangeListener(this);

		    cb[4] = new JCheckBox("Stamina Max");
		    cb[4].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[4].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[4] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[4] = false;
		        }
		    });
		    cb[4].setBounds(100, 120, 100, 20);
		    cb[4].addChangeListener(this);
		    cb[5] = new JCheckBox("Stamina Min");
		    cb[5].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[5].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[5] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[5] = false;
		        }
		    });
		    cb[5].setBounds(100, 140, 100, 20);
		    cb[5].addChangeListener(this);
		    cb[6] = new JCheckBox("Stamina Avr");
		    cb[6].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[6].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[6] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[6] = false;
		        }
		    });
		    cb[6].setBounds(100, 160, 100, 20);
		    cb[6].addChangeListener(this);

		    cb[7] = new JCheckBox("Age Max");
		    cb[7].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[7].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[7] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[7] = false;
		        }
		    });
		    cb[7].setBounds(200, 120, 90, 20);
		    cb[7].addChangeListener(this);
		    cb[8] = new JCheckBox("Age Min");
		    cb[8].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[8].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[8] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[8] = false;
		        }
		    });
		    cb[8].setBounds(200, 140, 90, 20);
		    cb[8].addChangeListener(this);
		    cb[9] = new JCheckBox("Age Avr");
		    cb[9].addItemListener(new ItemListener(){
		        public void itemStateChanged(ItemEvent e){
		            if (cb[9].isSelected() == true){
		            	manager.painter_Analysis1.graph_flag[9] = true;
		            }else
		            	manager.painter_Analysis1.graph_flag[9] = false;
		        }
		    });
		    cb[9].setBounds(200, 160, 90, 20);
		    cb[9].addChangeListener(this);
		    for(int i=0; i<10; i++)
		    	jContentPane.add(cb[i]);

			//ボタン
			for(int i=0;i<13;i++)
				Button[i] = new JButton();
			//ボタンの名称を設定
			Button[0].setText("Start");
			Button[1].setText("Reset");
			Button[2].setText("Graph1 OFF");
			Button[3].setText("Graph2 OFF");
			Button[4].setText("Bait switch");
			Button[5].setText("Save");
			Button[6].setText("About it");
			Button[7].setText("Exit");
			Button[8].setText("Select");
			Button[9].setText("Deselect");
			//ボタンの位置・大きさを設定
			Button[0].setBounds(0, 390, 150, 25);
			Button[1].setBounds(150, 390, 150, 25);
			Button[2].setBounds(0, 415, 100, 25);
			Button[3].setBounds(100, 415, 100, 25);
			Button[4].setBounds(200, 415, 100, 25);
			Button[5].setBounds(0, 440, 100, 25);
			Button[6].setBounds(100, 440, 100, 25);
			Button[7].setBounds(200, 440, 100, 25);
			Button[8].setBounds(104, 184, 90, 15);
			Button[9].setBounds(204, 184, 90, 15);
		    Button[8].addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
		        	for(int i=0; i<10; i++)
		        		cb[i].setSelected(true);
				}
		    });
		    Button[9].addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
		        	for(int i=0; i<10; i++)
		        		cb[i].setSelected(false);
				}
		    });
			for(int i=0;i<13;i++)
				jContentPane.add(Button[i]);
			//各ボタンにリスナを追加
			for(int i=0;i<8;i++)
				Button[i].addActionListener(this);

			//リスト
			for(int i=0; i<2; i++){
				combo[i] = new JComboBox();
				combo[i].addItem("Pals Num");
				combo[i].addItem("Baits Num");
				combo[i].addItem("Dead Num");
				combo[i].addItem("Div Num");
				combo[i].addItem("Stamina Max");
				combo[i].addItem("Stamina Min");
				combo[i].addItem("Stamina Avr");
				combo[i].addItem("Age Max");
				combo[i].addItem("Age Min");
				combo[i].addItem("Age Avr");
				combo[i].setBounds(50+150*i, 225, 95, 20);
				jContentPane.add(combo[i]);
			}
			combo[0].setSelectedItem("Pals Num");
			combo[1].setSelectedItem("Baits Num");
			combo[0].addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					if(combo[0].getSelectedItem()=="Pals Num")
						manager.painter_Analysis1.x_item = 0;
					else if(combo[0].getSelectedItem()=="Baits Num")
						manager.painter_Analysis1.x_item = 1;
					else if(combo[0].getSelectedItem()=="Dead Num")
						manager.painter_Analysis1.x_item = 2;
					else if(combo[0].getSelectedItem()=="Div Num")
						manager.painter_Analysis1.x_item = 3;
					else if(combo[0].getSelectedItem()=="Stamina Max")
						manager.painter_Analysis1.x_item = 4;
					else if(combo[0].getSelectedItem()=="Stamina Min")
						manager.painter_Analysis1.x_item = 5;
					else if(combo[0].getSelectedItem()=="Stamina Avr")
						manager.painter_Analysis1.x_item = 6;
					else if(combo[0].getSelectedItem()=="Age Max")
						manager.painter_Analysis1.x_item = 7;
					else if(combo[0].getSelectedItem()=="Age Min")
						manager.painter_Analysis1.x_item = 8;
					else if(combo[0].getSelectedItem()=="Age Avr")
						manager.painter_Analysis1.x_item = 9;
				}
		    });
			combo[1].addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					if(combo[1].getSelectedItem()=="Pals Num")
						manager.painter_Analysis1.y_item = 0;
					else if(combo[1].getSelectedItem()=="Baits Num")
						manager.painter_Analysis1.y_item = 1;
					else if(combo[1].getSelectedItem()=="Dead Num")
						manager.painter_Analysis1.y_item = 2;
					else if(combo[1].getSelectedItem()=="Div Num")
						manager.painter_Analysis1.y_item = 3;
					else if(combo[1].getSelectedItem()=="Stamina Max")
						manager.painter_Analysis1.y_item = 4;
					else if(combo[1].getSelectedItem()=="Stamina Min")
						manager.painter_Analysis1.y_item = 5;
					else if(combo[1].getSelectedItem()=="Stamina Avr")
						manager.painter_Analysis1.y_item = 6;
					else if(combo[1].getSelectedItem()=="Age Max")
						manager.painter_Analysis1.y_item = 7;
					else if(combo[1].getSelectedItem()=="Age Min")
						manager.painter_Analysis1.y_item = 8;
					else if(combo[1].getSelectedItem()=="Age Avr")
						manager.painter_Analysis1.y_item = 9;
				}
		    });

			//テキスト
			text[0] = new JLabel("x-axis");
			text[1] = new JLabel("y-axis");
			text[0].setBounds(10, 225, 200, 20);
			text[1].setBounds(160, 225, 200, 20);
			for(int i=0; i<2; i++)
				jContentPane.add(text[i]);

			//テキストフィールド
			for(int i=0; i<2; i++){
				for(int j=0; j<6; j++){
					tf[i*6+j] = (TextField)add(new TextField(20));
					tf[i*6+j].setBounds(105+145*i, j*20+270, 45, 20);
					jContentPane.add(tf[i*6+j]);
					tf[i*6+j].addActionListener(this);
				}
			}
			tf[0].setText("2.0");
			tf[1].setText("0.2");
			tf[2].setText("100");
			tf[3].setText("500");
			tf[4].setText("1000");
			tf[5].setText("5");
			tf[6].setText("200");
			tf[7].setText("0");
			tf[8].setText("1000");
			tf[9].setText("20");
			tf[10].setText("10");
			tf[11].setText("20");

			jContentPane.setPreferredSize(new Dimension(301, 501));
		}
		return jContentPane;
	}

	/**
	 * This method initializes painter
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getPainter() {
		if (painter_Analysis == null) {
			// painter
			painter_Analysis = new PI_Analysis2_Painter(manager);
			painter_Analysis.setName("painter_Analysis");
			manager.painter_Analysis2.addMouseListener(manager.painter_Analysis2);
			painter_Analysis.setLayout(new GridBagLayout());
			painter_Analysis.setPreferredSize(new Dimension(301, 801));
		}
		return painter_Analysis;
	}

	/**
	 * This method initializes painter_ogl
	 *
	 * @return javax.swing.JPanel
	 */

	// windowListener
	public void windowActivated(WindowEvent e) {}

	public void windowClosed(WindowEvent e) {}

	public void windowDeactivated(WindowEvent e) {}

	public void windowDeiconified(WindowEvent e) {}

	public void windowIconified(WindowEvent e) {}

	public void windowOpened(WindowEvent e) {	}

	//操作ボタンのイベント処理
	public void actionPerformed(ActionEvent ev) {
		//"start&stop"ボタン
		if(ev.getSource() == Button[0]){
			if(!flag_switch){
				Button[0].setText("Start");
			}else{
				Button[0].setText("Stop");
			}
			flag_switch = !flag_switch;
			return;
		}
		//"Reset"ボタン
		else if(ev.getSource() == Button[1]) {
			return;
		}
		//"Graph1 ON/OFF"ボタン
		else if(ev.getSource() == Button[2]) {
			if(!flag_Graph1){
				Button[2].setText("Graph1 OFF");
				manager.painter_Analysis1.graph1_flag = true;
			}else{
				Button[2].setText("Graph1 ON");
				manager.painter_Analysis1.graph1_flag = false;
			}
			flag_Graph1 = !flag_Graph1;
			return;
		}
		//"Graph2 ON/OFF"ボタン
		else if(ev.getSource() == Button[3]) {
			if(!flag_Graph2){
				Button[3].setText("Graph2 OFF");
				manager.painter_Analysis1.graph2_flag = true;
			}else{
				Button[3].setText("Graph2 ON");
				manager.painter_Analysis1.graph2_flag = false;
			}
			flag_Graph2 = !flag_Graph2;
			return;
		}
		//""ボタン
		else if(ev.getSource() == Button[4]) {
			manager.glEvent.pattern_flag = !manager.glEvent.pattern_flag;
			return;
		}
		//""ボタン
		else if(ev.getSource() == Button[5]) {
			return;
		}
		//""ボタン
		else if(ev.getSource() == Button[6]) {
			if(!flag_window){
			    newwin.setVisible(false);
				Button[6].setText("About it");	//ボタンテキストを"Start"に変更
			}else{
				newwin = new PI_Logo_Window();
			    newwin.setSize(400,200);
			    newwin.setLocation(400,200);
			    newwin.setVisible(true);
				Button[6].setText("Close");	//ボタンテキストを"Stop"に変更
			}
			flag_window = !flag_window;
			return;
		}
		//""ボタン
		else if(ev.getSource() == Button[7]) {
	        System.exit(0);
			return;
		}
		else if(ev.getSource() == tf[0]) {
			try{
				manager.abs.set_initial_behavior(Integer.parseInt(ev.getActionCommand()), manager);
			}catch(Exception _ex){
				tf[0].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[1]) {
			try{
				manager.abs.set_diff_behavior(Integer.parseInt(ev.getActionCommand()), manager);
			}catch(Exception _ex){
				tf[1].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[2]) {
			try{
				manager.abs.set_energy_rod(Integer.parseInt(ev.getActionCommand()), manager);
			}catch(Exception _ex){
				tf[2].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[3]) {
			try{
				manager.abs.set_energy_diff(Integer.parseInt(ev.getActionCommand()), manager);
			}catch(Exception _ex){
				tf[3].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[4]) {
			try{
				manager.abs.set_energy_init(Integer.parseInt(ev.getActionCommand()), manager);
			}catch(Exception _ex){
				tf[4].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[5]) {
			try{
				manager.abs.set_rest_turn(Integer.parseInt(ev.getActionCommand()), manager);
			}catch(Exception _ex){
				tf[5].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[6]) {
			try{
				manager.abs.set_energy_rest(Integer.parseInt(ev.getActionCommand()), manager);
			}catch(Exception _ex){
				tf[6].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[7]) {
			try{
				manager.abs.set_rest(Integer.parseInt(ev.getActionCommand()), manager);
			}catch(Exception _ex){
				tf[7].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[8]) {
			try{
				manager.glEvent.fb_diff_count = Integer.parseInt(ev.getActionCommand());
			}catch(Exception _ex){
				tf[8].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[9]) {
			try{
				manager.glEvent.fb_diff_span = Integer.parseInt(ev.getActionCommand());
			}catch(Exception _ex){
				tf[9].setText("Error");
				System.out.println("Error");
			}
	     	return;
		}
		else if(ev.getSource() == tf[10]) {
			manager.glEvent.food_first_point = Integer.parseInt(ev.getActionCommand());
	     	return;
		}
		else if(ev.getSource() == tf[11]) {
			manager.glEvent.food_breadth = Integer.parseInt(ev.getActionCommand());
	     	return;
		}
	}

	public void stateChanged(ChangeEvent e) {
		repaint();
	}
}


