package gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JPanel;

import agent.Autonomous_Bug;

import manager.Manager;

// 描画クラス
public class PI_Analysis2_Painter extends JPanel implements MouseListener{

	// 管理クラス
	private Manager manager;

	// 描画パネル用インスタンス
	private BufferedImage image = null;		//メモリ上のイメージ
	private Graphics2D imageGraphics;			//イメージのGraphicsインスタンス

	// 虫
	private BufferedImage food_bug = null;
	private BufferedImage autonomous_bug = null;

	// フィールド
	private Dimension d;				//描画領域
	public int w;							//描画領域の幅
	public int h;							//描画領域の高さ

	public int x1, x2, y11, y12, y21, y22;
	public int X1, X2, Y1, Y2;
	public int count=0;
	private int[][] percent = new int[2][10000];
	private int[][] temp_percent = new int[2][10000];

	// コンストラクタ
	public PI_Analysis2_Painter(Manager manager){
		this.manager = manager;
		manager.painter_Analysis2 = this;
		//readImage();
	}

	// paintComponent
	public void paintComponent(Graphics g){
		// このパネルのサイズを取得
		d = this.getSize();

		// 初期化処理(メモリ上にイメージ領域が確保されていないとき、インスタンスを作成)
		if(image==null || w!=d.width || h!=d.height){

			// このパネルのサイズを取得
			w = d.width;
			h = d.height;

			// パネルと同じサイズのイメージ量いきをメモリ上に作成
			image = (BufferedImage)createImage(w, h);


			// メモリ上のイメージに描画するためのGraphicsインスタンスを作成
			imageGraphics = image.createGraphics();
			imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		}

		// このパネルに描画するための準備
		super.paintComponent(g);

		// test
		Color BackColor = new Color(238, 238, 238, 224);
		imageGraphics.setColor(BackColor);
		imageGraphics.fillRect(0, 0, w, h);
		drawStatus(imageGraphics);

		// メモリ上のイメージをパネルに写して表示
		g.drawImage(image, 0, 0, this);
	}


	//ステータスを描くメソッド
	private void drawStatus(Graphics2D g){
		// Color生成
		//Color lineColor = new Color(128,128,128,200);
		g.setColor(Color.black);
		count++;
		g.drawString("Step:"+manager.glEvent.step, 35, 15);
		g.drawString("Pals Num:"+manager.abs.abSet.size(), 5, 30);
		g.drawString("Baits Num:"+manager.fbs.fbSet.size(), 2, 45);
		g.drawString("Dead Num:"+count, 0, 60);
		g.drawString("Div Num:"+count, 13, 75);

		g.drawString("Stamina Max:"+manager.abs.getMaxEnergy(manager), 93, 15);
		g.drawString("Stamina Min:"+manager.abs.getMinEnergy(manager), 95, 30);
		g.drawString("Stamina Avr:"+manager.abs.getAveEnergy(manager), 98, 45);
		//g.drawString("Stamina Min:"+count, 95, 60);
		//g.drawString("Stamina Avr:"+count, 98, 75);

		g.drawString("Age Max:"+manager.abs.getElderSteps(manager), 200, 15);
		g.drawString("Age Min:"+manager.abs.getYoungerSteps(manager), 202, 30);
		g.drawString("Age Avr:"+manager.abs.getAverageSteps(manager), 205, 45);
//		g.drawString("Age Min:"+count, 202, 60);
//		g.drawString("Age Avr:"+count, 205, 75);

	}

	// MouseListener
	public void mouseClicked(MouseEvent e) {

	}

	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
}
