package gui;

import java.awt.BorderLayout;

import javax.media.opengl.awt.GLCanvas;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.WindowConstants;

import manager.Manager;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.CardLayout;

public class PI_Analysis1_Window extends JFrame{

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JPanel painter_Analysis = null;
	private GLCanvas canvas = null;
	private GL_Event glEvent = null;  //  @jve:decl-index=0:

	// 管理クラス
	private Manager manager = null;

	// パネル管理
	CardLayout clPanel = null;  //  @jve:decl-index=0:

	/**
	 * This is the default constructor
	 */
	public PI_Analysis1_Window(Manager manager) {
		super();
		this.manager = manager;
		manager.window_Analysis1 = this;
		initialize();
		this.setLocation(600, 0);
		setVisible(true);
	}

	/**
	 * This method initializes this
	 *
	 * @return void
	 */
	private void initialize() {
		this.setSize(309,615);
		this.setContentPane(getJContentPane());
		this.setTitle("Palmiters Insect Analysis");
	}

	/**
	 * This method initializes jContentPane
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			clPanel = new CardLayout();
			jContentPane.setLayout(clPanel);
			jContentPane.setPreferredSize(new Dimension(301, 801));
			jContentPane.add(getPainter(), getPainter().getName());
//			jContentPane.add(getGLCanvas(), getGLCanvas().getName());
			clPanel.show(jContentPane, "canvas");
		}
		return jContentPane;
	}

	/**
	 * This method initializes painter
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getPainter() {
		if (painter_Analysis == null) {
			// painter
			painter_Analysis = new PI_Analysis1_Painter(manager);
			painter_Analysis.setName("painter_Analysis");
			manager.painter_Analysis1.addMouseListener(manager.painter_Analysis1);
			painter_Analysis.setLayout(new GridBagLayout());
			painter_Analysis.setPreferredSize(new Dimension(301, 801));
		}
		return painter_Analysis;
	}

	/**
	 * This method initializes painter_ogl
	 *
	 * @return javax.swing.JPanel
	 */

	// windowListener
	public void windowActivated(WindowEvent e) {}

	public void windowClosed(WindowEvent e) {}

	public void windowDeactivated(WindowEvent e) {}

	public void windowDeiconified(WindowEvent e) {}

	public void windowIconified(WindowEvent e) {}

	public void windowOpened(WindowEvent e) {	}
}
