package gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import manager.Manager;

// 描画クラス
public class PI_Analysis1_Painter extends JPanel implements MouseListener{

	// 管理クラス
	private Manager manager;

	// 描画パネル用インスタンス
	private BufferedImage image = null;		//メモリ上のイメージ
	private Graphics2D imageGraphics;			//イメージのGraphicsインスタンス

	// フィールド
	private Dimension d;				//描画領域
	public int w;							//描画領域の幅
	public int h;							//描画領域の高さ

	public int x1, x2, y11, y12, y21, y22;
	public int X1, X2, Y1, Y2;
	public int count=0;
	public int x_item=0, y_item=1;
	public boolean graph1_flag=true, graph2_flag=true;
	public boolean[] graph_flag = new boolean[10];
	private int[][] percent = new int[10][10000];
	private int[][] y = new int[10][2];
	private int Ene_max=0, Ene_min=0, Ene_avr=0;
	private int temp_Ene_max=0, temp_Ene_min=0, temp_Ene_avr=0;
	private int Age_max=1, Age_min=1, Age_avr=1;
	private int temp_Age_max=0, temp_Age_min=0, temp_Age_avr=0;

	// コンストラクタ
	public PI_Analysis1_Painter(Manager manager){
		this.manager = manager;
		manager.painter_Analysis1 = this;
		for(int i=0; i<10; i++)
			graph_flag[i] = false;
		graph_flag[0] = true;
		graph_flag[1] = true;
		//readImage();
	}

	// paintComponent
	public void paintComponent(Graphics g){
		// このパネルのサイズを取得
		d = this.getSize();

		// 初期化処理(メモリ上にイメージ領域が確保されていないとき、インスタンスを作成)
		if(image==null || w!=d.width || h!=d.height){

			// このパネルのサイズを取得
			w = d.width;
			h = d.height;

			// パネルと同じサイズのイメージ量いきをメモリ上に作成
			image = (BufferedImage)createImage(w, h);

			// メモリ上のイメージに描画するためのGraphicsインスタンスを作成
			imageGraphics = image.createGraphics();
			imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		}

		// このパネルに描画するための準備
		super.paintComponent(g);

		// test
		imageGraphics.setColor(Color.WHITE);
		imageGraphics.fillRect(0, 0, w, h);
		drawGraph(imageGraphics);

		// メモリ上のイメージをパネルに写して表示
		g.drawImage(image, 0, 0, this);
	}


	//グラフを描くメソッド
	private void drawGraph(Graphics2D g){
		temp_Ene_max = manager.abs.getMaxEnergy(manager);
		temp_Ene_min = manager.abs.getMinEnergy(manager);
		temp_Ene_avr = manager.abs.getAveEnergy(manager);
		if(temp_Ene_max>Ene_max)
			Ene_max = temp_Ene_max;
		if(temp_Ene_min>Ene_min)
			Ene_min = temp_Ene_min;
		if(temp_Ene_avr>Ene_avr)
			Ene_avr = temp_Ene_avr;

		temp_Age_max = manager.abs.getElderSteps(manager);
		temp_Age_min = manager.abs.getYoungerSteps(manager);
		temp_Age_avr = manager.abs.getAverageSteps(manager);
		if(temp_Age_max>Age_max)
			Age_max = temp_Age_max;
		if(temp_Age_min>Age_min)
			Age_min = temp_Age_min;
		if(temp_Age_avr>Age_avr)
			Age_avr = temp_Age_avr;
		//percent[0]は残っている虫の割合，percent[1]は残っているエサ虫の割合
		percent[0][count] = (int)(100*manager.abs.abSet.size()/manager.abs.getMaxAbsCount());
		percent[1][count] = (int)(100*manager.fbs.fbSet.size()/manager.fbs.getMaxFbsCount());
		percent[2][count] = (int)(100*manager.fbs.fbSet.size()/manager.fbs.getMaxFbsCount());
		percent[3][count] = (int)(100*manager.fbs.fbSet.size()/manager.fbs.getMaxFbsCount());
		percent[4][count] = (int)(100*manager.abs.getMaxEnergy(manager)/Ene_max);
		percent[5][count] = (int)(100*manager.abs.getMinEnergy(manager)/Ene_min);
		percent[6][count] = (int)(100*manager.abs.getAveEnergy(manager)/Ene_avr);
		percent[7][count] = (int)(100*manager.abs.getElderSteps(manager)/Age_max);
		percent[8][count] = (int)(100*manager.abs.getYoungerSteps(manager)/Age_min);
		percent[9][count] = (int)(100*manager.abs.getAverageSteps(manager)/Age_avr);

		if(graph1_flag){
			for(int k=0; k<10; k++){
				if(k==0)
					g.setColor(Color.blue);
				else if(k==1)
					g.setColor(Color.red);
				else if(k==2)
					g.setColor(Color.darkGray);
				else if(k==3)
					g.setColor(Color.green);
				else if(k==4)
					g.setColor(Color.magenta);
				else if(k==5)
					g.setColor(Color.orange);
				else if(k==6)
					g.setColor(Color.pink);
				else if(k==7)
					g.setColor(Color.cyan);
				else if(k==8)
					g.setColor(Color.black);
				else if(k==9)
					g.setColor(Color.lightGray);
				if(graph_flag[k]){
					for(int i=count - (count%245)+1; i<count; i++){
						//x:ステップ数 y:虫,エサ虫の割合
						//各座標の値を保持
						x1 = i%245+35;
						x2 = (i+1)%245+35;
						y[k][0] = (int)(((100-percent[k][i-1])/100.0)*230+35);
						y[k][1] = (int)(((100-percent[k][i])/100.0)*230+35);
						g.drawLine(x1, y[k][0], x2, y[k][0]);
						g.drawLine(x2, y[k][0], x2, y[k][1]);
					}
				}
			}
		}
		if(graph2_flag){
			if(count<246){
				for(int i=1; i<count; i++){
					//各座標の値を保持
					X1 = (int)(35 + ((double)percent[x_item][i-1]/100.0) * 245);
					X2 = (int)(35 + ((double)percent[x_item][i]/100.0) * 245);
					Y1 = (int)(35 + ((double)(100-percent[y_item][i-1])/100.0) * 230)+285;
					Y2 = (int)(35 + ((double)(100-percent[y_item][i])/100.0) * 230)+285;
					//残っているエサ虫の割合を描画
					g.setColor(Color.blue);
					g.drawLine(X1, Y1, X2, Y2);
				}
			}else{
				for(int i=count-245; i<count; i++){
					//各座標の値を保持
					X1 = (int)(35 + ((double)percent[x_item][i-1]/100.0) * 245);
					X2 = (int)(35 + ((double)percent[x_item][i]/100.0) * 245);
					Y1 = (int)(35 + ((double)(100-percent[y_item][i-1])/100.0) * 230)+285;
					Y2 = (int)(35 + ((double)(100-percent[y_item][i])/100.0) * 230)+285;
					//残っているエサ虫の割合を描画
					g.setColor(Color.blue);
					g.drawLine(X1, Y1, X2, Y2);
				}
			}
		}

		for(int k=0; k<2; k++){
			g.setColor(Color.black);
			g.drawRect(7, 5+k*285, 280, 280);									//外枠
			g.drawLine(35, 265+k*285, 280, 265+k*285);							//x軸
			g.drawLine(35, 25+k*285, 35, 265+k*285);							//y軸
			g.drawString("High", 9, 40+k*285);
			g.drawString("Low", 9, 280+k*285);
			g.drawString("High", 255, 280+k*285);
			if(k==0){
				g.drawString("step", 255, 260);									//x軸ラベル
				g.drawString("Percentage", 10, 20);								//y軸ラベル
			}
		}
		if(count>1) {
			if(manager.window_Analysis2.combo[0].getSelectedItem()=="Stamina Max"||
			   manager.window_Analysis2.combo[0].getSelectedItem()=="Stamina Min"||
			   manager.window_Analysis2.combo[0].getSelectedItem()=="Stamina Avr"){
					g.drawString(""+manager.window_Analysis2.combo[0].getSelectedItem(), 215, 545);								//x軸ラベル
					g.drawString(""+manager.window_Analysis2.combo[1].getSelectedItem(), 10, 305);
			}else{
				g.drawString(""+manager.window_Analysis2.combo[0].getSelectedItem(), 225, 545);								//x軸ラベル
				g.drawString(""+manager.window_Analysis2.combo[1].getSelectedItem(), 10, 305);
			}
		}
		count++;
	}

	// MouseListener
	public void mouseClicked(MouseEvent e) {

	}

	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
}
