package gui;


import javax.swing.JPanel;
import javax.swing.JFrame;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import javax.swing.BorderFactory;
import java.awt.Color;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.JTextField;

import manager.Manager;

import java.awt.Dimension;
import java.awt.Point;

public class GL_Event_Controller extends JFrame {

	private Manager manager;
	
	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JPanel GLC_Panel = null;
	private JLabel l_s = null;
	private JLabel jLabel = null;
	private JTextField tf_s = null;
	private JLabel l_a = null;
	private JLabel jLabel1 = null;
	private JTextField tf_a = null;
	private JPanel pp_panel = null;
	private JLabel l_ab = null;
	private JLabel jLabel11 = null;
	private JTextField tf_ab = null;
	private JLabel l_abe = null;
	private JLabel jLabel111 = null;
	private JTextField tf_abe = null;
	private JLabel l_fb = null;
	private JLabel jLabel1111 = null;
	private JTextField tf_fb = null;
	/**
	 * This is the default constructor
	 */
	public GL_Event_Controller(Manager manager) {
		super();
		this.manager = manager;
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(230, 230);
		this.setLocation(new Point(910, 522));
		this.setContentPane(getJContentPane());
		this.setTitle("GL_Controller");
		this.setVisible(true);
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = 0;
			jContentPane = new JPanel();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.add(getGLC_Panel(), gridBagConstraints);
		}
		return jContentPane;
	}

	/**
	 * This method initializes GLC_Panel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getGLC_Panel() {
		if (GLC_Panel == null) {
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.gridx = 0;
			gridBagConstraints7.gridwidth = 3;
			gridBagConstraints7.gridy = 2;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints6.gridy = 1;
			gridBagConstraints6.weightx = 1.0;
			gridBagConstraints6.gridx = 2;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.gridx = 1;
			gridBagConstraints5.gridy = 1;
			jLabel1 = new JLabel();
			jLabel1.setText("：");
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.gridx = 0;
			gridBagConstraints4.gridy = 1;
			l_a = new JLabel();
			l_a.setText("Frame par Step");
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints3.gridy = 0;
			gridBagConstraints3.weightx = 1.0;
			gridBagConstraints3.gridx = 2;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = 1;
			gridBagConstraints2.gridy = 0;
			jLabel = new JLabel();
			jLabel.setText("：");
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 0;
			l_s = new JLabel();
			l_s.setText("描画間隔");
			GLC_Panel = new JPanel();
			GLC_Panel.setLayout(new GridBagLayout());
			GLC_Panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray, 1), "描画設定", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, null, null));
			GLC_Panel.add(l_s, gridBagConstraints1);
			GLC_Panel.add(jLabel, gridBagConstraints2);
			GLC_Panel.add(getTf_s(), gridBagConstraints3);
			GLC_Panel.add(l_a, gridBagConstraints4);
			GLC_Panel.add(jLabel1, gridBagConstraints5);
			GLC_Panel.add(getTf_a(), gridBagConstraints6);
			GLC_Panel.add(getPp_panel(), gridBagConstraints7);
		}
		return GLC_Panel;
	}

	/**
	 * This method initializes tf_s	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTf_s() {
		if (tf_s == null) {
			tf_s = new JTextField();
			tf_s.setPreferredSize(new Dimension(70, 20));
			tf_s.setHorizontalAlignment(JTextField.CENTER);
			tf_s.setText("1");
			tf_s.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try{
						int new_interval;
						if((new_interval=Integer.parseInt(tf_s.getText()))>0){
							// fpstepを強制的に1にする
							manager.glEvent.new_interval = new_interval;
							manager.glEvent.new_fpstep = 1;
							tf_a.setText("1");
							manager.glEvent.configChanged = true;
						}
						else
							tf_s.setText(manager.glEvent.fpstep+"");
							
					}
					catch(Exception ee){
						tf_s.setText(manager.glEvent.fpstep+"");
					}
				}
			});
		}
		return tf_s;
	}

	/**
	 * This method initializes tf_a	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTf_a() {
		if (tf_a == null) {
			tf_a = new JTextField();
			tf_a.setPreferredSize(new Dimension(70, 20));
			tf_a.setHorizontalAlignment(JTextField.CENTER);
			tf_a.setText("5");
			tf_a.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try{
						int new_dps;
						if((new_dps=Integer.parseInt(tf_a.getText()))>0){
							manager.glEvent.new_fpstep = new_dps;
							manager.glEvent.configChanged = true;
						}
						else
							tf_a.setText(manager.glEvent.fpstep+"");
							
					}
					catch(Exception ee){
						tf_a.setText(manager.glEvent.fpstep+"");
					}
				}
			});
		}
		return tf_a;
	}

	/**
	 * This method initializes pp_panel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getPp_panel() {
		if (pp_panel == null) {
			GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
			gridBagConstraints15.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints15.gridy = 2;
			gridBagConstraints15.weightx = 1.0;
			gridBagConstraints15.gridx = 2;
			GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
			gridBagConstraints14.gridx = 1;
			gridBagConstraints14.gridy = 2;
			jLabel1111 = new JLabel();
			jLabel1111.setText("：");
			GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
			gridBagConstraints13.gridx = 0;
			gridBagConstraints13.gridy = 2;
			l_fb = new JLabel();
			l_fb.setText("餌虫");
			GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
			gridBagConstraints12.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints12.gridy = 1;
			gridBagConstraints12.weightx = 1.0;
			gridBagConstraints12.gridx = 2;
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.gridx = 1;
			gridBagConstraints11.gridy = 1;
			jLabel111 = new JLabel();
			jLabel111.setText("：");
			GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
			gridBagConstraints10.gridx = 0;
			gridBagConstraints10.gridy = 1;
			l_abe = new JLabel();
			l_abe.setText("自律虫(簡易)");
			GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
			gridBagConstraints9.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints9.gridy = 0;
			gridBagConstraints9.weightx = 1.0;
			gridBagConstraints9.gridx = 2;
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.gridx = 1;
			gridBagConstraints8.gridy = 0;
			jLabel11 = new JLabel();
			jLabel11.setText("：");
			l_ab = new JLabel();
			l_ab.setText("自律虫");
			pp_panel = new JPanel();
			pp_panel.setLayout(new GridBagLayout());
			pp_panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray, 1), "ポリゴン分割数", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, null, null));
			pp_panel.setPreferredSize(new Dimension(138, 90));
			pp_panel.add(l_ab, new GridBagConstraints());
			pp_panel.add(jLabel11, gridBagConstraints8);
			pp_panel.add(getTf_ab(), gridBagConstraints9);
			pp_panel.add(l_abe, gridBagConstraints10);
			pp_panel.add(jLabel111, gridBagConstraints11);
			pp_panel.add(getTf_abe(), gridBagConstraints12);
			pp_panel.add(l_fb, gridBagConstraints13);
			pp_panel.add(jLabel1111, gridBagConstraints14);
			pp_panel.add(getTf_fb(), gridBagConstraints15);
		}
		return pp_panel;
	}

	/**
	 * This method initializes tf_ab	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTf_ab() {
		if (tf_ab == null) {
			tf_ab = new JTextField();
			tf_ab.setPreferredSize(new Dimension(42, 20));
			tf_ab.setHorizontalAlignment(JTextField.CENTER);
			tf_ab.setText("5");
			tf_ab.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try{
						int p_ab;
						if((p_ab=Integer.parseInt(tf_ab.getText()))>0){
							manager.glEvent.new_p_ab = p_ab;
							manager.glEvent.configChanged = true;
						}
						else
							tf_ab.setText(manager.glEvent.p_ab+"");
							
					}
					catch(Exception ee){
						tf_ab.setText(manager.glEvent.p_ab+"");
					}
				}
			});
		}
		return tf_ab;
	}

	/**
	 * This method initializes tf_abe	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTf_abe() {
		if (tf_abe == null) {
			tf_abe = new JTextField();
			tf_abe.setPreferredSize(new Dimension(42, 20));
			tf_abe.setHorizontalAlignment(JTextField.CENTER);
			tf_abe.setText("5");
			tf_abe.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try{
						int p_abe;
						if((p_abe=Integer.parseInt(tf_abe.getText()))>0){
							manager.glEvent.new_p_abe = p_abe;
							manager.glEvent.configChanged = true;
						}
						else
							tf_abe.setText(manager.glEvent.p_abe+"");
							
					}
					catch(Exception ee){
						tf_abe.setText(manager.glEvent.p_abe+"");
					}
				}
			});
		}
		return tf_abe;
	}

	/**
	 * This method initializes tf_fb	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTf_fb() {
		if (tf_fb == null) {
			tf_fb = new JTextField();
			tf_fb.setPreferredSize(new Dimension(42, 20));
			tf_fb.setHorizontalAlignment(JTextField.CENTER);
			tf_fb.setText("5");
			tf_fb.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try{
						int p_fb;
						if((p_fb=Integer.parseInt(tf_fb.getText()))>0){
							manager.glEvent.new_p_fb = p_fb;
							manager.glEvent.configChanged = true;
						}
						else
							tf_fb.setText(manager.glEvent.p_fb+"");
							
					}
					catch(Exception ee){
						tf_fb.setText(manager.glEvent.p_fb+"");
					}
				}
			});
		}
		return tf_fb;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
