package gui;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedList;

import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;

import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;

import agent.Autonomous_Bug;
import agent.Autonomous_Bug_Set;
import agent.Food_Bug;
import agent.Food_Bug_Set;


import manager.Manager;

// opengl描画
public class GL_Event implements GLEventListener, MouseListener, MouseMotionListener, KeyListener {

	public int food_first_point = 10;
	public int food_breadth = 20;

	// 定数
	private static final int ANT = 0;
	private static final int SPHERE = 1;

	private static final int N = 0;
	private static final int NE = 1;
	private static final int E = 2;
	private static final int SE = 3;
	private static final int S = 4;
	private static final int SW = 5;
	private static final int W = 6;
	private static final int NW = 7;

	private static final int F = 0;
	private static final int HR = 1;
	private static final int HL = 2;
	private static final int R = 3;
	private static final int L = 4;
	private static final int HRB = 5;
	private static final int HLB = 6;

	// フィールド
	private int drawAB = ANT;						// 自律虫の描画
	public boolean configChanged = false;		// 描画設定変更フラグ
	public boolean pattern_flag = true;

	public int fpstep = 5;								// 一回の遷移に何回描画するか
	public int new_fpstep = 5;							// 変更用変数
	public int interval = 1;								// 描画間隔
	public int new_interval = 1;						// 変更用変数
	public int step = 0;									// 現在のターン数
	private int phase = 0;								// アニメーションの描画用

	public boolean drawDestFlag = false;	    // 自律虫の目的地描画フラグ
	public boolean drawBoardFlag = false; 	// 地面の描画フラグ
	public boolean drawGridFlag = true; 		// グリッドの描画フラグ


	// 行動制御点
	private ArrayList<ArrayList<Float>> px = null;
	private ArrayList<ArrayList<Float>> py = null;

	// ベジェ曲線に基づく座標とそのときの回転
	private ArrayList<ArrayList<Float>> bx = null;
	private ArrayList<ArrayList<Float>> by = null;
	private ArrayList<ArrayList<Float>> br = null;
	private ArrayList<ArrayList<Float>> new_bx = null;
	private ArrayList<ArrayList<Float>> new_by = null;
	private ArrayList<ArrayList<Float>> new_br = null;

	// オブジェクト(Sphere)の分割数
	public int p_ab = 5;
	public int new_p_ab = 5;
	public int p_abe = 5;
	public int new_p_abe = 5;
	public int p_fb = 5;
	public int new_p_fb = 5;

	// headingにあわせて虫を回転
	private float[] hr = null;

//	private int WIDTH = 200;
//	private int HEIGHT = 200;
	private float CAMERA = -20.5f;

	// ライト
	private float[] LPOSITION = { -10.0f, 10.0f, 10.0f, 0.0f };
	private float[] LSPECULAR = { 0.2f, 0.2f, 0.2f, 1.0f };
	private float[] LDIFFUSE = { 0.5f, 0.5f, 0.5f, 1.0f };
	private float[] LAMBIENT = { 0.8f, 0.8f, 0.8f, 1.0f };

	// 物体の反射率
	private float[] MSPECULAR = { 0.5f, 0.5f, 0.5f, 1.0f };
	private float[] MDIFFUSE = { 0.5f, 0.5f, 0.5f, 1.0f };
	private float[] MAMBIENT = { 0.5f, 0.5f, 0.5f, 1.0f };
	private float MSHININESS = 10.0f;

	private GL2 gl;
	private GLUT glut;

	private Texture texture;		// テクスチャー

	private int prevMouseX;
	private int prevMouseY;
	private float angleX = 0.0f;
	private float angleY = 0.0f;
	private float distanceX = 0.0f;
	private float distanceY = 0.0f;
	private float zoom = 1.0f;

	private int fb_count = 0;
	public int fb_diff_count;	// 餌虫を増やす際の差分数
	public int fb_diff_span;	// 餌虫を増やす際の差分時間

	// manager
	private Manager manager = null;

	// ティウン音
	private AudioClip clip = null;
	public boolean thiunFlag = false;

	// カメラフォーカス
	public boolean focusFlag = false;				// カメラのフォーカスフラグ
	public int focus_ab_key;							// フォーカスするオブジェクトのキー

    // 紙吹雪
	float cxf;
	float cyf;
	float[] cx = null;
	float[] cy = null;
	float[] cz = null;
	float[] cr = null;
	int drawCNum = 50;
	boolean confettiFlag = false;

	// コンストラクタ
	public GL_Event(Manager manager) {
		this.manager = manager;
		manager.glEvent = this;

		// Animatorの生成
		manager.animator = new Animator(manager.canvas);

		// 初期集団の生成
		manager.abs = new Autonomous_Bug_Set(manager);
		manager.fbs = new Food_Bug_Set(manager);

		int ab_id;
		for(int i=0;i<manager.abs.abs_init_count; i++){
			ab_id = manager.abs.getAB_ID();
			manager.abs.abSet.put(ab_id, new Autonomous_Bug(ab_id));
		}
		this.Generate_Food_Bug(this.manager, 1000-fb_diff_count);

		// 変数初期化
		fb_diff_count = manager.fbs.FB_DIFF_COUNT;
		fb_diff_span = manager.fbs.FB_DIFF_SPAN;

		// 行動制御点の初期化
		init_p();

		// 実際の点の初期化
		bx = new ArrayList<ArrayList<Float>>();
		by = new ArrayList<ArrayList<Float>>();
		br = new ArrayList<ArrayList<Float>>();
		init_b(bx,by,br);

		// hedingに合わせた向きの回転テーブルの初期化
		hr = new float[8];
		hr[N] = 0.0f;
		hr[NE] = 45.0f;
		hr[E] = 90.0f;
		hr[SE] = 135.0f;
		hr[S] = 180.0f;
		hr[SW] = -135.0f;
		hr[W] = -90.0f;
		hr[NW] = -45.0f;

		// ティウンティウン
        File file = new File("wav/rockman_thiunthiun.wav");
        try{
        	clip = Applet.newAudioClip(file.toURI().toURL());
        }
        catch(MalformedURLException mue){
        	System.err.println(mue);
        }
	}

	// 初期化
	public void init(GLAutoDrawable drawable) {

		gl = drawable.getGL().getGL2();
		glut = new GLUT();

		gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);	// 白で塗りつぶす

		gl.glEnable(GL.GL_DEPTH_TEST);		// 奥行判定
		gl.glEnable(GL.GL_CULL_FACE);			// 裏返った面を描画しない

		gl.glEnable(GL2.GL_LIGHTING);
		gl.glEnable(GL2.GL_LIGHT0);

		gl.glEnable(GL2.GL_NORMALIZE);

		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_POSITION, LPOSITION, 0);
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_SPECULAR, LSPECULAR, 0);
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_DIFFUSE, LDIFFUSE, 0);
		gl.glLightfv(GL2.GL_LIGHT0, GL2.GL_AMBIENT, LAMBIENT, 0);

		gl.glMaterialfv(GL2.GL_FRONT, GL2.GL_SPECULAR, MSPECULAR, 0);
		gl.glMaterialfv(GL2.GL_FRONT, GL2.GL_DIFFUSE, MDIFFUSE, 0);
		gl.glMaterialfv(GL2.GL_FRONT, GL2.GL_AMBIENT, MAMBIENT, 0);
		gl.glMaterialf(GL2.GL_FRONT, GL2.GL_SHININESS, MSHININESS);

        gl.glEnable(gl.GL_COLOR_MATERIAL);	// 色を塗ったものを有効化

        gl.glEnable(GL2.GL_TEXTURE_BINDING_2D);
       try {
            File imageFile = new File("jpg/grand_sample_tex.jpg");
            texture = TextureIO.newTexture(imageFile, true);
        } catch (IOException ex) {
            ex.printStackTrace();
        }
	}

	// 行動制御点の初期化メソッド
	public void init_p(){
		px = new ArrayList<ArrayList<Float>>();
		py = new ArrayList<ArrayList<Float>>();
		for(int i=0;i<7;i++){
			px.add(new ArrayList<Float>());
			py.add(new ArrayList<Float>());
		}

		px.get(F).add(0.0f);
		py.get(F).add(0.0f);
		px.get(F).add(0.0f);
		py.get(F).add(1.0f);

		px.get(HR).add(0.0f);
		py.get(HR).add(0.0f);
		px.get(HR).add(0.0f);
		py.get(HR).add(1.0f / (float)(2.0*Math.sqrt(2.0)));
		px.get(HR).add(1.0f / (float)(2.0*Math.sqrt(2.0)));
		py.get(HR).add(1.0f / (float)(2.0*Math.sqrt(2.0)));
		px.get(HR).add(1.0f / (float)(Math.sqrt(2.0)));
		py.get(HR).add(1.0f / (float)(Math.sqrt(2.0)));

		px.get(HL).add(0.0f);
		py.get(HL).add(0.0f);
		px.get(HL).add(0.0f);
		py.get(HL).add(1.0f / (float)(2.0*Math.sqrt(2.0)));
		px.get(HL).add(-1.0f / (float)(2.0*Math.sqrt(2.0)));
		py.get(HL).add(1.0f / (float)(2.0*Math.sqrt(2.0)));
		px.get(HL).add(-1.0f / (float)(Math.sqrt(2.0)));
		py.get(HL).add(1.0f / (float)(Math.sqrt(2.0)));

		px.get(R).add(0.0f);
		py.get(R).add(0.0f);
		px.get(R).add(0.25f);
		py.get(R).add(0.7f);
		px.get(R).add(0.5f);
		py.get(R).add(0.0f);
		px.get(R).add(1.0f);
		py.get(R).add(0.0f);

		px.get(L).add(0.0f);
		py.get(L).add(0.0f);
		px.get(L).add(-0.25f);
		py.get(L).add(0.7f);
		px.get(L).add(-0.5f);
		py.get(L).add(0.0f);
		px.get(L).add(-1.0f);
		py.get(L).add(0.0f);

		px.get(HRB).add(0.0f);
		py.get(HRB).add(0.0f);
		px.get(HRB).add(1.0f / (float)(4.0*Math.sqrt(2.0)));
		py.get(HRB).add(1.0f / (float)(2.0*Math.sqrt(2.0)));
		px.get(HRB).add(1.0f / (float)(2.0*Math.sqrt(2.0)));
		py.get(HRB).add(-1.0f / (float)(2.0*Math.sqrt(2.0)));
		px.get(HRB).add(1.0f / (float)(Math.sqrt(2.0)));
		py.get(HRB).add(-1.0f / (float)(Math.sqrt(2.0)));

		px.get(HLB).add(0.0f);
		py.get(HLB).add(0.0f);
		px.get(HLB).add(-1.0f / (float)(4.0*Math.sqrt(2.0)));
		py.get(HLB).add(1.0f / (float)(2.0*Math.sqrt(2.0)));
		px.get(HLB).add(-1.0f / (float)(2.0*Math.sqrt(2.0)));
		py.get(HLB).add(-1.0f / (float)(2.0*Math.sqrt(2.0)));
		px.get(HLB).add(-1.0f / (float)(Math.sqrt(2.0)));
		py.get(HLB).add(-1.0f / (float)(Math.sqrt(2.0)));
	}

	// ベジェに基づく実際の点の初期化メソッド
	public void init_b(ArrayList<ArrayList<Float>> tmp_bx, ArrayList<ArrayList<Float>> tmp_by, ArrayList<ArrayList<Float>> tmp_br){
		for(int i=0;i<7;i++){
			tmp_bx.add(new ArrayList<Float>());
			tmp_by.add(new ArrayList<Float>());
			tmp_br.add(new ArrayList<Float>());
		}

		// dt = 1/dps でそれぞれの位置と回転を求める
		for(int i=0;i<fpstep;i++){
			float t = (float)i / (float)fpstep;

			tmp_bx.get(F).add(0.0f);
			tmp_by.get(F).add(t);
			tmp_br.get(F).add(0.0f);

			tmp_bx.get(HR).add(calc3DBezierCurve(px.get(HR),t));
			tmp_by.get(HR).add(calc3DBezierCurve(py.get(HR),t));
			tmp_br.get(HR).add(calcR(HR, t));

			tmp_bx.get(HL).add(calc3DBezierCurve(px.get(HL),t));
			tmp_by.get(HL).add(calc3DBezierCurve(py.get(HL),t));
			tmp_br.get(HL).add(calcR(HL, t));

			tmp_bx.get(R).add(calc3DBezierCurve(px.get(R),t));
			tmp_by.get(R).add(calc3DBezierCurve(py.get(R),t));
			tmp_br.get(R).add(calcR(R, t));

			tmp_bx.get(L).add(calc3DBezierCurve(px.get(L),t));
			tmp_by.get(L).add(calc3DBezierCurve(py.get(L),t));
			tmp_br.get(L).add(calcR(L, t));

			tmp_bx.get(HRB).add(calc3DBezierCurve(px.get(HRB),t));
			tmp_by.get(HRB).add(calc3DBezierCurve(py.get(HRB),t));
			tmp_br.get(HRB).add(calcR(HRB, t));

			tmp_bx.get(HLB).add(calc3DBezierCurve(px.get(HLB),t));
			tmp_by.get(HLB).add(calc3DBezierCurve(py.get(HLB),t));
			tmp_br.get(HLB).add(calcR(HLB, t));
		}
	}

	// エサ虫生成メソッド
	public void Generate_Food_Bug(Manager manager, int diff) {
		for(int i = fb_count; i<fb_count+diff; i++) {
			manager.fbs.fbSet.put(i, new Food_Bug());
			manager.fbs.set_fb_Array(manager.fbs.fbSet.get(i).x,
					manager.fbs.fbSet.get(i).y, true);
		}
		fb_count += diff;
	}


	// エサ虫生成メソッド (集中散布)	[0522]
	public void Generate_Food_Bug_Convergence(Manager manager, int begin_point, int breadth) {
		for(int i = begin_point; i < begin_point+breadth; i++) {
			for(int j = begin_point; j < begin_point + breadth; j++) {
				manager.fbs.fbSet.put((i-begin_point)*breadth+j, new Food_Bug(j, i));
				manager.fbs.set_fb_Array(manager.fbs.fbSet.get(i).x, manager.fbs.fbSet.get(i).y, true);
			}
		}
		fb_count += breadth*breadth;
	}

	// ウィンドウサイズの更新時
	public void reshape(GLAutoDrawable drawable, int x, int y, int width,
			int height) {

//		if(height>width) height=width;
//		else width=height;

		float ratio = (float) height / (float) width;

		gl.glViewport(0, 0, width, height);

		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		gl.glFrustum(-1.0f, 1.0f, -ratio, ratio, 5.0f, 1000.0f);

		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();
		gl.glTranslatef(0.0f, 0.0f, CAMERA);
	}

	// 捨てられた時
	public void dispose(GLAutoDrawable drawable) {}

	// 描画メソッド
	public void display(GLAutoDrawable drawable) {

		// 描画設定変更が発生したとき
		checkConfigChanged();

		// n回回す
		for(int i=0;i<interval;i++){
			// phase%dps=0のときに状態更新
			if(phase%fpstep==0){
				renew();				// 状態更新
				//renew_food_bug();		// 餌虫動かす場合にはコメントアウト
			}
		}

		// Analysisのリペイント
		manager.painter_Analysis1.repaint();
		manager.painter_Analysis2.repaint();

		// 描画
		gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);

		gl.glPushMatrix();

		// フォーカスフラグにより切り替え
		if(focusFlag){
			// フォーカスする物体があるときのみ操作
			if(manager.abs.abSet.containsKey(focus_ab_key))
				focus();
		}
		else{
			// ズーム
			gl.glScalef(zoom, zoom, zoom);

			// マウスの移動量応じて移動
			gl.glTranslatef(distanceX, distanceY, 0.0f);

			// マウスの移動量に応じて回転
			gl.glRotatef(angleX, 1.0f, 0.0f, 0.0f);
			gl.glRotatef(angleY, 0.0f, 0.0f, 1.0f);
		}

		// boardの描画
		if(drawBoardFlag) drawBoard();

		// gridの描画
		if(drawGridFlag) drawGrid();

		// 枠の描画
		drawFrame();

		// 自律虫の描画
		drawAutonomousBugs();

		// エサ虫の描画
		drawFoodBugs();

		// 自律虫の目指している場所を塗る
		if(drawDestFlag)
			drawABDest();

		// 色を白に設定
		gl.glColor3f(1.0f, 1.0f, 1.0f);

		gl.glPopMatrix();

		// phase更新
		phase++;
//		System.out.println("bug:"+manager.abs.abSet.size());
		phase %= fpstep;

	}

	public void displayChanged(GLAutoDrawable drawable, boolean modeChanged,
			boolean deviceChanged) {
	}

	// 盤面の描画
	private void drawBoard(){
		// テクスチャ貼付け
        texture.enable();
        gl.glBindTexture(GL.GL_TEXTURE_2D,
          texture.getTextureObject());

		gl.glBegin(gl.GL_QUADS);
		gl.glTexCoord2f(1.0f, 1.0f);
		gl.glVertex3f(4.0f, 4.0f, -0.001f);
		gl.glTexCoord2f(0.0f, 1.0f);
		gl.glVertex3f(-4.0f, 4.0f, -0.001f);
		gl.glTexCoord2f(0.0f, 0.0f);
		gl.glVertex3f(-4.0f, -4.0f, -0.001f);
		gl.glTexCoord2f(1.0f, 0.0f);
		gl.glVertex3f(4.0f, -4.0f, -0.001f);
		gl.glEnd();

		texture.disable();
	}

	// 盤面のグリッドの描画
	private void drawGrid(){
		gl.glPushMatrix();

		Float tmp = 0.0f;

		// 中のグレーの線
		gl.glColor3f(0.75f, 0.75f, 0.75f);    			// 色をグレーに設定
		for(int i=1; i<100; i++){
			tmp = -400.0f + (float)(i*8);
			tmp /= 100.0f;

			// 縦線
			gl.glBegin(gl.GL_LINES);
			gl.glVertex3f(tmp, -4.0f, 0.0f);
			gl.glVertex3f(tmp, 4.0f, 0.0f);
			gl.glEnd();

			// 横線
			gl.glBegin(gl.GL_LINES);
			gl.glVertex3f(-4.0f, tmp, 0.0f);
			gl.glVertex3f(4.0f, tmp, 0.0f);
			gl.glEnd();
		}

		gl.glPopMatrix();
	}

	// 枠描画
	private void drawFrame(){
		gl.glPushMatrix();

		// 外の黒の線
		gl.glColor3f(0.0f, 0.0f, 0.0f);    			// 色を黒に設定
		// 左
		gl.glBegin(gl.GL_LINES);
		gl.glVertex3f(-4.0f, -4.0f, 0.0f);
		gl.glVertex3f(-4.0f, 4.0f, 0.0f);
		gl.glEnd();

		// 上
		gl.glBegin(gl.GL_LINES);
		gl.glVertex3f(-4.0f, -4.0f, 0.0f);
		gl.glVertex3f(4.0f, -4.0f, 0.0f);
		gl.glEnd();

		// 右
		float tmp = -400.0f + (float)(800);
		tmp /= 100.0f;
		gl.glBegin(gl.GL_LINES);
		gl.glVertex3f(tmp, -4.0f, 0.0f);
		gl.glVertex3f(tmp, 4.0f, 0.0f);
		gl.glEnd();

		// 上
		tmp = -400.0f + (float)(800);
		tmp /= 100.0f;
		gl.glBegin(gl.GL_LINES);
		gl.glVertex3f(-4.0f, tmp, 0.0f);
		gl.glVertex3f(4.0f, tmp, 0.0f);
		gl.glEnd();

		gl.glPopMatrix();
	}

	// 自律虫達の描画
	private void drawAutonomousBugs(){
		try{
			if(drawAB==ANT)
				for(int key : manager.abs.abSet.keySet())
					drawAutonomousBug(manager.abs.abSet.get(key));

			else
				for(int key : manager.abs.abSet.keySet())
					drawAutonomousBug_Sphere(manager.abs.abSet.get(key));

		}
		catch(NullPointerException ne){
			System.err.println(ne);
		}
	}

	// 自律虫の描画
	private void drawAutonomousBug(Autonomous_Bug ab){
		gl.glPushMatrix();
		// 条件で色を変える
		// フォーカスされているとき
		if(ab.id == manager.glEvent.focus_ab_key && focusFlag){
			gl.glColor3f(1.0f, 0.4f, 0.0f);    					// 色をオレンジに設定
			// さらにconfettiFlagがたっているときに
			if(confettiFlag)
				drawConfetti(ab.x, ab.y);
		}
		// エネルギーに余裕があるとき
		else if(ab.energy > ab.energy_rest){
			gl.glColor3f(1.0f, 0.0f, 0.0f);    					// 色を赤に設定
		}
		// 余裕がないとき
		else
			gl.glColor3f(0.8f, 0.0f, 1.0f);    						// 色をピンクに設定
    	// 危険ゾーンかどうかで色を変え、位置をずらす
    	if(ab.energy > ab.energy_rest){
    		ab.rest=0;

    		float tmpx = -400.0f + (float)(ab.lastX*8) + 4.0f;
    		float tmpy = 400.0f - (float)(ab.lastY*8) - 4.0f;
    		tmpx /= 100.0f;
    		tmpy /= 100.0f;

        	gl.glTranslatef(tmpx, tmpy, 0.013f);									// 座標の移動

        	gl.glRotatef(-hr[ab.lastH], 0.0f, 0.0f, 1.0f);							// headingに向きを変更

    		//gl.glColor3f(1.0f, 0.0f, 0.0f);    					// 色を赤に設定
        	// phaseに基づき位置をずらす
        	if(ab.heading%2==0)
        		gl.glTranslatef(8.0f * bx.get(ab.move).get(phase) / 100.0f, 8.0f * by.get(ab.move).get(phase) / 100.0f, 0.0f);
        	else
        		gl.glTranslatef((float)(Math.sqrt(2.0f)) * 8.0f * bx.get(ab.move).get(phase) / 100.0f, (float)(Math.sqrt(2.0f)) * 8.0f * by.get(ab.move).get(phase) / 100.0f, 0.0f);

        	gl.glRotatef(-br.get(ab.move).get(phase), 0.0f, 0.0f, 1.0f);		// さらに進行方向に向きを変更
    	}
    	else{
    		float tmpx=0f, tmpy=0f;
    		if(ab.rest==0){
        		tmpx = -400.0f + (float)(ab.lastX*8) + 4.0f;
        		tmpy = 400.0f - (float)(ab.lastY*8) - 4.0f;

        		tmpx /= 100.0f;
        		tmpy /= 100.0f;

            	gl.glTranslatef(tmpx, tmpy, 0.013f);				// 座標の移動

            	gl.glRotatef(-hr[ab.lastH], 0.0f, 0.0f, 1.0f);		// headingに向きを変更

        	//	gl.glColor3f(0.8f, 0.0f, 1.0f);    						// 色をピンクに設定

    	    	// phaseに基づき位置をずらす
    	    	if(ab.heading%2==0)
    	    		gl.glTranslatef(8.0f * bx.get(ab.move).get(phase) / 100.0f, 8.0f * by.get(ab.move).get(phase) / 100.0f, 0.0f);
    	    	else
    	    		gl.glTranslatef((float)(Math.sqrt(2.0f)) * 8.0f * bx.get(ab.move).get(phase) / 100.0f, (float)(Math.sqrt(2.0f)) * 8.0f * by.get(ab.move).get(phase) / 100.0f, 0.0f);

    	    	gl.glRotatef(-br.get(ab.move).get(phase), 0.0f, 0.0f, 1.0f);		// さらに進行方向に向きを変更
    		}
    		else{
        		tmpx = -400.0f + (float)(ab.x*8) + 4.0f;
        		tmpy = 400.0f - (float)(ab.y*8) - 4.0f;

        		tmpx /= 100.0f;
        		tmpy /= 100.0f;

            	gl.glTranslatef(tmpx, tmpy, 0.013f);				// 座標の移動

            	gl.glRotatef(-hr[ab.heading], 0.0f, 0.0f, 1.0f);		// headingに向きを変更

        	//	gl.glColor3f(0.8f, 0.0f, 1.0f);    						// 色をピンクに設定
    		}
    	}

    	drawABM();												// 自律虫の描画

		gl.glPopMatrix();
	}

	// 自律虫モデル
	private void drawABM(){
		gl.glPushMatrix();
		// 全体のスケール調整
		gl.glScalef(0.01f, 0.01f, 0.01f);

        // 触覚
        // 右
        gl.glPushMatrix();
        gl.glTranslatef(0.2f, 3.4f, 0.0f);
        gl.glRotatef(-20.0f, 0.0f, 0.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.2f, 1.0f);
        gl.glVertex3f(0.0f, 0.7f, 0.7f);
        gl.glEnd();
        gl.glPopMatrix();
        // 左
        gl.glPushMatrix();
        gl.glTranslatef(-0.2f, 3.4f, 0.0f);
        gl.glRotatef(20.0f, 0.0f, 0.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.2f, 1.0f);
        gl.glVertex3f(0.0f, 0.7f, 0.7f);
        gl.glEnd();
        gl.glPopMatrix();

        // 頭
        gl.glPushMatrix();
        gl.glTranslatef(0.0f, 2.4f, 0.0f);
        gl.glScalef(1.0f, 1.13f, 1.0f);
        glut.glutSolidSphere(1.1f, p_ab, p_ab);
        gl.glPopMatrix();

        // 足
        // 前右足
        gl.glPushMatrix();
        gl.glRotatef(40.0f, 0.0f, 0.0f, 1.0f);
        gl.glScalef(1.305f, 1.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(1.1f, 0.0f, 1.1f);
        gl.glVertex3f(2.0f, 0.0f, -1.3f);
        gl.glEnd();
        gl.glPopMatrix();
        // 前左足
        gl.glPushMatrix();
        gl.glRotatef(-40.0f, 0.0f, 0.0f, 1.0f);
        gl.glScalef(1.305f, 1.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(-1.1f, 0.0f, 1.1f);
        gl.glVertex3f(-2.0f, 0.0f, -1.3f);
        gl.glEnd();
        gl.glPopMatrix();
        // 中右足
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(1.1f, 0.0f, 1.1f);
        gl.glVertex3f(2.0f, 0.0f, -1.3f);
        gl.glEnd();
        // 中左足
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(-1.1f, 0.0f, 1.1f);
        gl.glVertex3f(-2.0f, 0.0f, -1.3f);
        gl.glEnd();
        // 後右足
        gl.glPushMatrix();
        gl.glRotatef(-40.0f, 0.0f, 0.0f, 1.0f);
        gl.glScalef(1.305f, 1.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(1.1f, 0.0f, 1.1f);
        gl.glVertex3f(2.0f, 0.0f, -1.3f);
        gl.glEnd();
        gl.glPopMatrix();
        // 後左足
        gl.glPushMatrix();
        gl.glRotatef(40.0f, 0.0f, 0.0f, 1.0f);
        gl.glScalef(1.305f, 1.0f, 1.0f);
        gl.glBegin(gl.GL_LINE_STRIP);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(-1.1f, 0.0f, 1.1f);
        gl.glVertex3f(-2.0f, 0.0f, -1.3f);
        gl.glEnd();
        gl.glPopMatrix();

        // 真ん中
        gl.glPushMatrix();
        gl.glScalef(1.0f, 1.5625f, 1.0f);
        glut.glutSolidSphere(0.8f, p_ab, p_ab);
        gl.glPopMatrix();

        // おしり
        gl.glPushMatrix();
        gl.glTranslatef(0.0f, -2.7f, 0.0f);
        gl.glScalef(1.0f, 1.15f, 1.0f);
        glut.glutSolidSphere(1.3f, p_ab, p_ab);
        gl.glPopMatrix();

        gl.glPopMatrix();
	}

	// 自律虫(球)の描画
	private void drawAutonomousBug_Sphere(Autonomous_Bug ab){
		gl.glPushMatrix();

    	// 危険ゾーンかどうかで色を変え、位置をずらす
    	if(ab.energy > ab.energy_rest){
    		ab.rest=0;

    		float tmpx = -400.0f + (float)(ab.lastX*8) + 4.0f;
    		float tmpy = 400.0f - (float)(ab.lastY*8) - 4.0f;
    		tmpx /= 100.0f;
    		tmpy /= 100.0f;

        	gl.glTranslatef(tmpx, tmpy, 0.013f);									// 座標の移動

        	gl.glRotatef(-hr[ab.lastH], 0.0f, 0.0f, 1.0f);							// headingに向きを変更

    		gl.glColor3f(1.0f, 0.0f, 0.0f);    					// 色を赤に設定
        	// phaseに基づき位置をずらす
        	if(ab.heading%2==0)
        		gl.glTranslatef(8.0f * bx.get(ab.move).get(phase) / 100.0f, 8.0f * by.get(ab.move).get(phase) / 100.0f, 0.0f);
        	else
        		gl.glTranslatef((float)(Math.sqrt(2.0f)) * 8.0f * bx.get(ab.move).get(phase) / 100.0f, (float)(Math.sqrt(2.0f)) * 8.0f * by.get(ab.move).get(phase) / 100.0f, 0.0f);

        	gl.glRotatef(-br.get(ab.move).get(phase), 0.0f, 0.0f, 1.0f);		// さらに進行方向に向きを変更
    	}
    	else{
    		float tmpx=0f, tmpy=0f;
    		if(ab.rest==0){
        		tmpx = -400.0f + (float)(ab.lastX*8) + 4.0f;
        		tmpy = 400.0f - (float)(ab.lastY*8) - 4.0f;

        		tmpx /= 100.0f;
        		tmpy /= 100.0f;

            	gl.glTranslatef(tmpx, tmpy, 0.013f);				// 座標の移動

            	gl.glRotatef(-hr[ab.lastH], 0.0f, 0.0f, 1.0f);		// headingに向きを変更

        		gl.glColor3f(0.8f, 0.0f, 1.0f);    						// 色をピンクに設定

    	    	// phaseに基づき位置をずらす
    	    	if(ab.heading%2==0)
    	    		gl.glTranslatef(8.0f * bx.get(ab.move).get(phase) / 100.0f, 8.0f * by.get(ab.move).get(phase) / 100.0f, 0.0f);
    	    	else
    	    		gl.glTranslatef((float)(Math.sqrt(2.0f)) * 8.0f * bx.get(ab.move).get(phase) / 100.0f, (float)(Math.sqrt(2.0f)) * 8.0f * by.get(ab.move).get(phase) / 100.0f, 0.0f);

    	    	gl.glRotatef(-br.get(ab.move).get(phase), 0.0f, 0.0f, 1.0f);		// さらに進行方向に向きを変更
    		}
    		else{
        		tmpx = -400.0f + (float)(ab.x*8) + 4.0f;
        		tmpy = 400.0f - (float)(ab.y*8) - 4.0f;

        		tmpx /= 100.0f;
        		tmpy /= 100.0f;

            	gl.glTranslatef(tmpx, tmpy, 0.013f);				// 座標の移動

            	gl.glRotatef(-hr[ab.heading], 0.0f, 0.0f, 1.0f);		// headingに向きを変更

        		gl.glColor3f(0.8f, 0.0f, 1.0f);    						// 色をピンクに設定
    		}
    	}

    	glut.glutSolidSphere(0.04, p_abe, p_abe);								// 自律虫(球)の描画

		gl.glPopMatrix();
	}

	// 餌虫を描くメソッド
	private void drawFoodBugs(){
		boolean draw_food_bug_flag = true;
		int fb_count = manager.glEvent.get_fb_count();
		// 自律虫と同じ座標なら描画しないフラグを立てる
		for(int i=0; i<fb_count; i++) {
			if(manager.fbs.fbSet.get(i) != null){
				draw_food_bug_flag = true;
				for(int j=0; j<manager.abs.getCurrentAbsCount(); j++) {
					if(manager.abs.abSet.get(j)!=null) {
						if(manager.fbs.fbSet.get(i).x==manager.abs.abSet.get(j).x &&
								manager.fbs.fbSet.get(i).y==manager.abs.abSet.get(j).y) {
							draw_food_bug_flag = false;
							break;
						}
					}
				}
				drawFoodBug(manager.fbs.fbSet.get(i), i, draw_food_bug_flag);
				//if(i==0)
				//	System.out.println(manager.fbs.fbSet.get(i).energy);
			}
		}
	}

	// 各餌虫を描くメソッド
	private void drawFoodBug(Food_Bug fb, int fb_number, boolean flag){
		if(flag){
			float tmpx = -400.0f + (float)(fb.x*8) + 4.0f;
			float tmpy = 400.0f - (float)(fb.y*8) - 4.0f;
			tmpx /= 100.0f;
			tmpy /= 100.0f;

			gl.glPushMatrix();

	    	gl.glColor3f(0.0f, 0.0f, 1.0f);    										// 色を青に設定
	    	gl.glTranslatef(tmpx, tmpy, 0.02f);									// 座標の移動

	    	glut.glutSolidSphere(0.02, p_fb, p_fb);										// 餌虫(球)の描画

			gl.glPopMatrix();
			manager.fbs.fb_array[fb.x][fb.y] = true;	// 存在判定をtrue	[0521]
		}
		else {
			manager.fbs.fbSet.remove(fb_number);
			manager.fbs.fb_array[fb.x][fb.y] = false;	// 存在判定をfalse	[0521]
		}
	}

	// 自律虫の目的地を描画するメソッド
	private void drawABDest(){
		try{
			for(int key : manager.abs.abSet.keySet()) {
				if(manager.abs.abSet.get(key)!=null) {
					float tmpx = -400.0f + (float)(manager.abs.abSet.get(key).x*8) + 4.0f;
					float tmpy = 400.0f - (float)(manager.abs.abSet.get(key).y*8) - 4.0f;
					tmpx /= 100.0f;
					tmpy /= 100.0f;

					gl.glPushMatrix();

					gl.glTranslatef(tmpx, tmpy, 0.0f);									// 座標の移動

					// 自律虫の目的地を描画
					gl.glBegin(gl.GL_QUADS);
					gl.glColor3f(1.0f, 0.6f, 0.4f);    										// 色を淡い赤に設定
					gl.glVertex3f(0.04f, 0.04f, 0.0f);
					gl.glVertex3f(-0.04f, 0.04f, 0.0f);
					gl.glVertex3f(-0.04f, -0.04f, 0.0f);
					gl.glVertex3f(0.04f, -0.04f, 0.0f);
					gl.glEnd();

					gl.glPopMatrix();
				}
			}
		}
		catch(NullPointerException ne){
			System.err.println(ne);
		}
	}

	// 設定変更が発生したか確かめるメソッド
	private synchronized void checkConfigChanged(){
		// 変更があれば更新
		if(configChanged){
			configChanged = false;
			// 描画間隔の変更
			if(interval!=new_interval){
				interval = new_interval;
			}
			if(fpstep!=new_fpstep){
				fpstep = new_fpstep;
				phase = 0;
				new_bx = new ArrayList<ArrayList<Float>>();
				new_by = new ArrayList<ArrayList<Float>>();
				new_br = new ArrayList<ArrayList<Float>>();
				init_b(new_bx,new_by,new_br);
				bx = new_bx;
				by = new_by;
				br = new_br;
			}
			// 自律虫のポリゴン分割数の変更
			if(p_ab!=new_p_ab){
				p_ab = new_p_ab;
			}
			// 自律虫(簡易)のポリゴン分割数の変更
			if(p_abe!=new_p_abe){
				p_abe = new_p_abe;
			}
			// 餌虫のポリゴン分割数の変更
			if(p_fb!=new_p_fb){
				p_fb = new_p_fb;
			}
		}
	}

	// 状態更新メソッド
	public synchronized void renew(){
		// エサをまく
		if(step%fb_diff_span==0) {
			if(!pattern_flag){
				// 集中散布
				this.Generate_Food_Bug_Convergence(manager, food_first_point, food_breadth);
			}else{
				// 一様散布
				this.Generate_Food_Bug(manager, fb_diff_count);
			}
		}

		// 虫の行動
		Autonomous_Bug tmp_ab;
		LinkedList<Integer> rm_ab_key_set = new LinkedList<Integer>();
		LinkedList<Autonomous_Bug> putAB = new LinkedList<Autonomous_Bug>();
		for(int i=0;i<100;i++)
			for(int j=0;j<100;j++)
				manager.abs.ab_coordinate.get(i).get(j).clear();

		for(int key : manager.abs.abSet.keySet()){
			tmp_ab = manager.abs.abSet.get(key);

			// 行動させる
			// 体力が危機的ならrest_turnに一回行動
			int ab_state = 0;
			// 歳を取らせる [0521]
			tmp_ab.addStep();

			if(tmp_ab.energy < tmp_ab.energy_rest){
				if(tmp_ab.rest==tmp_ab.rest_turn){
					ab_state = tmp_ab.action();
					tmp_ab.rest = 0;
				}
				else
					tmp_ab.rest++;
			}
			else
				ab_state = tmp_ab.action();

			// 自律虫の状態で分岐
			// 死亡した場合
			if(ab_state == Autonomous_Bug.DEATH){
				rm_ab_key_set.add(tmp_ab.id);						// 削除リストに登録
				continue;
			}

			// 分裂する場合
			if(ab_state == Autonomous_Bug.DIV){
				// 自分のエネルギーを半分にする
				tmp_ab.setEnergy();
				// 自分の評価テーブルを半分にする
				tmp_ab.setHalfTable();
				// 追加リストに登録
				putAB.add(new Autonomous_Bug(manager.abs.getAB_ID(),
						(tmp_ab.x+1)%100,
						(tmp_ab.y)%100,
						Autonomous_Bug_Set.energy_half,
						tmp_ab.table));

				// ID番号を増やす
				manager.abs.absIncrement();
			}

			// 座標を配列に登録
			manager.abs.ab_coordinate.get(tmp_ab.x).get(tmp_ab.y).add(tmp_ab);
		}

		// 死んだ虫の削除
		if(rm_ab_key_set.size()>0){
			for(int rm_key : rm_ab_key_set){
				manager.abs.abSet.remove(rm_key);
				manager.abs.absDecrement();
			}
			if(thiunFlag) clip.play();		// ティウンティウン
		}

		// 追加する虫が入れば追加
		if(putAB.size()>0){
			for(Autonomous_Bug t_ab : putAB){
				manager.abs.abSet.put(t_ab.id, t_ab);
				t_ab.action();
			}
		}

		// 餌虫がいればエネルギー増加と行動評価	[0521]
		// 餌はそのマスにいる自律虫の数で割る
		Food_Bug t_fb;
		LinkedList<Integer> rm_fb_key_set = new LinkedList<Integer>();
		for(int key : manager.fbs.fbSet.keySet()){
			t_fb = manager.fbs.fbSet.get(key);
			// そのマスの自律虫すべてに餌を与える
			if(manager.abs.ab_coordinate.get(t_fb.x).get(t_fb.y).size() > 0){
				for(Autonomous_Bug t_ab : manager.abs.ab_coordinate.get(t_fb.x).get(t_fb.y)){
					t_ab.increaseEnergy(manager.abs.ab_coordinate.get(t_fb.x).get(t_fb.y).size());
					t_ab.setTable();
				}
				// この餌虫を除去リストに追加
				rm_fb_key_set.add(key);
				manager.fbs.fb_array[t_fb.x][t_fb.y] = false;	// 存在判定をfalse	[0521]
			}
		}

		// 食べられた餌虫の削除
		if(rm_fb_key_set.size()>0)
			for(int rm_key : rm_fb_key_set)
				manager.fbs.fbSet.remove(rm_key);

		step++;

		//System.out.println("count:"+manager.abs.abSet.size());
		if(manager.abs.getMaxAbsCount()<manager.abs.abSet.size())
			manager.abs.setMaxAbsCount(manager.abs.abSet.size());
		if(manager.fbs.getMaxFbsCount()<manager.fbs.fbSet.size())
			manager.fbs.setMaxFbsCount(manager.fbs.fbSet.size());
	}

	// 3次ベジェ曲線の座標を返すメソッド(x or y)
	public float calc3DBezierCurve(ArrayList<Float> P, float t){
		float tmp = (1.0f - t) * (1.0f - t) * (1.0f - t) * P.get(0) + 3.0f * (1.0f - t) * (1.0f - t) * t * P.get(1)
			+ 3.0f * (1.0f - t) * t * t * P.get(2) + t * t * t * P.get(3);

		return tmp;
	}

	// 3次ベジェ曲線の時間微分を返すメソッド(x or y)
	public float calcDelta3DBezierCurve(ArrayList<Float> P, float t){
		float tmp = -3.0f * (1.0f - t) * (1.0f - t) * P.get(0) + (3.0f - 12.0f * t + 9.0f * t * t) * P.get(1)
						+ (6.0f * t - 9.0f * t * t) * P.get(2) + 3.0f * t * t * P.get(3);
		return tmp;
	}

	// 回転角を求めるメソッド
	public float calcR(int num, float t){
		double tmpx = (double)calcDelta3DBezierCurve(px.get(num),t);
		double tmpy = (double)calcDelta3DBezierCurve(py.get(num),t);

		float theta = (float)(Math.atan(tmpx/tmpy) * 180.0 / Math.PI);
		if(tmpx>0 && tmpy<0) theta += 180.0f;
		if(tmpx<0 && tmpy<0) theta -= 180.0f;

		return theta;
	}

	// フォーカスメソッド
	private void focus(){
		Autonomous_Bug t_ab = manager.abs.abSet.get(focus_ab_key);

		// ズーム
		gl.glScalef(zoom, zoom, zoom);

		// 回転
		gl.glRotatef(-45.0f, 1.0f, 0.0f, 0.0f);
		gl.glRotatef(-45.0f, 0.0f, 0.0f, 1.0f);

		// ターゲットに移動
       	// 危険ゾーンかどうかで色を変え、位置をずらす
    	if(t_ab.energy > t_ab.energy_rest || t_ab.rest==0){
    		t_ab.rest=0;

    		float tmpx = -400.0f + (float)(t_ab.lastX*8) + 4.0f;
    		float tmpy = 400.0f - (float)(t_ab.lastY*8) - 4.0f;
    		tmpx /= 100.0f;
    		tmpy /= 100.0f;

        	gl.glTranslatef(-tmpx, -tmpy, 0.0f);									// 座標の移動

        	gl.glRotatef(-hr[t_ab.lastH], 0.0f, 0.0f, 1.0f);					// 向きを変更

        	// phaseに基づき位置をずらす
        	if(t_ab.heading%2==0)
        		gl.glTranslatef(-8.0f * bx.get(t_ab.move).get(phase) / 100.0f, -8.0f * by.get(t_ab.move).get(phase) / 100.0f, 0.0f);
        	else
        		gl.glTranslatef((float)(Math.sqrt(2.0f)) * -8.0f * bx.get(t_ab.move).get(phase) / 100.0f, (float)(Math.sqrt(2.0f)) * -8.0f * by.get(t_ab.move).get(phase) / 100.0f, 0.0f);

        	gl.glRotatef(hr[t_ab.lastH], 0.0f, 0.0f, 1.0f);						// もとに戻す
    	}
    	else{
    		float tmpx=0f, tmpy=0f;
    		tmpx = -400.0f + (float)(t_ab.x*8) + 4.0f;
    		tmpy = 400.0f - (float)(t_ab.y*8) - 4.0f;

    		tmpx /= 100.0f;
    		tmpy /= 100.0f;

    		gl.glTranslatef(-tmpx, -tmpy, 0.0f);				// 座標の移動
    	}
	}

	// 紙吹雪をばら撒くメソッド
	private void drawConfetti(int xx, int yy){
		gl.glPushMatrix();

		// 空の状態で呼び出すと紙吹雪を新規に生成
		if(cy==null){
			// 指定座標の計算
    		float tmpx = -400.0f + (float)(xx*8) + 4.0f;
    		float tmpy = 400.0f - (float)(yy*8) - 4.0f;
    		cxf = tmpx / 100.0f;
    		cyf = tmpy / 100.0f;

        	// 個体生成
    		cx = new float[drawCNum];
    		cy = new float[drawCNum];
    		cz = new float[drawCNum];
    		cr = new float[drawCNum];
    		for(int i=0;i<drawCNum;i++){
    			cx[i] = (cxf + (float)Math.random()*0.5f - 0.25f);
    			cy[i] = (cyf + (float)Math.random()*0.5f - 0.25f);
    			cz[i] = (0.25f + (float)Math.random()*0.5f - 0.025f);
    			cr[i] = ((float)(360.0f*Math.random()));
    		}
		}

		// 描画
		for(int i=0;i<cx.length;i++){
			gl.glPushMatrix();

	    	// 移動
	    	float tmp_cy = cy[i] + (float)Math.sin(Math.PI * (double)phase / (double)fpstep) / 20.0f;
	    	cz[i] -= (float)(Math.abs(Math.sin(Math.PI * (double)phase / (double)fpstep))) / 200.0f;
	    	if(cz[i]<0) cz[i] += 0.5f;
	    	gl.glTranslatef(cx[i], tmp_cy, cz[i]);

	    	// 回転その1
	    	gl.glRotatef(cr[i], 0.0f, 0.0f, 1.0f);

	    	// 回転その2
	    	float dy = (float)-Math.cos(Math.PI * (double)phase / (double)fpstep);
	    	float dz = (float)-(Math.abs(Math.sin(Math.PI * (double)phase / (double)fpstep))) / 10.0f;
	    	float theta = 0.0f;
	    	if(dy!=0.0f) theta = (float)(Math.atan(dz/dy) * 180.0 / Math.PI);
	    	else theta = 90.0f;

	    	gl.glRotatef(theta, 1.0f, 0.0f, 0.0f);

	    	// 紙切れを描画(表と裏)
	    	gl.glScalef(0.01f, 0.01f, 0.01f);
	    	gl.glColor3f(1.0f, 0.6f, 0.0f);
	    	gl.glBegin(gl.GL_TRIANGLES);
	    	gl.glVertex3f(-1.0f, (float)(-Math.sqrt(3)/2), 0.0f);
	    	gl.glVertex3f(1.0f, (float)(-Math.sqrt(3)/2), 0.0f);
	    	gl.glVertex3f(0.0f, (float)(Math.sqrt(3)/2), 0.0f);
	    	gl.glEnd();
	    	gl.glColor3f(1.0f, 0.6f, 0.0f);
	    	gl.glBegin(gl.GL_TRIANGLES);
	    	gl.glVertex3f(-1.0f, (float)(-Math.sqrt(3)/2), 0.0f);
	    	gl.glVertex3f(0.0f, (float)(Math.sqrt(3)/2), 0.0f);
	    	gl.glVertex3f(1.0f, (float)(-Math.sqrt(3)/2), 0.0f);
	    	gl.glEnd();

	    	gl.glPopMatrix();
		}

		gl.glPopMatrix();
	}

	// MouseListener
	// ドラッグ
	public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();

        if (e.isShiftDown()) {
            // 移動量の算出
            float diffX = (float)(x - prevMouseX)/10.0f;
            float diffY = (float)(prevMouseY - y)/10.0f;

            // 移動量の更新
            distanceX += diffX;
            distanceY += diffY;
        } else {
            Dimension size = e.getComponent().getSize();

            // 回転量の算出
            // ウィンドウの端から端までで、360度回転するようにする
            float thetaY = 360.0f * ((float)(x-prevMouseX)/size.width);
            float thetaX = 360.0f * ((float)(prevMouseY-y)/size.height);

            // 角度の更新
            angleX -= thetaX;
            angleY += thetaY;
        }

        // 現在のマウスの位置を保存
        prevMouseX = x;
        prevMouseY = y;
	}

	public void mouseMoved(MouseEvent e) {}

	public void mouseClicked(MouseEvent e) {

	}

	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}

	// マウスを押したとき
	public void mousePressed(MouseEvent e) {
        prevMouseX = e.getX();
        prevMouseY = e.getY();
	}

	public void mouseReleased(MouseEvent e) {}

	// KeyListener
	public void keyPressed(KeyEvent e) {
		// ズームイン
		if(e.getKeyChar()=='j'){
			zoom += 1.0f;
		}
		// ズームアウト
		if(e.getKeyChar()=='k'){
			if(zoom > 1.0f)
				zoom -= 1.0f;
		}
	}

	public void keyReleased(KeyEvent e) {}

	public void keyTyped(KeyEvent e) {
		// カメラリセット
		if(e.getKeyChar()=='r'){
			angleX = 0.0f;
			angleY = 0.0f;
			distanceX = 0.0f;
			distanceY = 0.0f;
			zoom = 1.0f;
		}
		// 自律虫の描画チェンジ
		if(e.getKeyChar()=='c'){
			if(drawAB<1)
				drawAB++;
			else
				drawAB=0;
		}
		// 自律虫の目的地を描画をするかどうか
		if(e.getKeyChar()=='d'){
			drawDestFlag^=true;
		}
		// 背景を描画するかどうか
		if(e.getKeyChar()=='b'){
			drawBoardFlag^=true;
		}
		// グリッドを描画するかどうか
		if(e.getKeyChar()=='g'){
			drawGridFlag^=true;
		}
		// ティウンティウン
		if(e.getKeyChar()=='t'){
			thiunFlag^=true;
		}
		// カメラフォーカスフラグ
		if(e.getKeyChar()=='f'){
			if(!focusFlag) zoom =12;
			else zoom = 1;
			focusFlag^=true;
		}
		// 紙吹雪フラグ
		if(e.getKeyChar()=='h'){
			confettiFlag^=true;
		}
	}

	// getter
	public int get_fb_count(){
		return fb_count;
	}
}